/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport.action;

import java.util.Collections;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.NatTableDim;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCellDim;
import org.eclipse.statet.ecommons.waltable.selection.SelectionFlags;
import org.eclipse.statet.ecommons.waltable.ui.action.IMouseAction;
import org.eclipse.statet.ecommons.waltable.viewport.ViewportSelectDimPositionsCommand;
import org.eclipse.swt.events.MouseEvent;

public class ViewportSelectDimPositionsAction
implements IMouseAction {
    private final Orientation orientation;

    public ViewportSelectDimPositionsAction(Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public void run(NatTable natTable, MouseEvent event) {
        ILayerCell cell = natTable.getCellByPosition(natTable.getColumnPositionByX(event.x), natTable.getRowPositionByY(event.y));
        if (cell == null) {
            return;
        }
        NatTableDim layerDim = natTable.getDim(this.orientation);
        ILayerCellDim cellDim = cell.getDim(this.orientation);
        if (cellDim.getPositionSpan() > 1L) {
            List<LRange> positions = Collections.singletonList(new LRange(cellDim.getOriginPosition(), cellDim.getOriginPosition() + cellDim.getPositionSpan()));
            natTable.doCommand(new ViewportSelectDimPositionsCommand(layerDim, cellDim.getPosition(), positions, cellDim.getPosition(), SelectionFlags.swt2Flags(event.stateMask)));
        } else {
            natTable.doCommand(new ViewportSelectDimPositionsCommand((ILayerDim)layerDim, cellDim.getPosition(), SelectionFlags.swt2Flags(event.stateMask)));
        }
    }
}

