/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.model.LtxSourceUnitModelInfo;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.ecommons.runtime.core.util.MessageBuilder;
import org.eclipse.statet.internal.docmlet.tex.core.model.ProblemMessages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.BasicProblem;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.element.NameAccessSet;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

public class LtxProblemModelCheck {
    private static final int REF_LABEL_LIMIT = 50;
    private static final int BUFFER_SIZE = 100;
    private SourceUnit currentUnit;
    private String currentText;
    private TextLineInformation currentLines;
    private ProblemRequestor currentRequestor;
    private final MessageBuilder messageBuilder = new MessageBuilder();
    private final List<Problem> problemBuffer = new ArrayList<Problem>(100);
    private final int levelRefUndefined = 1;

    public void run(TexSourceUnit su, SourceContent content, LtxSourceUnitModelInfo model, ProblemRequestor requestor) {
        try {
            this.currentUnit = su;
            this.currentText = content.getText();
            this.currentLines = content.getLines();
            this.currentRequestor = requestor;
            this.checkLabels(model);
            if (this.problemBuffer.size() > 0) {
                this.currentRequestor.acceptProblems("Ltx", this.problemBuffer);
            }
        }
        finally {
            this.problemBuffer.clear();
            this.currentUnit = null;
            this.currentRequestor = null;
        }
    }

    private void checkLabels(LtxSourceUnitModelInfo model) {
        NameAccessSet<TexNameAccess> labelSet = model.getLabels();
        ImList labels = labelSet.getNames();
        block0: for (String label : labels) {
            if (label == null || label.length() <= 0) continue;
            ImList accessList = labelSet.getAllInUnit(label);
            for (TexNameAccess access : accessList) {
                if (access.isWriteAccess()) continue block0;
            }
            for (TexNameAccess access : accessList) {
                TexAstNode nameNode = (TexAstNode)access.getNameNode();
                this.addProblem(1, 8497, this.messageBuilder.bind(ProblemMessages.Labels_UndefinedRef_message, (Object)access.getDisplayName()), nameNode.getStartOffset(), nameNode.getEndOffset());
            }
        }
    }

    protected final void addProblem(int severity, int code, String message, int startOffset, int endOffset) {
        if (startOffset < 0) {
            startOffset = 0;
        }
        if (endOffset > this.currentText.length()) {
            endOffset = this.currentText.length();
        }
        this.problemBuffer.add((Problem)new BasicProblem("Ltx", severity, code, message, startOffset, endOffset));
        if (this.problemBuffer.size() >= 100) {
            this.currentRequestor.acceptProblems("Ltx", this.problemBuffer);
            this.problemBuffer.clear();
        }
    }
}

