/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.resources.core.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.statet.ecommons.databinding.core.conversion.ClassTypedConverter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class PathToResourceConverter<TResource extends IResource>
implements ClassTypedConverter<IPath, TResource> {
    private final int resourceType;
    private IContainer baseContainer;

    public PathToResourceConverter(int resourceType, IContainer baseContainer) {
        this.resourceType = resourceType;
        this.baseContainer = baseContainer;
    }

    public void setBaseContainer(IContainer container) {
        this.baseContainer = container;
    }

    public IContainer getBaseContainer() {
        return this.baseContainer;
    }

    public Class<IPath> getFromType() {
        return IPath.class;
    }

    public abstract Class<TResource> getToType();

    public TResource convert(IPath path) {
        IContainer base = this.getBaseContainer();
        if (path.isAbsolute()) {
            base = base.getWorkspace().getRoot();
        }
        if (path.segmentCount() == 0) {
            this.checkResourceType(base.getType(), path);
            return (TResource)base;
        }
        if (path.segmentCount() == 1 && base.getType() == 8) {
            this.checkResourceType(4, path);
            return (TResource)((IWorkspaceRoot)base).getProject(path.segment(0));
        }
        if ((this.resourceType & 1) == 0 || path.hasTrailingSeparator()) {
            this.checkResourceType(2, path);
            return (TResource)base.getFolder(path);
        }
        this.checkResourceType(1, path);
        return (TResource)base.getFile(path);
    }

    protected void checkResourceType(int type, IPath path) {
        if (this.resourceType != 0 && (this.resourceType & type) == 0) {
            throw new IllegalArgumentException("path= " + path.toString());
        }
    }

    public static class ToContainer
    extends PathToResourceConverter<IContainer> {
        public ToContainer(IContainer baseContainer) {
            super(6, baseContainer);
        }

        @Override
        public Class<IContainer> getToType() {
            return IContainer.class;
        }
    }

    public static class ToFile
    extends PathToResourceConverter<IFile> {
        public ToFile(IContainer baseContainer) {
            super(1, baseContainer);
        }

        @Override
        public Class<IFile> getToType() {
            return IFile.class;
        }
    }

    public static class ToFolder
    extends PathToResourceConverter<IFolder> {
        public ToFolder(IContainer baseContainer) {
            super(2, baseContainer);
        }

        @Override
        public Class<IFolder> getToType() {
            return IFolder.class;
        }
    }
}

