/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.renv.core;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;

@NonNullByDefault
public class REnvCoreInternals {
    public static final String BUNDLE_ID = "org.eclipse.statet.rj.services";
    public static final Collator R_NAMES_COLLATOR;

    static {
        ULocale locale = ULocale.forLanguageTag((String)"en-u-ks-identic-kf-upper");
        Collator collator = Collator.getInstance((ULocale)locale);
        if (collator.getStrength() != 15) {
            throw new IllegalStateException("Collator.strength= " + collator.getStrength());
        }
        R_NAMES_COLLATOR = collator;
    }

    public static void log(Status status) {
        CommonsRuntime.log((Status)status);
    }

    public static ImList<? extends RLibLocation> listRLibLocations(ImList<? extends RLibGroup> libGroups) {
        Collection[] listArray = new List[libGroups.size()];
        int i = 0;
        while (i < listArray.length) {
            listArray[i] = ((RLibGroup)libGroups.get(i)).getLibLocations();
            ++i;
        }
        return ImCollections.concatList((Collection[])listArray);
    }

    public static @Nullable String getRLibGroupLabel(String groupId) {
        switch (groupId) {
            case "r.default": {
                return "Default Library";
            }
            case "r.site": {
                return "Site Libraries (R_LIBS_SITE)";
            }
            case "r.user": {
                return "User Libraries (R_LIBS_USER)";
            }
            case "r.common": {
                return "Additional Libraries (R_LIBS)";
            }
        }
        return null;
    }

    private REnvCoreInternals() {
    }
}

