/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.launching;

import com.ibm.icu.text.DateFormat;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.internal.r.console.ui.RConsoleUIPlugin;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.rj.server.RjsComConfig;
import org.eclipse.statet.rj.server.Server;
import org.eclipse.statet.rj.server.ServerInfo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public class RRemoteConsoleSelectionDialog
extends SelectionStatusDialog {
    private static final String SETTINGS_DIALOG_ID = "RRemoteConsoleSelection";
    private static final String SETTINGS_HOST_HISTORY_KEY = "hosts.history";
    private static final Pattern ADDRESS_MULTI_PATTERN = Pattern.compile("\\/?\\s*[\\,\\;]+\\s*");
    private static final Pattern ADDRESS_WITH_PORT_PATTERN = Pattern.compile("(.*):(\\d{1,5})");
    private Combo hostAddressControl;
    private TreeViewer rServerViewer;
    private List<RemoteR> rServerList;
    private final boolean filterOnlyRunning;
    private String username;
    private final List<String> historyAddress = new ArrayList<String>(35);
    private final List<String> additionalAddress = new ArrayList<String>(8);
    private final Map<String, SpecialAddress> specialAddress = new HashMap<String, SpecialAddress>(8);
    private String initialAddress;

    public RRemoteConsoleSelectionDialog(Shell parentShell, boolean onlyRunning) {
        super(parentShell);
        this.setTitle(Messages.RRemoteConsoleSelectionDialog_title);
        this.setMessage(Messages.RRemoteConsoleSelectionDialog_message);
        this.setStatusLineAboveButtons(true);
        this.setDialogBoundsSettings(this.getDialogSettings(), 2);
        this.username = System.getProperty("user.name");
        this.filterOnlyRunning = onlyRunning;
    }

    public void setUser(String username) {
        if (username != null && username.length() > 0) {
            this.username = username;
        }
    }

    public void setInitialAddress(String address) {
        this.additionalAddress.remove(address);
        this.additionalAddress.add(0, address);
        this.initialAddress = address;
    }

    public void addAdditionalAddress(String label, SpecialAddress factory) {
        this.additionalAddress.add(label);
        if (factory != null) {
            this.specialAddress.put(label, factory);
        }
    }

    public void clearAdditionaAddress(boolean specialOnly) {
        if (specialOnly) {
            for (Map.Entry<String, SpecialAddress> entry : this.specialAddress.entrySet()) {
                this.additionalAddress.remove(entry.getKey());
            }
        } else {
            this.additionalAddress.clear();
        }
        this.specialAddress.clear();
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((AbstractUIPlugin)RConsoleUIPlugin.getInstance(), (String)SETTINGS_DIALOG_ID);
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.createMessageArea(area);
        IDialogSettings dialogSettings = this.getDialogSettings();
        Composite composite = new Composite(area, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)3));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText(Messages.RRemoteConsoleSelectionDialog_Hostname_label);
        this.hostAddressControl = new Combo(composite, 4);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Combo)this.hostAddressControl, (int)50);
        this.hostAddressControl.setLayoutData((Object)gd);
        String[] history = dialogSettings.getArray(SETTINGS_HOST_HISTORY_KEY);
        if (history != null) {
            this.historyAddress.addAll(Arrays.asList(history));
        }
        this.hostAddressControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RRemoteConsoleSelectionDialog.this.update();
            }
        });
        Button goButton = new Button(composite, 8);
        goButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        goButton.setText(Messages.RRemoteConsoleSelectionDialog_Update_label);
        goButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RRemoteConsoleSelectionDialog.this.update();
            }
        });
        composite = new ViewerUtils.TreeComposite(area, 67588);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = LayoutUtils.hintHeight((Tree)composite.tree, (int)10);
        composite.setLayoutData((Object)gd2);
        this.rServerViewer = composite.viewer;
        composite.tree.setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)composite.viewer);
        TreeViewerColumn column = new TreeViewerColumn(this.rServerViewer, 0);
        column.getColumn().setText(Messages.RRemoteConsoleSelectionDialog_Table_UserOrEngine_label);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.setLabelProvider((CellLabelProvider)new RemoteRLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                String text = null;
                Image image = null;
                if (element instanceof String) {
                    text = (String)element;
                    image = SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/obj/user");
                } else if (element instanceof RemoteR) {
                    text = this.getText((RemoteR)element);
                }
                cell.setText(text);
                cell.setImage(image);
            }

            @Override
            public String getText(RemoteR r) {
                return r.info.getName();
            }
        });
        column = new TreeViewerColumn(this.rServerViewer, 0);
        column.getColumn().setText(Messages.RRemoteConsoleSelectionDialog_Table_Host_label);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.setLabelProvider((CellLabelProvider)new RemoteRLabelProvider(){

            @Override
            public String getText(RemoteR r) {
                return r.hostName;
            }
        });
        this.rServerViewer.setContentProvider((IContentProvider)new RemoteRContentProvider());
        this.rServerViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RRemoteConsoleSelectionDialog.this.updateState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RRemoteConsoleSelectionDialog.this.updateState();
                if (RRemoteConsoleSelectionDialog.this.getOkButton().isEnabled()) {
                    RRemoteConsoleSelectionDialog.this.buttonPressed(0);
                }
            }
        });
        Dialog.applyDialogFont((Control)area);
        this.updateInput();
        if (this.rServerList != null) {
            this.updateStatus((IStatus)new Status(0, "org.eclipse.statet.r.console.ui", Messages.RRemoteConsoleSelectionDialog_info_ListRestored_message));
        }
        return area;
    }

    private void update() {
        final String input = this.hostAddressControl.getText();
        this.rServerList = null;
        final AtomicReference<IStatus> status = new AtomicReference<IStatus>();
        if (input != null && input.length() > 0) {
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        status.set(RRemoteConsoleSelectionDialog.this.updateRServerList(input, monitor));
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException e) {
                this.rServerViewer = null;
                status.compareAndSet(null, Status.CANCEL_STATUS);
            }
        }
        if (status.get() != null) {
            this.updateStatus((IStatus)status.get());
        }
        this.getOkButton().setEnabled(false);
        if (this.rServerList != null && this.rServerList.size() > 0) {
            if (!this.specialAddress.containsKey(input)) {
                this.historyAddress.remove(input);
                this.historyAddress.add(0, input);
            }
            if (this.filterOnlyRunning) {
                Iterator<RemoteR> iter = this.rServerList.iterator();
                while (iter.hasNext()) {
                    switch (iter.next().info.getState()) {
                        case 17: 
                        case 26: {
                            iter.remove();
                        }
                    }
                }
            }
            this.updateInput();
            return;
        }
        this.rServerViewer.setInput(null);
    }

    private void updateInput() {
        final String selectedAddress = this.hostAddressControl.getText();
        ArrayList<String> list = new ArrayList<String>(this.historyAddress.size() + this.additionalAddress.size());
        list.addAll(this.historyAddress);
        for (String address : this.additionalAddress) {
            if (list.contains(address)) continue;
            list.add(address);
        }
        this.hostAddressControl.setItems(list.toArray(new String[list.size()]));
        this.rServerViewer.setInput(this.rServerList);
        if (this.username != null && this.username.length() > 0) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RRemoteConsoleSelectionDialog.this.initialAddress != null) {
                        RRemoteConsoleSelectionDialog.this.hostAddressControl.setText(RRemoteConsoleSelectionDialog.this.initialAddress);
                        RRemoteConsoleSelectionDialog.this.initialAddress = null;
                    } else if (selectedAddress != null && selectedAddress.length() > 0) {
                        RRemoteConsoleSelectionDialog.this.hostAddressControl.setText(selectedAddress);
                    } else if (RRemoteConsoleSelectionDialog.this.hostAddressControl.getItemCount() > 0) {
                        RRemoteConsoleSelectionDialog.this.hostAddressControl.select(0);
                    }
                    RRemoteConsoleSelectionDialog.this.rServerViewer.expandToLevel((Object)RRemoteConsoleSelectionDialog.this.username.toLowerCase(), 1);
                    RRemoteConsoleSelectionDialog.this.updateState();
                }
            });
        }
    }

    private void updateState() {
        IStructuredSelection selection = (IStructuredSelection)this.rServerViewer.getSelection();
        this.getOkButton().setEnabled(selection.getFirstElement() instanceof RemoteR);
    }

    protected void computeResult() {
        IStructuredSelection selection = (IStructuredSelection)this.rServerViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof RemoteR) {
            this.setSelectionResult(new Object[]{((RemoteR)element).address});
        }
    }

    public boolean close() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(SETTINGS_HOST_HISTORY_KEY, this.historyAddress.toArray(new String[this.historyAddress.size()]));
        return super.close();
    }

    private IStatus updateRServerList(String combined, IProgressMonitor monitor) {
        ArrayList<RemoteR> infos = new ArrayList<RemoteR>();
        String[] addresses = ADDRESS_MULTI_PATTERN.split(combined, -1);
        if (addresses.length == 0) {
            return null;
        }
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RRemoteConsoleSelectionDialog_task_Gathering_message, (int)(addresses.length * 2 + 2));
        String failedHosts = null;
        ArrayList<IStatus> failedStatus = new ArrayList<IStatus>();
        m.worked(1);
        int i = 0;
        while (i < addresses.length) {
            IStatus status;
            m.setWorkRemaining((addresses.length - i) * 2 + 1);
            String address = addresses[i];
            SpecialAddress special = this.specialAddress.get(address);
            if (special == null) {
                if (address.startsWith("rmi:")) {
                    address = address.substring(4);
                }
                if (address.startsWith("//")) {
                    address = address.substring(2);
                }
            }
            if (address.isEmpty()) {
                return null;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (special == null) {
                Matcher matcher = ADDRESS_WITH_PORT_PATTERN.matcher(address);
                status = matcher.matches() ? RRemoteConsoleSelectionDialog.collectServerInfos(matcher.group(1), Integer.parseInt(matcher.group(2)), null, infos, m.newChild(1)) : RRemoteConsoleSelectionDialog.collectServerInfos(address, 1099, null, infos, m.newChild(1));
            } else {
                address = special.rmiAddress.getAddress();
                status = RRemoteConsoleSelectionDialog.collectServerInfos(null, 0, special, infos, m.newChild(1));
            }
            switch (status.getSeverity()) {
                case 8: {
                    return status;
                }
                case 4: {
                    StatusManager.getManager().handle(status, 1);
                    return status;
                }
                case 2: {
                    failedStatus.add(status);
                    failedHosts = failedHosts == null ? address : String.valueOf(failedHosts) + ", " + address;
                    break;
                }
            }
            ++i;
        }
        if (!failedStatus.isEmpty()) {
            StatusManager.getManager().handle((IStatus)new MultiStatus("org.eclipse.statet.r.console.ui", 0, failedStatus.toArray(new IStatus[failedStatus.size()]), "Info about connection failures when browsing R engines:", null), 1);
        }
        if (!infos.isEmpty() || failedStatus.isEmpty()) {
            this.rServerList = infos;
        }
        if (failedHosts != null) {
            return new Status(2, "org.eclipse.statet.r.console.ui", String.valueOf(Messages.RRemoteConsoleSelectionDialog_error_ConnectionFailed_message) + failedHosts);
        }
        return Status.OK_STATUS;
    }

    private static IStatus collectServerInfos(String address, int port, SpecialAddress special, List<RemoteR> infos, SubMonitor m) {
        try {
            String[] names;
            Registry registry;
            if (special != null) {
                address = special.rmiAddress.getAddress();
                port = special.rmiAddress.getPort().get();
            }
            m.subTask(NLS.bind((String)Messages.RRemoteConsoleSelectionDialog_task_Resolving_message, (Object)address));
            InetAddress inetAddress = InetAddress.getByName(address);
            String hostname = inetAddress.getHostName();
            String hostip = inetAddress.getHostAddress();
            m.worked(1);
            if (m.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            m.subTask(NLS.bind((String)Messages.RRemoteConsoleSelectionDialog_task_Connecting_message, (Object)hostname));
            if (special != null) {
                RMIClientSocketFactory socketFactory = special.getSocketFactory((IProgressMonitor)m.newChild(5));
                RjsComConfig.setRMIClientSocketFactory((RMIClientSocketFactory)socketFactory);
                registry = LocateRegistry.getRegistry(special.privateHost, port, socketFactory);
            } else {
                RjsComConfig.setRMIClientSocketFactory(null);
                registry = LocateRegistry.getRegistry(address, port);
            }
            String rmiBase = port == 1099 ? "//" + address + '/' : "//" + address + ':' + port + '/';
            String[] stringArray = names = registry.list();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                try {
                    Remote remote = registry.lookup(name);
                    if (remote instanceof Server) {
                        Server server = (Server)remote;
                        ServerInfo info = server.getInfo();
                        String rmiAddress = String.valueOf(rmiBase) + name;
                        RemoteR r = new RemoteR(hostname, hostip, rmiAddress, info);
                        infos.add(r);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (RemoteException e) {
            Status status = new Status(2, "org.eclipse.statet.r.console.ui", address);
            return status;
        }
        catch (UnknownHostException e) {
            Status status = new Status(4, "org.eclipse.statet.r.console.ui", "Unknown host: " + e.getLocalizedMessage());
            return status;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            RjsComConfig.clearRMIClientSocketFactory();
        }
    }

    private static class RemoteR {
        final String hostName;
        final String hostIP;
        final String address;
        final ServerInfo info;

        RemoteR(String hostName, String hostIP, String address, ServerInfo info) {
            this.hostName = hostName;
            this.hostIP = hostIP;
            this.address = address;
            this.info = info;
        }

        String createSummary() {
            StringBuilder sb = new StringBuilder(100);
            sb.append("Address:   ").append(this.address).append('\n');
            sb.append('\n');
            sb.append("Host-Name: ").append(this.hostName).append('\n');
            sb.append("Host-IP:   ").append(this.hostIP).append('\n');
            sb.append("Date:      ").append(this.info.getTimestamp() != 0L ? DateFormat.getDateInstance().format((Object)this.info.getTimestamp()) : "<unknown>").append('\n');
            sb.append("Directory: ").append(this.info.getDirectory()).append('\n');
            sb.append("Status:    ");
            switch (this.info.getState()) {
                case 17: {
                    sb.append("New \u2013 Ready to connect and start R");
                    break;
                }
                case 20: 
                case 22: {
                    sb.append("Running \u2013 Connected (username is ");
                    sb.append(this.info.getUsername("console") != null ? this.info.getUsername("console") : "<unknown>").append(')');
                    break;
                }
                case 25: {
                    sb.append("Running \u2013 Connection lost / Ready to reconnect");
                    break;
                }
                case 24: {
                    sb.append("Running \u2013 Disconnected / Ready to reconnect");
                    break;
                }
                case 26: {
                    sb.append("Stopped");
                    break;
                }
                default: {
                    sb.append("Unknown");
                }
            }
            return sb.toString();
        }
    }

    private static class RemoteRContentProvider
    implements ITreeContentProvider {
        private final HashMap<String, RemoteR[]> mapping = new HashMap();

        private RemoteRContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<RemoteR> list;
            List all = (List)inputElement;
            this.mapping.clear();
            HashMap<String, RemoteR[]> mapping = this.mapping;
            for (RemoteR r : all) {
                String username = r.info.getUsername("owner").toLowerCase();
                list = (ArrayList<RemoteR>)mapping.get(username);
                if (list == null) {
                    list = new ArrayList<RemoteR>();
                    mapping.put(username, (RemoteR[])list);
                }
                list.add(r);
            }
            Set entrySet = mapping.entrySet();
            for (Map.Entry entry : entrySet) {
                list = (List)entry.getValue();
                entry.setValue(list.toArray(new RemoteR[list.size()]));
            }
            return this.mapping.keySet().toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof RemoteR) {
                return ((RemoteR)element).info.getUsername("owner");
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                return this.mapping.get(parentElement);
            }
            return null;
        }

        public void dispose() {
        }
    }

    private static abstract class RemoteRLabelProvider
    extends CellLabelProvider {
        private RemoteRLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            String text = null;
            if (element instanceof RemoteR) {
                text = this.getText((RemoteR)element);
            }
            cell.setText(text);
        }

        public abstract String getText(RemoteR var1);

        public Font getToolTipFont(Object element) {
            if (element instanceof RemoteR) {
                return JFaceResources.getTextFont();
            }
            return null;
        }

        public String getToolTipText(Object element) {
            if (element instanceof RemoteR) {
                return ((RemoteR)element).createSummary();
            }
            return null;
        }
    }

    public static abstract class SpecialAddress {
        private final RMIAddress rmiAddress;
        private final String privateHost;

        public SpecialAddress(RMIAddress rmiAddress, String privateHost) {
            this.rmiAddress = rmiAddress;
            this.privateHost = privateHost;
        }

        public abstract RMIClientSocketFactory getSocketFactory(IProgressMonitor var1) throws CoreException;
    }
}

