/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.eclipse.statet.internal.rj.servi.server.RServiBackend;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.WarningStatus;
import org.eclipse.statet.rj.RjClosedException;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.data.REnvironment;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.impl.DefaultRObjectFactory;
import org.eclipse.statet.rj.server.ComHandler;
import org.eclipse.statet.rj.server.REngine;
import org.eclipse.statet.rj.server.RjsComConfig;
import org.eclipse.statet.rj.server.RjsStatus;
import org.eclipse.statet.rj.server.client.AbstractRJComClient;
import org.eclipse.statet.rj.server.client.AbstractRJComClientGraphicActions;
import org.eclipse.statet.rj.server.client.FunctionCallImpl;
import org.eclipse.statet.rj.server.client.RClientGraphicActions;
import org.eclipse.statet.rj.server.client.RClientGraphicFactory;
import org.eclipse.statet.rj.server.client.RGraphicCreatorImpl;
import org.eclipse.statet.rj.servi.RServi;
import org.eclipse.statet.rj.services.BasicFQRObject;
import org.eclipse.statet.rj.services.FQRObject;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RGraphicCreator;
import org.eclipse.statet.rj.services.RPlatform;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public class RServiImpl<THandle>
implements RServi,
Externalizable {
    private long accessId;
    private PoolRef poolRef;
    private RServiBackend backend;
    private final AbstractRJComClient rjs = new RServiComClient();
    private int rjsId;
    private @Nullable THandle rHandle;

    public RServiImpl(long accessId, PoolRef ref, RServiBackend backend) {
        this.accessId = accessId;
        this.poolRef = ref;
        this.backend = backend;
        this.rjs.setServer((REngine)this.backend, 1);
    }

    public RServiImpl() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.accessId = in.readLong();
        this.poolRef = (PoolRef)in.readObject();
        this.backend = (RServiBackend)in.readObject();
        this.rjs.setServer((REngine)this.backend, 1);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.accessId);
        out.writeObject(this.poolRef);
        out.writeObject(this.backend);
    }

    public void setRHandle(THandle rHandle) {
        if (this.rjs.getRService() != null) {
            throw new IllegalStateException("client already initialized.");
        }
        this.rHandle = rHandle;
    }

    public THandle getRHandle() {
        return this.rHandle;
    }

    private synchronized void init() throws StatusException {
        this.rjsId = RjsComConfig.registerClientComHandler((ComHandler)this.rjs);
        try {
            HashMap properties = new HashMap();
            this.rjs.initClient(this.rHandle, (RService)this, properties, this.rjsId);
            this.rjs.setRjsProperties(properties);
        }
        catch (Exception e) {
            this.forceClose();
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.servi", "An error occurred when initializing RServi instance.", (Throwable)e));
        }
    }

    protected void dispose() {
        RjsComConfig.unregisterClientComHandler((int)this.rjsId);
        this.backend = null;
        this.poolRef = null;
        this.rjs.disposeAllGraphics();
    }

    @Override
    public boolean isClosed() {
        return this.rjs.isClosed();
    }

    @Override
    public synchronized void close() throws StatusException {
        if (this.rjs.isClosed()) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.servi", "RServi is already closed."));
        }
        try {
            try {
                this.rjs.setClosed(true);
                this.poolRef.returnObject(this.accessId);
            }
            catch (Exception e) {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.servi", "An error occurred when closing RServi instance.", (Throwable)e));
            }
        }
        finally {
            this.dispose();
        }
    }

    private void forceClose() {
        try {
            try {
                this.rjs.setClosed(true);
                this.poolRef.returnObject(this.accessId);
            }
            catch (NoSuchObjectException | RjClosedException throwable) {
                this.dispose();
            }
            catch (Exception e) {
                CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rj.servi", "An error occurred when closing RServi instance.", (Throwable)e));
                this.dispose();
            }
        }
        finally {
            this.dispose();
        }
    }

    public RPlatform getPlatform() {
        return this.rjs.getRPlatform();
    }

    public void evalVoid(String expression, ProgressMonitor m) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        this.rjs.evalVoid(expression, null, m);
    }

    public void evalVoid(String expression, @Nullable RObject envir, ProgressMonitor m) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        this.rjs.evalVoid(expression, envir, m);
    }

    public RObject evalData(String expression, ProgressMonitor m) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        return this.rjs.evalData(expression, null, null, 0, -1, m);
    }

    public RObject evalData(String expression, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        return this.rjs.evalData(expression, null, factoryId, options, depth, m);
    }

    public RObject evalData(String expression, @Nullable RObject envir, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        return this.rjs.evalData(expression, envir, factoryId, options, depth, m);
    }

    public RObject evalData(RReference reference, ProgressMonitor m) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        return this.rjs.evalData(reference, null, 0, -1, m);
    }

    public RObject evalData(RReference reference, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        return this.rjs.evalData(reference, factoryId, options, depth, m);
    }

    public @Nullable FQRObject<THandle> findData(String symbol, @Nullable RObject env, boolean inherits, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        RObject[] data;
        if (this.rjsId == 0) {
            this.init();
        }
        if ((data = this.rjs.findData(symbol, env, inherits, factoryId, options, depth, m)) != null) {
            return new BasicFQRObject(this.rHandle, (REnvironment)data[1], symbol, data[0]);
        }
        return null;
    }

    public void assignData(String expression, RObject data, ProgressMonitor m) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        this.rjs.assignData(expression, data, null, m);
    }

    public void downloadFile(OutputStream out, String fileName, int options, ProgressMonitor m) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        this.rjs.downloadFile(out, fileName, options, m);
    }

    public byte[] downloadFile(String fileName, int options, ProgressMonitor m) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        return this.rjs.downloadFile(fileName, options, m);
    }

    public void uploadFile(InputStream in, long length, String fileName, int options, ProgressMonitor m) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        this.rjs.uploadFile(in, length, fileName, options, m);
    }

    public FunctionCall createFunctionCall(String name) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        return new FunctionCallImpl(this.rjs, name, (RObjectFactory)DefaultRObjectFactory.INSTANCE);
    }

    public RGraphicCreator createRGraphicCreator(int options) throws StatusException {
        if (this.rjsId == 0) {
            this.init();
        }
        return new RGraphicCreatorImpl((RService)this, this.rjs, options);
    }

    public static interface PoolRef
    extends Remote {
        public void returnObject(long var1) throws RjException, RemoteException;
    }

    private class RServiComClient
    extends AbstractRJComClient {
        protected void initGraphicFactory() {
            Object graphicFactory = RjsComConfig.getProperty((String)"rj.servi.graphicFactory");
            Object actionsFactory = RjsComConfig.getProperty((String)"rj.servi.comClientGraphicActionsFactory");
            if (graphicFactory instanceof RClientGraphicFactory) {
                this.setGraphicFactory((RClientGraphicFactory)graphicFactory, (RClientGraphicActions)(actionsFactory instanceof AbstractRJComClientGraphicActions.Factory ? ((AbstractRJComClientGraphicActions.Factory)actionsFactory).create((AbstractRJComClient)this, this.getRHandle()) : null));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleServerStatus(RjsStatus serverStatus, ProgressMonitor m) throws StatusException {
            switch (serverStatus.getCode()) {
                case 0: {
                    return;
                }
                case 24: 
                case 25: 
                case 26: {
                    break;
                }
                case 4: {
                    throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.servi", "Server or IO error."));
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            RServiImpl rServiImpl = RServiImpl.this;
            synchronized (rServiImpl) {
                if (!this.isClosed()) {
                    CommonsRuntime.log((Status)new WarningStatus("org.eclipse.statet.rj.servi", "RServi is disconnected."));
                    RServiImpl.this.forceClose();
                }
            }
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.servi", "RServi is closed."));
        }

        protected void handleStatus(Status status, ProgressMonitor m) {
            if (status.getSeverity() != 0) {
                this.log(status);
            }
        }

        protected void log(Status status) {
            CommonsRuntime.log((Status)status);
        }
    }
}

