/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.dbg.TracepointState;

@NonNullByDefault
public class TracepointStatesUpdate
implements RJIOExternalizable {
    private static final int RESET = 1;
    private final int properties;
    private final List<TracepointState> states;

    public TracepointStatesUpdate(List<TracepointState> states, boolean reset) {
        this.properties = reset ? 1 : 0;
        this.states = states;
    }

    public TracepointStatesUpdate(RJIO io) throws IOException {
        this.properties = io.readInt();
        this.states = TracepointState.readList(io);
    }

    public void writeExternal(RJIO io) throws IOException {
        io.writeInt(this.properties);
        TracepointState.writeList(this.states, io);
    }

    public boolean getReset() {
        return (this.properties & 1) != 0;
    }

    public List<TracepointState> getStates() {
        return this.states;
    }
}

