/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.server.AutoIdMap;
import org.eclipse.statet.rj.server.ComHandler;
import org.eclipse.statet.rj.server.ConsoleMessageCmdItem;
import org.eclipse.statet.rj.server.ConsoleReadCmdItem;
import org.eclipse.statet.rj.server.ConsoleWriteCmdItem;
import org.eclipse.statet.rj.server.DataCmdItem;
import org.eclipse.statet.rj.server.DbgCmdItem;
import org.eclipse.statet.rj.server.ExtClientCmdItem;
import org.eclipse.statet.rj.server.GraOpCmdItem;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.MainCtrlCmdItem;
import org.eclipse.statet.rj.server.RjsComObject;

public final class MainCmdS2CList
implements RjsComObject,
Externalizable {
    static final AutoIdMap<ComHandler> gComHandlers = new AutoIdMap();
    private int id;
    private boolean isBusy;
    private MainCmdItem first;

    public MainCmdS2CList(MainCmdItem first, boolean isBusy) {
        this.isBusy = isBusy;
        this.first = first;
    }

    public MainCmdS2CList() {
        this.isBusy = false;
        this.first = null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.id);
        out.writeBoolean(this.isBusy);
        RJIO io = RJIO.get((ObjectOutput)out);
        int check = io.writeCheck1();
        MainCmdItem item = this.first;
        if (item != null) {
            do {
                out.writeByte(item.getCmdType());
                item.writeExternal(io);
            } while ((item = item.next) != null);
        }
        out.writeByte(0);
        io.writeCheck2(check);
        io.disconnect(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte type;
        this.id = in.readUnsignedShort();
        if (this.id != 0) {
            gComHandlers.get(this.id).processMainCmd(in);
            return;
        }
        this.isBusy = in.readBoolean();
        RJIO io = RJIO.get((ObjectInput)in);
        int check = io.readCheck1();
        byte type2 = in.readByte();
        switch (type2) {
            case 0: {
                this.first = null;
                io.readCheck2(check);
                io.disconnect(in);
                return;
            }
            case 1: {
                this.first = new ConsoleReadCmdItem(io);
                break;
            }
            case 2: {
                this.first = new ConsoleWriteCmdItem(io);
                break;
            }
            case 4: {
                this.first = new ConsoleMessageCmdItem(io);
                break;
            }
            case 5: {
                this.first = new ExtClientCmdItem(io);
                break;
            }
            case 16: {
                this.first = new MainCtrlCmdItem(io);
                break;
            }
            case 17: {
                this.first = new DataCmdItem(io);
                break;
            }
            case 18: {
                this.first = new GraOpCmdItem(io);
                break;
            }
            case 20: {
                this.first = new DbgCmdItem(io);
                break;
            }
            default: {
                throw new ClassNotFoundException("Unknown cmdtype id: " + type2);
            }
        }
        MainCmdItem item = this.first;
        block22: while (true) {
            type = in.readByte();
            switch (type) {
                case 0: {
                    io.readCheck2(check);
                    io.disconnect(in);
                    return;
                }
                case 1: {
                    item = item.next = new ConsoleReadCmdItem(io);
                    continue block22;
                }
                case 2: {
                    item = item.next = new ConsoleWriteCmdItem(io);
                    continue block22;
                }
                case 4: {
                    item = item.next = new ConsoleMessageCmdItem(io);
                    continue block22;
                }
                case 5: {
                    item = item.next = new ExtClientCmdItem(io);
                    continue block22;
                }
                case 16: {
                    item = item.next = new MainCtrlCmdItem(io);
                    continue block22;
                }
                case 17: {
                    item = item.next = new DataCmdItem(io);
                    continue block22;
                }
                case 18: {
                    item = item.next = new GraOpCmdItem(io);
                    continue block22;
                }
                case 20: {
                    item = item.next = new DbgCmdItem(io);
                    continue block22;
                }
            }
            break;
        }
        io.disconnect(in);
        throw new ClassNotFoundException("Unknown cmdtype id: " + type);
    }

    public void clear() {
        MainCmdItem item = this.first;
        while (item != null) {
            MainCmdItem tmp = item;
            item = item.next;
            tmp.next = null;
        }
        this.first = null;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public void setId(int id) {
        this.id = (short)id;
    }

    public void setBusy(boolean isBusy) {
        this.isBusy = isBusy;
    }

    public void setObjects(MainCmdItem first) {
        this.first = first;
    }

    @Override
    public int getComType() {
        return 3;
    }

    public MainCmdItem getItems() {
        return this.first;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public boolean testEquals(MainCmdS2CList other) {
        if (this.isBusy != other.isBusy()) {
            return false;
        }
        MainCmdItem thisItem = this.first;
        MainCmdItem otherItem = other.first;
        while (thisItem != null && otherItem != null) {
            if (!thisItem.equals(otherItem)) {
                return false;
            }
            thisItem = thisItem.next;
            otherItem = otherItem.next;
        }
        return thisItem == null && otherItem == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("MainCmdS2CList (isBusy=");
        sb.append(this.isBusy);
        sb.append(')');
        if (this.first != null) {
            sb.append(':');
        }
        MainCmdItem item = this.first;
        int i = 0;
        while (item != null) {
            sb.append("\n<ITEM i=\"");
            sb.append(i);
            sb.append("\">\n");
            sb.append(item.toString());
            sb.append("\n</ITEM>");
            item = item.next;
            ++i;
        }
        return sb.toString();
    }
}

