/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.ui.processing;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigIOStepTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigMainTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigStepTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperationSettings;
import org.eclipse.statet.docmlet.base.ui.processing.operations.RunExternalProgramOperationSettings;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.processing.Messages;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.processing.WikitextRweaveConfig;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.redocs.r.ui.RedocsRUIResources;
import org.eclipse.statet.redocs.r.ui.processing.RunRCmdToolOperationSettings;
import org.eclipse.statet.redocs.r.ui.processing.RunRConsoleSnippetOperationSettings;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public class ProduceTab
extends DocProcessingConfigIOStepTab
implements DocProcessingConfigStepTab.Listener {
    private final DocProcessingConfigIOStepTab weaveTab;

    public ProduceTab(DocProcessingConfigMainTab mainTab, DocProcessingConfigIOStepTab weaveTab) {
        super(mainTab, "org.eclipse.statet.redocs/produce");
        this.weaveTab = weaveTab;
        this.weaveTab.addListener((DocProcessingConfigStepTab.Listener)this);
        this.setInput(WikitextRweaveConfig.SOURCE_FORMAT, null);
        this.setAvailableOutputFormats((List)WikitextRweaveConfig.PRODUCE_OUTPUT_FORMATS, "auto:by-indoc-yaml");
        this.setAvailableOperations((List)ImCollections.newList((Object[])new DocProcessingOperationSettings[]{new RunRConsoleSnippetOperationSettings(), new RunRCmdToolOperationSettings(), new RunExternalProgramOperationSettings()}));
        this.weaveTab.getOutputFileValue().addValueChangeListener((IValueChangeListener)this);
    }

    public Image getImage() {
        return RedocsRUIResources.INSTANCE.getImage("org.eclipse.statet.redocs.r/image/tool/build-tex");
    }

    public String getName() {
        return this.createName(Messages.ProduceTab_name);
    }

    public String getLabel() {
        return Messages.Produce_label;
    }

    public void changed(DocProcessingConfigStepTab source) {
        if (source == this.weaveTab) {
            this.updateInput();
        }
    }

    public void handleValueChange(ValueChangeEvent<?> event) {
        if (event.getObservable() == this.weaveTab.getOutputFileValue() && this.weaveTab.isEnabled()) {
            this.updateInput();
            return;
        }
        super.handleValueChange(event);
    }

    private void updateInput() {
        if (this.weaveTab.isEnabled()) {
            DocProcessingConfig.Format format = this.weaveTab.getOutputFormat();
            this.setInput(format != null ? WikitextRweaveConfig.createWeaveOutputFormat(format) : null, this.weaveTab.getOutputFile());
        } else {
            this.setInput(WikitextRweaveConfig.SOURCE_FORMAT, this.getMainTab().getSourceFile());
        }
    }

    protected @Nullable IFile getInputFile(DocProcessingConfig.Format format) throws CoreException {
        if (this.weaveTab.isEnabled()) {
            return this.weaveTab.getOutputFile();
        }
        return null;
    }

    protected void addBindings(DataBindingContext dbc) {
        super.addBindings(dbc);
    }

    protected String getDefaultOperationId() {
        return "org.eclipse.statet.redocs.docProcessing.RunRConsoleSnippetOperation";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
    }

    protected void doInitialize(ILaunchConfiguration configuration) {
        super.doInitialize(configuration);
    }

    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        super.doSave(configuration);
    }
}

