/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.r.ui.processing;

import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolOperationContext;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolProcess;
import org.eclipse.statet.ecommons.ts.ui.ToolRunnableDecorator;
import org.eclipse.statet.internal.redocs.r.Messages;
import org.eclipse.statet.jcommons.status.CancelStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.r.console.core.IRBasicAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.rj.services.RServiceControlExtension;
import org.eclipse.swt.graphics.Image;

public class RConsoleOperationContext
extends DocProcessingToolOperationContext {
    public static final String ID = "RConsole";
    private DocProcessingToolProcess toolProcess;
    private RProcess rProcess;
    private RRunnable rRunnable;
    private IRBasicAdapter rService;
    private ProgressMonitor rMonitor;

    public String getId() {
        return ID;
    }

    public String getLabel() {
        return Messages.ProcessingOperationContext_RConsole_label;
    }

    protected void start(DocProcessingToolProcess toolProcess, SubMonitor m) throws CoreException {
        m.beginTask("Starting doc operation(s) in R console...", 10);
        if (this.toolProcess == null) {
            this.toolProcess = toolProcess;
            this.rProcess = this.getRProcess();
        }
        m.setTaskName("Waiting for R console...");
        this.rRunnable = new RRunnable();
        Status submitStatus = this.rProcess.getQueue().add((ToolRunnable)this.rRunnable);
        this.toolProcess.check(submitStatus);
    }

    private RProcess getRProcess() throws CoreException {
        Tool tool = NicoUI.getToolRegistry().getActiveToolSession(this.toolProcess.getConfig().getWorkbenchPage()).getTool();
        NicoUITools.accessTool((String)"R", (Tool)tool);
        return (RProcess)tool;
    }

    public void canceling(boolean running) {
        ProgressMonitor m;
        RRunnable runnable;
        if (this.rProcess == null) {
            return;
        }
        if (!running && (runnable = this.rRunnable) != null) {
            this.rProcess.getQueue().remove((ToolRunnable)runnable);
        }
        if ((m = this.rMonitor) != null) {
            m.setCanceled(true);
        }
    }

    private void initR(IRBasicAdapter service, ProgressMonitor m) {
        this.rService = service;
        this.rMonitor = m;
    }

    private void cleanR() {
        this.rRunnable = null;
        this.rService = null;
        this.rMonitor = null;
    }

    public IRBasicAdapter getRService() {
        return this.rService;
    }

    public ProgressMonitor getRMonitor() {
        return this.rMonitor;
    }

    private class RRunnable
    implements ToolRunnable,
    ToolRunnableDecorator {
        public String getTypeId() {
            return "r/redocs/RConsoleOperation";
        }

        public boolean canRunIn(Tool tool) {
            return tool.isProvidingFeatureSet("org.eclipse.statet.r.basic");
        }

        public Image getImage() {
            return RConsoleOperationContext.this.toolProcess.getImage();
        }

        public String getLabel() {
            return NLS.bind((String)Messages.ProcessingOperationContext_RConsole_RTask_label, (Object)RConsoleOperationContext.this.toolProcess.getLabel());
        }

        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 288: 
                case 290: {
                    RConsoleOperationContext.this.toolProcess.log((Status)new CancelStatus("org.eclipse.statet.docmlet.base.ui", Messages.ProcessingOperationContext_RConsole_RTask_Canceled_label));
                    RConsoleOperationContext.this.cleanR();
                    RConsoleOperationContext.this.cancel();
                    return true;
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            RConsoleOperationContext.this.initR((IRBasicAdapter)service, m);
            Callable<Boolean> cancel = null;
            if (service instanceof RServiceControlExtension) {
                cancel = new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        RConsoleOperationContext.this.toolProcess.terminate();
                        return Boolean.FALSE;
                    }
                };
                ((RServiceControlExtension)service).addCancelHandler((Callable)cancel);
            }
            try {
                RConsoleOperationContext.this.runInContext();
            }
            finally {
                if (cancel != null) {
                    ((RServiceControlExtension)service).removeCancelHandler((Callable)cancel);
                    cancel = null;
                }
                RConsoleOperationContext.this.cleanR();
            }
        }
    }
}

