/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.graphics;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.graphics.StatetRGraphicCopyToDevWizard;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.rj.eclient.graphics.ERGraphic;
import org.eclipse.statet.rj.eclient.graphics.RGraphicCompositeActionSet;
import org.eclipse.statet.rj.eclient.graphics.RGraphicPage;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class StatetRGraphicPage
extends RGraphicPage {
    public StatetRGraphicPage(ERGraphic graphic) {
        super(graphic);
    }

    protected RGraphicCompositeActionSet createActionSet() {
        return new RGraphicCompositeActionSet(this.getGraphicComposite()){

            public void contributeToActionsBars(IServiceLocator serviceLocator, IActionBars actionBars) {
                super.contributeToActionsBars(serviceLocator, actionBars);
                this.addSizeActions(serviceLocator, actionBars);
            }
        };
    }

    protected void initActions(IServiceLocator serviceLocator, IActionBars actionBars) {
        super.initActions(serviceLocator, actionBars);
        IMenuManager menu = actionBars.getMenuManager();
        menu.appendToGroup("save", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "NO_COMMAND", null, null, null, null, "Save as PDF (using R)...", "D", null, 8, null, false), (IHandler2)new SaveInRHandler("pdf", "pdf")));
        menu.appendToGroup("save", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "NO_COMMAND", null, null, null, null, "Save as EPS (using R)...", "E", null, 8, null, false), (IHandler2)new SaveInRHandler("postscript", "eps")));
    }

    private class SaveInRHandler
    extends AbstractHandler {
        private final String devCmd;
        private final String devAbbr;

        public SaveInRHandler(String cmd, String abbr) {
            this.devCmd = cmd;
            this.devAbbr = abbr;
        }

        public void setEnabled(Object evaluationContext) {
            RTool tool = StatetRGraphicPage.this.getGraphic().getRHandle();
            this.setBaseEnabled(tool != null && !tool.isTerminated());
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            RTool tool = StatetRGraphicPage.this.getGraphic().getRHandle();
            if (tool instanceof RProcess) {
                StatetRGraphicCopyToDevWizard wizard = new StatetRGraphicCopyToDevWizard((RProcess)tool, StatetRGraphicPage.this.getGraphic(), this.devCmd, this.devAbbr);
                WizardDialog dialog = new WizardDialog(UIAccess.getActiveWorkbenchShell((boolean)true), (IWizard)wizard);
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
            return null;
        }
    }
}

