/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.forms.widgets.Twistie;

public class ExpandableRowComposite
extends Canvas {
    public static final int TWISTIE = 2;
    public static final int FOCUS_TITLE = 8;
    public static final int CLIENT_INDENT = 16;
    public static final int COMPACT = 32;
    public static final int EXPANDED = 64;
    public static final int TITLE_BAR = 256;
    public static final int SHORT_TITLE_BAR = 512;
    public static final int LEFT_TEXT_CLIENT_ALIGNMENT = 8192;
    public static final int NO_TITLE_FOCUS_BOX = 16384;
    public static final int IMAGE = 0x40000000;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int clientVerticalSpacing = 3;
    public int descriptionVerticalSpacing = 0;
    public int titleBarTextMarginWidth = 6;
    protected Toggle toggle;
    protected Control textLabel;
    private static final int IGAP = 4;
    private static final int IVGAP = 3;
    private static final Point NULL_SIZE = new Point(0, 0);
    private static final int VSPACE = 3;
    private static final int SEPARATOR_HEIGHT = 2;
    private int expansionStyle = 74;
    private boolean expanded;
    private Label imageLabel;
    private Control client;
    private final CopyOnWriteIdentityListSet<IExpansionListener> listeners = new CopyOnWriteIdentityListSet();
    private Color titleBarForeground;
    private final Rectangle titleHeaderRegion = new Rectangle(0, 0, 0, 0);

    public ExpandableRowComposite(Composite parent, int style) {
        this(parent, style, 2);
    }

    public ExpandableRowComposite(Composite parent, int style, int expansionStyle) {
        super(parent, style);
        this.expansionStyle = expansionStyle;
        if ((expansionStyle & 0x100) != 0) {
            this.setBackgroundMode(1);
        }
        super.setLayout((Layout)new ExpandableLayout());
        if (this.hasTitleBar()) {
            this.addPaintListener(this::onPaint);
        }
        if ((expansionStyle & 2) != 0) {
            this.toggle = new Toggle((Composite)this, 0);
        } else {
            this.expanded = true;
        }
        if ((expansionStyle & 0x40) != 0) {
            this.expanded = true;
        }
        if (this.toggle != null) {
            this.toggle.setExpanded(this.expanded);
            this.toggle.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ExpandableRowComposite.this.toggleState();
                }
            });
            this.toggle.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x1000001) {
                        ExpandableRowComposite.this.verticalMove(false);
                        e.doit = false;
                    } else if (e.keyCode == 0x1000002) {
                        ExpandableRowComposite.this.verticalMove(true);
                        e.doit = false;
                    }
                }
            });
            if ((this.getExpansionStyle() & 8) == 0) {
                this.toggle.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (ExpandableRowComposite.this.textLabel != null) {
                            ExpandableRowComposite.this.textLabel.redraw();
                        }
                    }

                    public void focusLost(FocusEvent e) {
                        if (ExpandableRowComposite.this.textLabel != null) {
                            ExpandableRowComposite.this.textLabel.redraw();
                        }
                    }
                });
            }
        }
        if ((expansionStyle & 0x40000000) != 0) {
            this.imageLabel = new Label((Composite)this, 0);
        }
        if ((expansionStyle & 8) != 0) {
            Hyperlink link = new Hyperlink((Composite)this, 0);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ExpandableRowComposite.this.programmaticToggleState();
                }
            });
            this.textLabel = link;
        } else {
            Label label = new Label((Composite)this, 0);
            if (!this.isFixedStyle()) {
                Listener listener = new Listener(){

                    public void handleEvent(Event e) {
                        switch (e.type) {
                            case 9: {
                                if (ExpandableRowComposite.this.toggle == null || (ExpandableRowComposite.this.getExpansionStyle() & 0x4000) != 0) break;
                                ExpandableRowComposite.this.paintTitleFocus(e.gc);
                                break;
                            }
                            case 11: {
                                ExpandableRowComposite.this.updateLabelTrim();
                            }
                        }
                    }
                };
                label.addListener(9, listener);
                label.addListener(11, listener);
            }
            this.textLabel = label;
        }
        if (this.textLabel != null) {
            this.textLabel.setMenu(this.getMenu());
            this.textLabel.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 128) {
                        if (!ExpandableRowComposite.this.isVisible() || !ExpandableRowComposite.this.isEnabled()) {
                            return;
                        }
                        if (e.character != '\u0000' && e.character == LegacyActionTools.extractMnemonic((String)ExpandableRowComposite.this.getText())) {
                            e.doit = false;
                            if (!ExpandableRowComposite.this.isFixedStyle()) {
                                ExpandableRowComposite.this.programmaticToggleState();
                            }
                            ExpandableRowComposite.this.setFocus();
                        }
                    }
                }
            });
        }
        Listener listener = event -> {
            int x = event.x;
            int y = event.y;
            if (event.widget != this) {
                Point p = ((Control)event.widget).getLocation();
                x += p.x;
                y += p.y;
            }
            switch (event.type) {
                case 3: {
                    if (!this.titleHeaderRegion.contains(x, y)) break;
                    this.toggle.setFocus();
                    break;
                }
                case 4: {
                    if (!this.titleHeaderRegion.contains(x, y) || event.button != 1) break;
                    this.programmaticToggleState();
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    if (this.toggle.getHover()) {
                        if (this.titleHeaderRegion.contains(x, y)) break;
                        this.toggle.setHover(false);
                        this.toggle.redraw();
                        break;
                    }
                    if (!this.titleHeaderRegion.contains(x, y)) break;
                    this.toggle.setHover(true);
                    this.toggle.redraw();
                }
            }
        };
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(6, listener);
        this.addListener(5, listener);
        this.addListener(7, listener);
        if (this.imageLabel != null) {
            this.imageLabel.addListener(3, listener);
            this.imageLabel.addListener(4, listener);
            this.imageLabel.addListener(6, listener);
            this.imageLabel.addListener(7, listener);
        }
        this.textLabel.addListener(3, listener);
        this.textLabel.addListener(4, listener);
        this.textLabel.addListener(6, listener);
        this.textLabel.addListener(7, listener);
    }

    public boolean forceFocus() {
        return false;
    }

    public void setMenu(Menu menu) {
        if (this.toggle != null) {
            this.toggle.setMenu(menu);
        }
        if (this.imageLabel != null) {
            this.imageLabel.setMenu(menu);
        }
        if (this.textLabel != null) {
            this.textLabel.setMenu(menu);
        }
        super.setMenu(menu);
    }

    public final void setLayout(Layout layout) {
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if ((this.getExpansionStyle() & 0x100) == 0) {
            if (this.toggle != null) {
                this.toggle.setBackground(bg);
                this.toggle.setHoverDecorationColor(this.computeActiveToggleColor());
            }
            if (this.imageLabel != null) {
                this.imageLabel.setBackground(bg);
            }
            if (this.textLabel != null) {
                this.textLabel.setBackground(bg);
            }
        }
    }

    protected Color computeActiveToggleColor() {
        Display display = this.getDisplay();
        RGB selection = display.getSystemColor(26).getRGB();
        RGB background = this.getBackground().getRGB();
        return SharedUIResources.getColors().getColor(new RGB((63 + 3 * selection.red + 2 * background.red) / 6, (63 + 3 * selection.green + 2 * background.green) / 6, (63 + 3 * selection.blue + 2 * background.blue) / 6));
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.textLabel != null) {
            this.textLabel.setForeground(fg);
        }
        if (this.toggle != null) {
            this.toggle.setForeground(fg);
        }
    }

    public void setToggleColor(Color c) {
        if (this.toggle != null) {
            this.toggle.setDecorationColor(c);
        }
    }

    public void setActiveToggleColor(Color c) {
        if (this.toggle != null) {
            this.toggle.setHoverDecorationColor(c);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.textLabel != null) {
            this.textLabel.setFont(font);
        }
        if (this.toggle != null) {
            this.toggle.setFont(font);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.textLabel != null) {
            this.textLabel.setEnabled(enabled);
        }
        if (this.toggle != null) {
            this.toggle.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public void setClient(Control client) {
        Assert.isTrue((client != null && client.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.client = client;
    }

    public Control getClient() {
        return this.client;
    }

    public void setImage(Image image) {
        if (this.imageLabel != null) {
            this.imageLabel.setImage(image);
        }
    }

    public Image getImage() {
        if (this.imageLabel != null) {
            return this.imageLabel.getImage();
        }
        return null;
    }

    public void setText(String title) {
        if (this.textLabel instanceof Label) {
            ((Label)this.textLabel).setText(title);
            this.updateLabelTrim();
        } else if (this.textLabel instanceof Hyperlink) {
            ((Hyperlink)this.textLabel).setText(title);
        } else {
            return;
        }
        this.layout();
    }

    public String getText() {
        if (this.textLabel instanceof Label) {
            return ((Label)this.textLabel).getText();
        }
        if (this.textLabel instanceof Hyperlink) {
            return ((Hyperlink)this.textLabel).getText();
        }
        return "";
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        if (this.toggle != null) {
            this.toggle.setToolTipText(string);
        }
        if (this.imageLabel != null) {
            this.imageLabel.setToolTipText(string);
        }
        if (this.textLabel != null) {
            this.textLabel.setToolTipText(string);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public int getExpansionStyle() {
        return this.expansionStyle;
    }

    public void setExpanded(boolean expanded) {
        this.internalSetExpanded(expanded);
        if (this.toggle != null) {
            this.toggle.setExpanded(expanded);
        }
    }

    protected void internalSetExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            this.expanded = expanded;
            if (this.getDescriptionControl() != null) {
                this.getDescriptionControl().setVisible(expanded);
            }
            if (this.client != null) {
                this.client.setVisible(expanded);
            }
            this.reflow();
        }
    }

    public void addExpansionListener(IExpansionListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeExpansionListener(IExpansionListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void onPaint(PaintEvent e) {
    }

    protected Control getDescriptionControl() {
        return null;
    }

    protected Control getSeparatorControl() {
        return null;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        ExpandableLayout layout = (ExpandableLayout)this.getLayout();
        Point size = wHint == -1 || hHint == -1 ? layout.computeSize((Composite)this, wHint, hHint, changed) : new Point(wHint, hHint);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    protected boolean isFixedStyle() {
        return (this.expansionStyle & 2) == 0;
    }

    protected boolean hasTitleBar() {
        return (this.getExpansionStyle() & 0x100) != 0 || (this.getExpansionStyle() & 0x200) != 0;
    }

    public void setTitleBarForeground(Color color) {
        this.titleBarForeground = color;
        if (this.textLabel != null) {
            this.textLabel.setForeground(color);
        }
    }

    public Color getTitleBarForeground() {
        return this.titleBarForeground;
    }

    private void toggleState() {
        boolean newState = !this.isExpanded();
        this.fireExpanding(newState, true);
        this.internalSetExpanded(newState);
        this.fireExpanding(newState, false);
        if (newState) {
            FormToolkit.ensureVisible((Control)this);
        }
    }

    private void fireExpanding(boolean state, boolean before) {
        ImIdentityList listenerList = this.listeners.toList();
        if (listenerList.isEmpty()) {
            return;
        }
        ExpansionEvent e = new ExpansionEvent((Object)this, state);
        for (IExpansionListener listener : listenerList) {
            if (before) {
                listener.expansionStateChanging(e);
                continue;
            }
            listener.expansionStateChanged(e);
        }
    }

    private void verticalMove(boolean down) {
        Composite parent = this.getParent();
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child == this) {
                ExpandableRowComposite sibling = this.getSibling(children, i, down);
                if (sibling == null || sibling.toggle == null) break;
                sibling.setFocus();
                break;
            }
            ++i;
        }
    }

    private ExpandableRowComposite getSibling(Control[] children, int index, boolean down) {
        int loc = down ? index + 1 : index - 1;
        while (loc >= 0 && loc < children.length) {
            Control c = children[loc];
            if (c instanceof ExpandableRowComposite && c.isVisible()) {
                return (ExpandableRowComposite)c;
            }
            int n = loc = down ? loc + 1 : loc - 1;
        }
        return null;
    }

    private void programmaticToggleState() {
        if (this.toggle != null) {
            this.toggle.setExpanded(!this.toggle.isExpanded());
        }
        this.toggleState();
    }

    private void paintTitleFocus(GC gc) {
        Point size = this.textLabel.getSize();
        gc.setBackground(this.textLabel.getBackground());
        gc.setForeground(this.textLabel.getForeground());
        if (this.toggle.isFocusControl()) {
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    /*
     * Unable to fully structure code
     */
    void reflow() {
        c = this;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite || c instanceof Shell) break;
        }
        try {
            for (c = this; c != null; c = c.getParent()) {
                c.requestLayout();
                if (!(c instanceof SharedScrolledComposite)) continue;
                ((SharedScrolledComposite)c).reflow(true);
            }
        }
        finally {
            c = this;
            ** while (c != null)
        }
lbl-1000:
        // 1 sources

        {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite || c instanceof Shell) break;
            continue;
        }
lbl21:
        // 2 sources

    }

    private void updateLabelTrim() {
    }

    private class ExpandableLayout
    extends Layout
    implements ILayoutExtension {
        private final SizeCache toggleCache = new SizeCache();
        private final SizeCache textClientCache = new SizeCache();
        private final SizeCache textLabelCache = new SizeCache();
        private final SizeCache descriptionCache = new SizeCache();
        private final SizeCache clientCache = new SizeCache();

        private ExpandableLayout() {
        }

        private void initCache(boolean shouldFlush) {
            this.toggleCache.setControl((Control)ExpandableRowComposite.this.toggle);
            this.textLabelCache.setControl(ExpandableRowComposite.this.textLabel);
            this.descriptionCache.setControl(ExpandableRowComposite.this.getDescriptionControl());
            this.clientCache.setControl(ExpandableRowComposite.this.client);
            if (shouldFlush) {
                this.toggleCache.flush();
                this.textClientCache.flush();
                this.textLabelCache.flush();
                this.descriptionCache.flush();
                this.clientCache.flush();
            }
        }

        protected void layout(Composite parent, boolean changed) {
            Control separatorControl;
            int tbarHeight;
            this.initCache(changed);
            Rectangle clientArea = parent.getClientArea();
            int thmargin = 0;
            int tvmargin = 0;
            if (ExpandableRowComposite.this.hasTitleBar()) {
                thmargin = ExpandableRowComposite.this.titleBarTextMarginWidth;
                tvmargin = 3;
            }
            int x = ExpandableRowComposite.this.marginWidth + thmargin;
            int y = ExpandableRowComposite.this.marginHeight + tvmargin;
            Point toggleSize = NULL_SIZE;
            if (ExpandableRowComposite.this.toggle != null) {
                toggleSize = this.toggleCache.computeSize(-1, -1);
            }
            Point imageSize = NULL_SIZE;
            if (ExpandableRowComposite.this.imageLabel != null) {
                imageSize = ExpandableRowComposite.this.imageLabel.computeSize(16, 16);
            }
            int toggleWidth = clientArea.width - ExpandableRowComposite.this.marginWidth - ExpandableRowComposite.this.marginWidth - thmargin - thmargin;
            if (toggleSize.x > 0) {
                toggleWidth -= toggleSize.x + 4;
            }
            if (imageSize.x > 0) {
                toggleWidth -= imageSize.x;
            }
            Point size = NULL_SIZE;
            if (ExpandableRowComposite.this.textLabel != null) {
                size = this.textLabelCache.computeSize(toggleWidth, -1);
                if (ExpandableRowComposite.this.textLabel instanceof Label) {
                    Point defSize = this.textLabelCache.computeSize(-1, -1);
                    if (defSize.y == size.y) {
                        size.x = Math.min(defSize.x, size.x);
                    }
                }
            }
            GC gc = new GC((Drawable)ExpandableRowComposite.this);
            gc.setFont(ExpandableRowComposite.this.getFont());
            FontMetrics fm = gc.getFontMetrics();
            int theaderHeight = fm.getHeight();
            gc.dispose();
            if (imageSize.y > theaderHeight) {
                theaderHeight = imageSize.y;
            }
            if (ExpandableRowComposite.this.toggle != null) {
                int ty = theaderHeight / 2 - toggleSize.y / 2 + 1;
                ty = Math.max(ty, 0);
                ExpandableRowComposite.this.toggle.setLocation(x, ty += ExpandableRowComposite.this.marginHeight + tvmargin);
                ExpandableRowComposite.this.toggle.setSize(toggleSize);
                x += toggleSize.x + 4;
            }
            if (ExpandableRowComposite.this.imageLabel != null) {
                int iy = theaderHeight / 2 - imageSize.y / 2;
                ExpandableRowComposite.this.imageLabel.setBounds(x, iy, imageSize.x, imageSize.y);
            }
            if (ExpandableRowComposite.this.textLabel != null) {
                int ty = theaderHeight / 2 - size.y / 2;
                int tx = x;
                if (ExpandableRowComposite.this.imageLabel != null) {
                    tx += imageSize.x + 4;
                }
                if ("gtk".equals(Platform.getWS())) {
                    ++size.x;
                }
                this.textLabelCache.setBounds(tx, ty, size.x, size.y);
            }
            if (size.y > (tbarHeight = theaderHeight)) {
                tbarHeight = size.y;
            }
            y += tbarHeight;
            if (ExpandableRowComposite.this.hasTitleBar()) {
                y += tvmargin;
            }
            if ((separatorControl = ExpandableRowComposite.this.getSeparatorControl()) != null) {
                separatorControl.setBounds(ExpandableRowComposite.this.marginWidth, y += 3, clientArea.width - ExpandableRowComposite.this.marginWidth - ExpandableRowComposite.this.marginWidth, 2);
                y += 2;
            }
            if (ExpandableRowComposite.this.expanded && ExpandableRowComposite.this.client != null) {
                int areaWidth = clientArea.width - ExpandableRowComposite.this.marginWidth - thmargin;
                int cx = ExpandableRowComposite.this.marginWidth + thmargin;
                if ((ExpandableRowComposite.this.expansionStyle & 0x10) != 0) {
                    cx = x;
                }
                areaWidth -= cx;
                if (ExpandableRowComposite.this.getDescriptionControl() != null) {
                    if (ExpandableRowComposite.this.expanded) {
                        y += 3;
                    }
                    Point dsize = this.descriptionCache.computeSize(areaWidth, -1);
                    this.descriptionCache.setBounds(cx, y += ExpandableRowComposite.this.descriptionVerticalSpacing, areaWidth, dsize.y);
                    y += dsize.y + ExpandableRowComposite.this.clientVerticalSpacing;
                }
                int cwidth = areaWidth;
                int cheight = clientArea.height - ExpandableRowComposite.this.marginHeight - ExpandableRowComposite.this.marginHeight - (y += ExpandableRowComposite.this.clientVerticalSpacing);
                this.clientCache.setBounds(cx, y, cwidth, cheight);
            }
            ((ExpandableRowComposite)ExpandableRowComposite.this).titleHeaderRegion.x = ExpandableRowComposite.this.marginWidth;
            ((ExpandableRowComposite)ExpandableRowComposite.this).titleHeaderRegion.y = ExpandableRowComposite.this.marginHeight;
            ((ExpandableRowComposite)ExpandableRowComposite.this).titleHeaderRegion.width = clientArea.width - ExpandableRowComposite.this.marginWidth - ExpandableRowComposite.this.marginWidth;
            ((ExpandableRowComposite)ExpandableRowComposite.this).titleHeaderRegion.height = theaderHeight;
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
            Control separatorControl;
            int innerwHint;
            this.initCache(changed);
            int width = 0;
            int height = 0;
            Point toggleSize = NULL_SIZE;
            int toggleWidth = 0;
            if (ExpandableRowComposite.this.toggle != null) {
                toggleSize = this.toggleCache.computeSize(-1, -1);
                toggleWidth = toggleSize.x + 4;
            }
            int thmargin = 0;
            int tvmargin = 0;
            Point imageSize = NULL_SIZE;
            if (ExpandableRowComposite.this.imageLabel != null) {
                imageSize = ExpandableRowComposite.this.imageLabel.computeSize(16, 16);
            }
            if (ExpandableRowComposite.this.hasTitleBar()) {
                thmargin = ExpandableRowComposite.this.titleBarTextMarginWidth;
                tvmargin = 3;
            }
            if ((innerwHint = wHint) != -1) {
                innerwHint -= toggleWidth + ExpandableRowComposite.this.marginWidth + ExpandableRowComposite.this.marginWidth + thmargin + thmargin;
                if (imageSize.x > 0) {
                    innerwHint -= imageSize.x + 4;
                }
            }
            int innertHint = innerwHint;
            Point size = NULL_SIZE;
            if (ExpandableRowComposite.this.textLabel != null) {
                size = this.textLabelCache.computeSize(innertHint, -1);
                if (ExpandableRowComposite.this.textLabel instanceof Label) {
                    Point defSize = this.textLabelCache.computeSize(-1, -1);
                    if (defSize.y == size.y) {
                        size.x = Math.min(defSize.x, size.x);
                    }
                }
            }
            if (toggleWidth > 0) {
                width += toggleWidth;
            }
            if (imageSize.x > 0) {
                width += imageSize.x + 4;
            }
            if (size.x > 0) {
                width += size.x;
            }
            if (toggleSize.y > height) {
                height = toggleSize.y;
            }
            if (imageSize.y > height) {
                height = imageSize.y;
            }
            if (size.y > height) {
                height = size.y;
            }
            if ((separatorControl = ExpandableRowComposite.this.getSeparatorControl()) != null) {
                height += 5;
            }
            if (wHint < width && size.x > 50) {
                width -= size.x - 50;
            }
            if ((ExpandableRowComposite.this.expanded || (ExpandableRowComposite.this.expansionStyle & 0x20) == 0) && ExpandableRowComposite.this.client != null) {
                int cwHint = wHint;
                int clientIndent = 0;
                if ((ExpandableRowComposite.this.expansionStyle & 0x10) != 0) {
                    clientIndent = toggleWidth;
                }
                if (cwHint != -1) {
                    cwHint -= ExpandableRowComposite.this.marginWidth + ExpandableRowComposite.this.marginWidth + thmargin + thmargin;
                }
                Point csize = this.clientCache.computeSize(cwHint, -1);
                if (ExpandableRowComposite.this.getDescriptionControl() != null) {
                    int dwHint = cwHint;
                    if (dwHint == -1) {
                        dwHint = csize.x;
                        if ((ExpandableRowComposite.this.expansionStyle & 0x10) != 0) {
                            dwHint -= toggleWidth;
                        }
                    }
                    Point dsize = this.descriptionCache.computeSize(dwHint, -1);
                    width = Math.max(width, dsize.x + clientIndent);
                    if (ExpandableRowComposite.this.expanded) {
                        if (separatorControl != null) {
                            height += 3;
                        }
                        height += ExpandableRowComposite.this.descriptionVerticalSpacing + dsize.y;
                    }
                }
                width = Math.max(width, csize.x + clientIndent);
                if (ExpandableRowComposite.this.expanded) {
                    height += ExpandableRowComposite.this.clientVerticalSpacing;
                    height += csize.y;
                }
            }
            Point result = new Point(width + ExpandableRowComposite.this.marginWidth + ExpandableRowComposite.this.marginWidth + thmargin + thmargin, height + ExpandableRowComposite.this.marginHeight + ExpandableRowComposite.this.marginHeight + tvmargin + tvmargin);
            return result;
        }

        public int computeMinimumWidth(Composite parent, boolean changed) {
            return this.computeSize((Composite)parent, (int)0, (int)-1, (boolean)changed).x;
        }

        public int computeMaximumWidth(Composite parent, boolean changed) {
            return this.computeSize((Composite)parent, (int)-1, (int)-1, (boolean)changed).x;
        }
    }

    private static class Toggle
    extends Twistie {
        public Toggle(Composite parent, int style) {
            super(parent, style);
        }

        public void setHover(boolean on) {
            this.hover = on;
        }

        public boolean getHover() {
            return this.hover;
        }

        protected void paint(PaintEvent e) {
            GC gc = e.gc;
            Rectangle clientArea = this.getClientArea();
            if (clientArea.width == 0 || clientArea.height == 0) {
                return;
            }
            this.paintHyperlink(gc);
        }
    }
}

