/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.SingleValue;

@NonNullByDefault
public abstract class NSGet
extends RAstNode {
    SingleValue namespace;
    int operatorOffset;
    SingleValue element;

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2;
    }

    @Override
    public final RAstNode getChild(int index) {
        switch (index) {
            case 0: {
                return this.namespace;
            }
            case 1: {
                return this.element;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final RAstNode[] getChildren() {
        return new RAstNode[]{this.namespace, this.element};
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.namespace == child) {
            return 0;
        }
        if (this.element == child) {
            return 1;
        }
        return -1;
    }

    public final RAstNode getNamespaceChild() {
        return this.namespace;
    }

    public final RAstNode getElementChild() {
        return this.element;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.namespace.acceptInR(visitor);
        this.element.acceptInR(visitor);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.namespace);
        visitor.visit((AstNode)this.element);
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        return null;
    }

    @Override
    final @Nullable Expression getLeftExpr() {
        return null;
    }

    @Override
    final @Nullable Expression getRightExpr() {
        return null;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        return this.getNodeType() == element.getNodeType();
    }

    @Override
    public final boolean equalsValue(RAstNode element) {
        if (this.getNodeType() == element.getNodeType()) {
            NSGet other = (NSGet)element;
            return this.namespace.equalsValue(other.namespace) && this.element.equalsValue(other.element);
        }
        return false;
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        throw new IllegalArgumentException();
    }

    final void updateOffsets() {
        this.startOffset = this.namespace.startOffset;
        this.endOffset = this.element.endOffset;
    }

    static final class Internal
    extends NSGet {
        Internal() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.NS_GET_INT;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.NS_GET_INT;
        }
    }

    static final class Std
    extends NSGet {
        Std() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.NS_GET;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.NS_GET;
        }
    }
}

