/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.SingleValue;

@NonNullByDefault
public final class FDef
extends RAstNode {
    int argsOpenOffset = Integer.MIN_VALUE;
    Args args = new Args(this);
    int argsCloseOffset = Integer.MIN_VALUE;
    final Expression expr = new Expression();

    FDef() {
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.F_DEF;
    }

    @Override
    public final RTerminal getOperator(int index) {
        return RTerminal.FUNCTION;
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2;
    }

    @Override
    public final RAstNode getChild(int index) {
        switch (index) {
            case 0: {
                return this.args;
            }
            case 1: {
                return this.expr.node;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final RAstNode[] getChildren() {
        return new RAstNode[]{this.args, this.expr.node};
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.args == child) {
            return 0;
        }
        if (this.expr.node == child) {
            return 1;
        }
        return -1;
    }

    public final int getArgsOpenOffset() {
        return this.argsOpenOffset;
    }

    public final Args getArgsChild() {
        return this.args;
    }

    public final int getArgsCloseOffset() {
        return this.argsCloseOffset;
    }

    public final RAstNode getContChild() {
        return this.expr.node;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.args.acceptInR(visitor);
        this.expr.node.acceptInR(visitor);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.args);
        visitor.visit((AstNode)this.expr.node);
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        if (this.expr.node == child) {
            return this.expr;
        }
        return null;
    }

    @Override
    final @Nullable Expression getLeftExpr() {
        return null;
    }

    @Override
    final Expression getRightExpr() {
        return this.expr;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        return NodeType.F_DEF == element.getNodeType();
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        if (expr == this.expr) {
            return 70502;
        }
        throw new IllegalArgumentException();
    }

    final void updateOffsets() {
        this.endOffset = this.expr.node != null ? this.expr.node.endOffset : (this.argsCloseOffset != Integer.MIN_VALUE ? this.argsCloseOffset + 1 : (this.args != null ? this.args.endOffset : (this.argsOpenOffset != Integer.MIN_VALUE ? this.argsOpenOffset + 1 : this.startOffset + 8)));
    }

    public static final class Arg
    extends RAstNode {
        SingleValue argName;
        boolean withDefault;
        final Expression defaultExpr = new Expression();

        Arg(Args parent) {
            this.rParent = parent;
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.F_DEF_ARG;
        }

        @Override
        public final @Nullable RTerminal getOperator(int index) {
            return null;
        }

        @Override
        public @Nullable Args getRParent() {
            return (Args)this.rParent;
        }

        @Override
        public final boolean hasChildren() {
            return true;
        }

        @Override
        public final int getChildCount() {
            return 2;
        }

        @Override
        public final RAstNode getChild(int index) {
            switch (index) {
                case 0: {
                    return this.argName;
                }
                case 1: {
                    if (!this.withDefault) break;
                    return this.defaultExpr.node;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public final RAstNode[] getChildren() {
            if (this.withDefault) {
                return new RAstNode[]{this.argName, this.defaultExpr.node};
            }
            return new RAstNode[]{this.argName};
        }

        @Override
        public final int getChildIndex(AstNode child) {
            if (this.argName == child) {
                return 0;
            }
            if (this.defaultExpr.node == child) {
                return 1;
            }
            return -1;
        }

        public final RAstNode getNameChild() {
            return this.argName;
        }

        public final boolean hasDefault() {
            return this.withDefault;
        }

        public final RAstNode getDefaultChild() {
            return this.defaultExpr.node;
        }

        @Override
        public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
            visitor.visit(this);
        }

        @Override
        public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
            this.argName.acceptInR(visitor);
            if (this.withDefault) {
                this.defaultExpr.node.acceptInR(visitor);
            }
        }

        public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
            visitor.visit((AstNode)this.argName);
            if (this.withDefault) {
                visitor.visit((AstNode)this.defaultExpr.node);
            }
        }

        @Override
        final @Nullable Expression getExpr(RAstNode child) {
            if (this.defaultExpr.node == child) {
                return this.defaultExpr;
            }
            return null;
        }

        @Override
        final @Nullable Expression getLeftExpr() {
            return null;
        }

        @Override
        final Expression getRightExpr() {
            return this.defaultExpr;
        }

        Expression addDefault() {
            this.withDefault = true;
            return this.defaultExpr;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return NodeType.F_DEF_ARG == element.getNodeType();
        }

        @Override
        final int getMissingExprStatus(Expression expr) {
            if (this.withDefault && this.defaultExpr == expr) {
                return 70534;
            }
            throw new IllegalArgumentException();
        }
    }

    public static final class Args
    extends RAstNode {
        final List<Arg> specs;

        Args(FDef parent) {
            this.rParent = parent;
            this.specs = new ArrayList<Arg>(0);
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.F_DEF_ARGS;
        }

        @Override
        public final @Nullable RTerminal getOperator(int index) {
            return null;
        }

        @Override
        public final FDef getRParent() {
            return (FDef)this.rParent;
        }

        @Override
        public final boolean hasChildren() {
            return !this.specs.isEmpty();
        }

        @Override
        public final int getChildCount() {
            return this.specs.size();
        }

        @Override
        public final Arg getChild(int index) {
            return this.specs.get(index);
        }

        public final Arg[] getChildren() {
            return this.specs.toArray(new Arg[this.specs.size()]);
        }

        @Override
        public final int getChildIndex(AstNode child) {
            int i = this.specs.size() - 1;
            while (i >= 0) {
                if (this.specs.get(i) == child) {
                    return i;
                }
                --i;
            }
            return -1;
        }

        @Override
        public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
            visitor.visit(this);
        }

        @Override
        public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
            this.acceptChildren(visitor, this.specs);
        }

        public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
            for (RAstNode rAstNode : this.specs) {
                visitor.visit((AstNode)rAstNode);
            }
        }

        @Override
        final @Nullable Expression getExpr(RAstNode child) {
            return null;
        }

        @Override
        final @Nullable Expression getLeftExpr() {
            return null;
        }

        @Override
        final @Nullable Expression getRightExpr() {
            return null;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return NodeType.F_DEF_ARGS == element.getNodeType();
        }

        @Override
        final int getMissingExprStatus(Expression expr) {
            throw new IllegalArgumentException();
        }
    }
}

