/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgManagerImpl;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.core.pkgmanager.IRPkgInfoAndData;
import org.eclipse.statet.r.core.pkgmanager.ISelectedRepos;
import org.eclipse.statet.r.core.pkgmanager.RPkgAction;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.core.tool.IRConsoleService;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RPkgType;
import org.eclipse.statet.rj.renv.runtime.RLibLocationInfo;
import org.eclipse.statet.rj.services.RPlatform;

public class RPkgOperator {
    private final RPkgManagerImpl manager;
    private final IREnvConfiguration envConfig;
    private final ISelectedRepos repos;
    private IRConsoleService r;
    private String tempDir;
    private Set<String> createdDirs;

    public RPkgOperator(RPkgManagerImpl manager, IREnvConfiguration config, ISelectedRepos repos) {
        this.manager = manager;
        this.envConfig = config;
        this.repos = repos;
    }

    public RPkgOperator(RPkgManagerImpl manager) {
        this(manager, (IREnvConfiguration)manager.getREnv().get(IREnvConfiguration.class), manager.getSelectedRepos());
    }

    private String requireTempDir(ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        if (this.tempDir == null) {
            this.tempDir = RDataUtils.checkSingleCharValue((RObject)this.r.evalData("tempdir()", m));
        }
        return this.tempDir;
    }

    private void requireLibDir(String dir, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        if (this.createdDirs == null) {
            this.createdDirs = new HashSet<String>();
        }
        if (this.createdDirs.contains(dir)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        sb.append("dir.create(");
        sb.append('\"').append(RUtil.escapeCompletely(dir)).append('\"');
        sb.append(", showWarnings= FALSE");
        sb.append(", recursive= TRUE");
        sb.append(')');
        this.r.evalVoid(sb.toString(), m);
        sb.setLength(0);
        sb.append("file.access(");
        sb.append('\"').append(RUtil.escapeCompletely(dir)).append('\"');
        sb.append(", 3L");
        sb.append(')');
        if (RDataUtils.checkSingleIntValue((RObject)this.r.evalData(sb.toString(), m)) != 0) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", 0, NLS.bind((String)"An error occurred when creating the R library location ''{0}''.", (Object)dir), null));
        }
        sb.setLength(0);
        sb.append(".libPaths(");
        sb.append("c(");
        sb.append('\"').append(RUtil.escapeCompletely(dir)).append('\"');
        sb.append(", .libPaths())");
        sb.append(')');
        this.r.evalVoid(sb.toString(), m);
        this.createdDirs.add(dir);
    }

    void runActions(List<? extends RPkgAction> actions, IRConsoleService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        m.setWorkRemaining(actions.size());
        this.r = r;
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < actions.size()) {
                m.setWorkRemaining(actions.size() - i);
                RPkgAction action = actions.get(i);
                if (action.getAction() == 2) {
                    this.installPkg((RPkgAction.Install)action, sb, m.newSubMonitor(1));
                } else if (action.getAction() == 1) {
                    this.uninstallPkg((RPkgAction.Uninstall)action, sb, m.newSubMonitor(1));
                }
                ++i;
            }
        }
        finally {
            this.r = null;
        }
    }

    private void installPkg(RPkgAction.Install action, StringBuilder sb, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        String name = action.getPkg().getName();
        m.beginSubTask(NLS.bind((String)"Installing R package ''{0}''...", (Object)name));
        m.setWorkRemaining(10);
        sb.setLength(0);
        sb.append("install.packages(");
        RRepo repo = this.repos.getRepo(action.getRepoId());
        if (repo == null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", NLS.bind((String)"Repository ({0}) not found.", (Object)action.getRepoId())));
        }
        if (repo.getId().startsWith("special-ws-cache-")) {
            try {
                String fileName;
                IFileStore store = this.manager.getCache().get(name, repo.getPkgType(), EStatusUtils.convert((ProgressMonitor)m.newSubMonitor(1)));
                if (RPkgUtils.checkPkgType((String)store.getName(), (RPlatform)this.manager.getRPlatform()) != repo.getPkgType()) {
                    throw new IllegalStateException();
                }
                if (this.envConfig.isRemote()) {
                    InputStream in = store.openInputStream(0, EStatusUtils.convert((ProgressMonitor)m.newSubMonitor(0)));
                    try {
                        fileName = String.valueOf(this.requireTempDir(m.newSubMonitor(1))) + this.r.getPlatform().getFileSep() + store.getName();
                        this.r.uploadFile(in, store.fetchInfo().getLength(), fileName, 0, m.newSubMonitor(3));
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                fileName = store.toLocalFile(0, EStatusUtils.convert((ProgressMonitor)m.newSubMonitor(0))).getPath();
                sb.append('\"').append(RUtil.escapeCompletely(fileName)).append('\"');
                sb.append(", repos= NULL");
            }
            catch (CoreException e) {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", "An error occurred while preparing the package file", (Throwable)e));
            }
        }
        sb.append('\"').append(name).append('\"');
        sb.append(", repos= ");
        sb.append('\"').append(RUtil.escapeCompletely(repo.getURL())).append('\"');
        if (repo.getPkgType() != null) {
            sb.append(", type= ");
            sb.append('\"').append(RPkgUtils.getPkgTypeInstallKey((RPlatform)this.r.getPlatform(), (RPkgType)repo.getPkgType())).append('\"');
        }
        sb.append(", lib= ");
        RLibLocationInfo info = this.getLibLocationInfo(action.getLibLocation());
        if (!info.isWritable()) {
            return;
        }
        if (!info.isDirectoryExists()) {
            this.requireLibDir(info.getDirectoryRPath(), m);
        }
        sb.append('\"').append(RUtil.escapeCompletely(info.getDirectoryRPath())).append('\"');
        sb.append(", dependencies= FALSE");
        sb.append(')');
        this.r.submitToConsole(sb.toString(), m);
        this.manager.pkgScanner.addExpectedPkg(action.getLibLocation(), action.getPkg());
    }

    private void uninstallPkg(RPkgAction.Uninstall action, StringBuilder sb, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        String name = action.getPkg().getName();
        m.beginSubTask(NLS.bind((String)"Uninstalling R package ''{0}''...", (Object)name));
        sb.setLength(0);
        sb.append("remove.packages(");
        sb.append('\"').append(name).append('\"');
        sb.append(", lib= ");
        RLibLocationInfo info = this.getLibLocationInfo(action.getLibLocation());
        if (!info.isWritable()) {
            return;
        }
        sb.append('\"').append(RUtil.escapeCompletely(info.getDirectoryRPath())).append('\"');
        sb.append(')');
        this.r.submitToConsole(sb.toString(), m);
    }

    void loadPkgs(List<? extends IRPkgInfoAndData> pkgs, boolean expliciteLocation, IRConsoleService r, ProgressMonitor m) throws StatusException {
        this.r = r;
        this.r.briefAboutToChange();
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < pkgs.size()) {
                IRPkgInfoAndData pkgData = pkgs.get(i);
                m.beginSubTask(NLS.bind((String)"Loading R package ''{0}''...", (Object)pkgData.getName()));
                sb.setLength(0);
                sb.append("library(");
                sb.append('\"').append(pkgData.getName()).append('\"');
                if (expliciteLocation) {
                    RLibLocationInfo info = this.getLibLocationInfo(pkgData.getLibLocation());
                    sb.append(", lib.loc= ");
                    sb.append('\"').append(RUtil.escapeCompletely(info.getDirectoryRPath())).append('\"');
                }
                sb.append(')');
                this.r.submitToConsole(sb.toString(), m);
                ++i;
            }
        }
        finally {
            this.r.briefChanged(1);
            this.r = null;
        }
    }

    private RLibLocationInfo getLibLocationInfo(RLibLocation libLocation) throws StatusException {
        RLibLocationInfo info = this.manager.getRLibPaths().getInfo(libLocation);
        if (info == null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", String.format("Location '%1$s' not available.", libLocation)));
        }
        return info;
    }
}

