/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.ui.IWorkbenchPart;

public class MultiContentSectionHandler
extends AbstractHandler {
    private static final Object NULL = new Object();
    private final DocContentSections sections;
    private final Map<String, Object> handlers = new IdentityHashMap<String, Object>(8);
    private ISourceEditor expliciteEditor;

    public MultiContentSectionHandler(DocContentSections sections) {
        if (sections == null) {
            throw new NullPointerException("sections");
        }
        this.sections = sections;
    }

    public MultiContentSectionHandler(DocContentSections sections, String sectionType1, IHandler2 handler1) {
        this(sections, sectionType1, handler1, null, null);
    }

    public MultiContentSectionHandler(DocContentSections sections, String sectionType1, IHandler2 handler1, String sectionType2, IHandler2 handler2) {
        this(sections);
        if (sectionType1 != null) {
            this.registerHandler(sectionType1, handler1);
        }
        if (sectionType2 != null) {
            this.registerHandler(sectionType2, handler2);
        }
    }

    protected void setEditor(ISourceEditor editor) {
        this.expliciteEditor = editor;
    }

    protected final DocContentSections getSections() {
        return this.sections;
    }

    public void dispose() {
        super.dispose();
        for (Object handler : this.handlers.values()) {
            if (handler == NULL) continue;
            ((IHandler2)handler).dispose();
        }
        this.handlers.clear();
    }

    protected ISourceEditor getEditor(Object applicationContext) {
        if (this.expliciteEditor != null) {
            return this.expliciteEditor;
        }
        IWorkbenchPart activePart = WorkbenchUIUtils.getActivePart((Object)applicationContext);
        if (activePart instanceof ISourceEditor) {
            return (ISourceEditor)activePart;
        }
        return (ISourceEditor)activePart.getAdapter(ISourceEditor.class);
    }

    public void registerHandler(String sectionType, IHandler2 handler) {
        if (sectionType == null) {
            throw new NullPointerException("sectionType");
        }
        this.handlers.put(sectionType, handler);
    }

    protected final IHandler2 getHandler(String sectionType) {
        if (sectionType == "") {
            return null;
        }
        Object handler = this.handlers.get(sectionType);
        if (handler == null) {
            handler = NULL;
            try {
                IHandler2 newHandler = this.createHandler(sectionType);
                if (newHandler != null) {
                    handler = newHandler;
                }
            }
            finally {
                this.handlers.put(sectionType, handler);
            }
        }
        return handler != NULL ? (IHandler2)handler : null;
    }

    protected IHandler2 createHandler(String sectionType) {
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISourceEditor editor = this.getEditor(event.getApplicationContext());
        if (editor == null) {
            return null;
        }
        SourceViewer viewer = editor.getViewer();
        if (viewer == null) {
            return null;
        }
        IHandler2 handler = this.getHandler(this.sections.getType(viewer.getDocument(), viewer.getSelectedRange().x));
        if (handler != null) {
            return handler.execute(event);
        }
        return null;
    }
}

