/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.ElementChangedEvent;
import org.eclipse.statet.ltk.model.core.ElementChangedListener;
import org.eclipse.statet.ltk.model.core.ModelManager;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementDelta;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.ModelElementInputListener;
import org.eclipse.statet.ltk.ui.ModelElementInputProvider;

public class ElementInfoController
implements ModelElementInputProvider,
Disposable {
    private static int NEWINPUT_DELAY = 100;
    private final ModelManager modelProvider;
    private final WorkingContext modelContext;
    private final ElementChangedListener elementChangeListener;
    private final CopyOnWriteIdentityListSet<ModelElementInputListener> listenerList = new CopyOnWriteIdentityListSet();
    private final CopyOnWriteIdentityListSet<ModelElementInputListener> newListenerList = new CopyOnWriteIdentityListSet();
    private final Object inputLock = new Object();
    private volatile SourceUnit input;
    private SourceUnit newInput;
    private final NewInputUpdater newInputJob = new NewInputUpdater();
    private final IProgressMonitor notifyMonitor = new NullProgressMonitor();

    public ElementInfoController(ModelManager manager, WorkingContext context) {
        this.elementChangeListener = new ElementChangedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void elementChanged(ElementChangedEvent event) {
                ImIdentityList listeners;
                SourceUnit input;
                Object object = ElementInfoController.this.inputLock;
                synchronized (object) {
                    if (ElementInfoController.this.newInput != null && ElementInfoController.this.newInput.equals(event.delta.getModelElement())) {
                        if (ElementInfoController.this.newInputJob.getState() != 2) {
                            ElementInfoController.this.newInputJob.schedule();
                        }
                        return;
                    }
                    if (ElementInfoController.this.input == null || !ElementInfoController.this.input.equals(event.delta.getModelElement())) {
                        return;
                    }
                    input = ElementInfoController.this.input;
                    listeners = ElementInfoController.this.listenerList.toList();
                }
                try {
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    Job.getJobManager().beginRule((ISchedulingRule)ElementInfoController.this.newInputJob, (IProgressMonitor)monitor);
                    ElementInfoController.this.notifyUpdated((ImIdentityList<ModelElementInputListener>)listeners, input, event.delta, (IProgressMonitor)monitor);
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)ElementInfoController.this.newInputJob);
                }
            }
        };
        this.modelProvider = manager;
        this.modelContext = context;
        this.modelProvider.addElementChangedListener(this.elementChangeListener, this.modelContext);
    }

    public void dispose() {
        this.modelProvider.removeElementChangedListener(this.elementChangeListener, this.modelContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(SourceUnit input) {
        Object object = this.inputLock;
        synchronized (object) {
            this.input = null;
            this.newInput = input;
            this.checkNewListeners();
            this.newInputJob.cancel();
            this.notifyChanged((ImIdentityList<ModelElementInputListener>)this.listenerList.toList(), input);
        }
        this.newInputJob.schedule(NEWINPUT_DELAY);
    }

    private ImIdentityList<ModelElementInputListener> checkNewListeners() {
        ImIdentityList listeners = this.newListenerList.clearToList();
        for (ModelElementInputListener listener : listeners) {
            this.listenerList.add((Object)listener);
        }
        return listeners;
    }

    private void notifyChanged(ImIdentityList<ModelElementInputListener> listeners, @Nullable SourceUnit input) {
        for (ModelElementInputListener listener : listeners) {
            listener.elementChanged(input);
        }
    }

    private void notifyInitial(ImIdentityList<ModelElementInputListener> listeners, SourceUnit input, IProgressMonitor monitor) {
        if (listeners.isEmpty() || input != this.input) {
            return;
        }
        try {
            input.connect(monitor);
            for (ModelElementInputListener listener : listeners) {
                if (input != this.input) {
                    return;
                }
                listener.elementInitialInfo(input);
            }
        }
        finally {
            input.disconnect(monitor);
        }
    }

    private void notifyUpdated(ImIdentityList<ModelElementInputListener> listeners, SourceUnit input, LtkModelElementDelta delta, IProgressMonitor monitor) {
        if (input != this.input) {
            return;
        }
        try {
            input.connect(monitor);
            for (ModelElementInputListener listener : listeners) {
                if (input != this.input) {
                    return;
                }
                listener.elementUpdatedInfo(input, delta);
            }
        }
        finally {
            input.disconnect(monitor);
        }
    }

    public SourceUnit getInput() {
        return this.input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ModelElementInputListener listener) {
        Object object = this.inputLock;
        synchronized (object) {
            SourceUnit input = this.newInput;
            if (input == null) {
                input = this.input;
            }
            if (input != null) {
                this.notifyChanged((ImIdentityList<ModelElementInputListener>)ImCollections.newIdentityList((Object)listener), input);
            }
            if (input == null || this.newInput == input) {
                this.listenerList.add((Object)listener);
                return;
            }
            this.newListenerList.add((Object)listener);
        }
        if (this.newInputJob.getState() != 2) {
            this.newInputJob.schedule();
        }
    }

    public void removeListener(ModelElementInputListener listener) {
        this.newListenerList.remove((Object)listener);
        this.listenerList.remove((Object)listener);
    }

    private class NewInputUpdater
    extends Job
    implements ISchedulingRule {
        public NewInputUpdater() {
            super("ViewPart Model Element Updater");
            this.setPriority(20);
            this.setRule(this);
            this.setSystem(true);
            this.setUser(false);
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            SourceUnit input;
            ImIdentityList listeners;
            Object object = ElementInfoController.this.inputLock;
            synchronized (object) {
                if (monitor.isCanceled() || ElementInfoController.this.input == null && ElementInfoController.this.newInput == null) {
                    return Status.CANCEL_STATUS;
                }
                if (ElementInfoController.this.newInput == null) {
                    listeners = ElementInfoController.this.checkNewListeners();
                } else {
                    AstInfo astInfo = ElementInfoController.this.newInput.getAstInfo(null, false, null);
                    if (astInfo == null || (astInfo.getLevel() & 0xF) < 1) {
                        return Status.CANCEL_STATUS;
                    }
                    ElementInfoController.this.input = ElementInfoController.this.newInput;
                    ElementInfoController.this.newInput = null;
                    ElementInfoController.this.checkNewListeners();
                    listeners = ElementInfoController.this.listenerList.toList();
                }
                input = ElementInfoController.this.input;
            }
            if (listeners != null) {
                ElementInfoController.this.notifyInitial((ImIdentityList<ModelElementInputListener>)listeners, input, monitor);
            }
            return Status.OK_STATUS;
        }

        protected void canceling() {
            ElementInfoController.this.notifyMonitor.setCanceled(true);
        }
    }
}

