/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public final class LtkModelUtils {
    public static @Nullable LtkModelElement<?> getModelElement(@Nullable Object element) {
        if (element instanceof LtkModelElement) {
            return (LtkModelElement)element;
        }
        if (element instanceof IAdaptable) {
            return (LtkModelElement)((IAdaptable)element).getAdapter(LtkModelElement.class);
        }
        return null;
    }

    public static @Nullable SourceUnit getSourceUnit(@Nullable LtkModelElement<?> element) {
        if (element instanceof SourceUnit) {
            return (SourceUnit)element;
        }
        if (element instanceof SourceElement) {
            return ((SourceElement)element).getSourceUnit();
        }
        return null;
    }

    public static final <T> boolean hasChildren(List<? extends @NonNull T> children, @Nullable LtkModelElementFilter<? super @NonNull T> filter) {
        if (filter == null) {
            return !children.isEmpty();
        }
        for (T child : children) {
            if (!filter.include(child)) continue;
            return true;
        }
        return false;
    }

    public static final <T> List<? extends T> getChildren(List<? extends @NonNull T> children, @Nullable LtkModelElementFilter<? super @NonNull T> filter) {
        if (filter == null) {
            return children;
        }
        ArrayList<T> filtered = new ArrayList<T>(children.size());
        for (T child : children) {
            if (!filter.include(child)) continue;
            filtered.add(child);
        }
        return filtered;
    }

    public static @Nullable SourceStructElement getCoveringSourceElement(SourceStructElement root, TextRegion region) {
        return LtkModelUtils.getCoveringSourceElement(root, region.getStartOffset(), region.getEndOffset());
    }

    public static @Nullable SourceStructElement getCoveringSourceElement(SourceStructElement root, int startOffset, int endOffset) {
        SourceStructElement ok = root;
        block0: while (ok != null) {
            List children = ok.getSourceChildren(null);
            for (SourceStructElement child : children) {
                int childEnd;
                int childOffset;
                TextRegion sourceRange = child.getSourceRange();
                TextRegion docRange = child.getDocumentationRange();
                int n = childOffset = docRange != null ? Math.min(sourceRange.getStartOffset(), docRange.getStartOffset()) : sourceRange.getStartOffset();
                if (startOffset < childOffset) break block0;
                int n2 = childEnd = docRange != null ? Math.max(sourceRange.getEndOffset(), docRange.getEndOffset()) : sourceRange.getEndOffset();
                if (!(startOffset < endOffset ? endOffset <= childEnd : endOffset < childEnd)) continue;
                ok = child;
                continue block0;
            }
        }
        return ok;
    }

    public static int searchCoveringSourceElement(List<? extends SourceStructElement> elements, int offset) {
        int low = 0;
        int high = elements.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            TextRegion region = elements.get(mid).getSourceRange();
            if (region.getEndOffset() < offset) {
                low = mid + 1;
                continue;
            }
            if (region.getStartOffset() > offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <T extends SourceStructElement> @Nullable T getCoveringSourceElement(List<T> elements, int offset) {
        int idx = LtkModelUtils.searchCoveringSourceElement(elements, offset);
        if (idx >= 0) {
            return (T)((SourceStructElement)elements.get(idx));
        }
        return null;
    }
}

