/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class CaseInsensitiveMap<V>
extends HashMap<String, V> {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> idNameMap;

    public CaseInsensitiveMap() {
        this.idNameMap = new HashMap<String, String>();
    }

    public CaseInsensitiveMap(int initialCapacity) {
        super(initialCapacity);
        this.idNameMap = new HashMap<String, String>(initialCapacity);
    }

    @Override
    public @Nullable V put(String name, V value) {
        Object prevValue;
        String id = name.toUpperCase();
        String oldName = this.idNameMap.put(id, name);
        if (!name.equals(oldName)) {
            prevValue = super.remove(oldName);
            super.put(name, value);
        } else {
            prevValue = super.put(name, value);
        }
        return prevValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> t) {
        for (Map.Entry<String, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public @Nullable V remove(@Nullable Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String id = ((String)key).toUpperCase();
        String realName = this.idNameMap.remove(id);
        if (realName == null) {
            return null;
        }
        return super.remove(realName);
    }

    @Override
    public void clear() {
        this.idNameMap.clear();
        super.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.idNameMap.isEmpty();
    }

    @Override
    public int size() {
        return this.idNameMap.size();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        String id = ((String)key).toUpperCase();
        return this.idNameMap.containsKey(id);
    }

    @Override
    public @Nullable V get(@Nullable Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String id = ((String)key).toUpperCase();
        String name = this.idNameMap.get(id);
        return name != null ? (V)super.get(name) : null;
    }
}

