/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core.input;

import org.eclipse.statet.jcommons.text.core.input.TextParserInput;

public final class OffsetStringParserInput
extends TextParserInput
implements CharSequence {
    private final String source;
    private final int sourceOffset;

    public OffsetStringParserInput(String source, int sourceOffset, int defaultBufferSize) {
        super(defaultBufferSize);
        this.source = source;
        this.sourceOffset = sourceOffset;
    }

    public OffsetStringParserInput(String source, int sourceOffset) {
        this(source, sourceOffset, Math.min(source.length(), 2048));
    }

    @Override
    protected int getSourceStartIndex() {
        return this.sourceOffset;
    }

    @Override
    protected int getSourceLength() {
        return this.source.length();
    }

    @Override
    protected String getSourceString() {
        return this.source;
    }

    @Override
    protected int getSourceStringIndex() {
        return this.sourceOffset;
    }

    @Override
    protected void doUpdateBuffer(int index, char[] buffer, int requiredLength, int recommendLength) {
        int length = Math.min(recommendLength, this.getStopIndex() - index);
        this.source.getChars(index - this.sourceOffset, index - this.sourceOffset + length, buffer, 0);
        this.setBuffer(buffer, 0, length);
    }

    @Override
    public int length() {
        return this.sourceOffset + this.source.length();
    }

    @Override
    public char charAt(int index) {
        return this.source.charAt(index - this.sourceOffset);
    }

    @Override
    public String subSequence(int start, int end) {
        return this.source.substring(this.sourceOffset + start, this.sourceOffset + end);
    }
}

