/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.text.rd;

import java.util.List;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.statet.ecommons.text.DefaultWhitespaceDetector;
import org.eclipse.statet.ecommons.text.core.rules.OperatorRule;
import org.eclipse.statet.ecommons.text.ui.presentation.AbstractRuleBasedScanner;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.r.core.rdoc.RdTags;

public class RdCodeScanner
extends AbstractRuleBasedScanner {
    public RdCodeScanner(TextStyleManager textStyles) {
        super(textStyles);
        this.initRules();
    }

    protected void createRules(List<IRule> rules) {
        String tag;
        IToken tDefaultText = this.getToken("text_Rd_rdDefault");
        IToken tSectionTag = this.getToken("text_Rd_rdSectionTag");
        IToken tSubSectionTag = this.getToken("text_Rd_rdSubSectionTag");
        IToken tOtherTag = this.getToken("text_Rd_rdOtherTag");
        IToken tUnlistedTag = this.getToken("text_Rd_rdUnlistedTag");
        IToken tBrackets = this.getToken("rdBrackets");
        this.setDefaultReturnToken(tDefaultText);
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new DefaultWhitespaceDetector()));
        OperatorRule charRule = new OperatorRule(new char[]{'\\', '{', '}'});
        charRule.addOps(RdTags.ESCAPED_CHARS, tOtherTag);
        charRule.addOps(RdTags.BRACKETS, tBrackets);
        rules.add((IRule)charRule);
        WordRule tagRule = new WordRule((IWordDetector)new TagDetector(), tUnlistedTag);
        String[] stringArray = RdTags.MAIN_SECTIONS;
        int n = RdTags.MAIN_SECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            tagRule.addWord(tag, tSectionTag);
            ++n2;
        }
        stringArray = RdTags.SUB_SECTIONS;
        n = RdTags.SUB_SECTIONS.length;
        n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            tagRule.addWord(tag, tSubSectionTag);
            ++n2;
        }
        stringArray = RdTags.TEXT_MARKUP_TAGs;
        n = RdTags.TEXT_MARKUP_TAGs.length;
        n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            tagRule.addWord(tag, tOtherTag);
            ++n2;
        }
        stringArray = RdTags.LIST_TABLE_TAGS;
        n = RdTags.LIST_TABLE_TAGS.length;
        n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            tagRule.addWord(tag, tOtherTag);
            ++n2;
        }
        stringArray = RdTags.MATH_TAGS;
        n = RdTags.MATH_TAGS.length;
        n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            tagRule.addWord(tag, tOtherTag);
            ++n2;
        }
        stringArray = RdTags.INSERTIONS;
        n = RdTags.INSERTIONS.length;
        n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            tagRule.addWord(tag, tOtherTag);
            ++n2;
        }
        rules.add((IRule)tagRule);
    }

    private static class TagDetector
    implements IWordDetector {
        private TagDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '\\';
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }
    }
}

