/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTarget;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.internal.r.debug.core.model.RObjectAdapter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.RValueFormatter;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public class RLanguageValue
extends RElementVariableValue<CombinedRElement> {
    private static final RObjectAdapter<RLanguage> ADAPTER = new RObjectAdapter(12);
    private @Nullable LazyRStore<RLanguage> detailObjectStore;

    static void appendValue(RValueFormatter valueFormatter, RLanguage rObject) {
        if (rObject.getLanguageType() == 1) {
            valueFormatter.appendName(rObject.getSource(), false);
        } else {
            valueFormatter.appendSourceLine(rObject.getSource(), 200);
        }
    }

    public RLanguageValue(RElementVariable variable) {
        super(variable);
    }

    public final RLanguage getRObject() {
        return (RLanguage)this.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getValueString() throws DebugException {
        RValueFormatter valueFormatter;
        LazyRStore.Fragment<RLanguage> fragment;
        RLanguageValue rLanguageValue = this;
        synchronized (rLanguageValue) {
            fragment = this.getDetailObjectFragment();
            if (fragment == null || fragment.getRObject() == null) {
                return "";
            }
        }
        RLanguage rObject = (RLanguage)fragment.getRObject();
        if (rObject.getSource() == null) {
            return "";
        }
        RValueFormatter rValueFormatter = valueFormatter = ((RDebugTarget)this.getDebugTarget()).getValueFormatter();
        synchronized (rValueFormatter) {
            valueFormatter.clear();
            RLanguageValue.appendValue(valueFormatter, rObject);
            return valueFormatter.getString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getDetailString() {
        LazyRStore.Fragment<RLanguage> fragment;
        RLanguageValue rLanguageValue = this;
        synchronized (rLanguageValue) {
            fragment = this.getDetailObjectFragment();
            if (fragment == null || fragment.getRObject() == null) {
                return "<error>";
            }
        }
        RLanguage rObject = (RLanguage)fragment.getRObject();
        if (rObject.getSource() != null) {
            return rObject.getSource();
        }
        return "";
    }

    void setDataObject(RLanguage rObject) {
        this.ensureDetailObjectStore().setFragment(0L, 0L, (Object)rObject);
    }

    private LazyRStore<RLanguage> ensureDetailObjectStore() {
        if (this.detailObjectStore == null) {
            this.detailObjectStore = new LazyRStore(1L, 1L, 1, (LazyRStore.Updater)new RElementVariableValue.RDataLoader<RLanguage>((RElementVariableValue)this){

                @Override
                protected RLanguage doLoad(FQRObjectRef ref, LazyRStore.Fragment<RLanguage> fragment, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
                    return ADAPTER.loadObject(ref, (RObject)RLanguageValue.this.getRObject(), fragment, (RService)r, m);
                }
            });
        }
        return this.detailObjectStore;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<RLanguage> getDetailObjectFragment() {
        return this.ensureDetailObjectStore().getFragment(0L, 0L, 0, null);
    }
}

