/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.labeled;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.data.IDataProvider;
import org.eclipse.statet.ecommons.waltable.grid.layer.CornerLayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.LayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;

public class LabelCornerLayer
extends CornerLayer {
    private final IDataProvider columnHeaderLabelProvider;
    private final IDataProvider rowHeaderLabelProvider;

    public LabelCornerLayer(ILayer baseLayer, ILayer horizontalLayerDependency, ILayer verticalLayerDependency, IDataProvider columnHeaderLabelProvider, IDataProvider rowHeaderLabelProvider, boolean useDefaultConfiguration, ILayerPainter layerPainter) {
        super(baseLayer, horizontalLayerDependency, verticalLayerDependency, useDefaultConfiguration, layerPainter);
        this.columnHeaderLabelProvider = columnHeaderLabelProvider;
        this.rowHeaderLabelProvider = rowHeaderLabelProvider;
    }

    @Override
    public ILayerCell getCellByPosition(long columnPosition, long rowPosition) {
        ILayerDim hDim = this.getDim(Orientation.HORIZONTAL);
        ILayerDim vDim = this.getDim(Orientation.VERTICAL);
        long columnId = hDim.getPositionId(columnPosition, columnPosition);
        long rowId = vDim.getPositionId(rowPosition, rowPosition);
        long columnCount = this.getColumnCount();
        long rowCount = this.getRowCount();
        if (rowPosition < rowCount - 1L) {
            return new LayerCell(this, new LayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition, 0L, columnCount), new LayerCellDim(Orientation.VERTICAL, rowId, rowPosition)){

                @Override
                public LabelStack getConfigLabels() {
                    return new LabelStack("COLUMN_HEADER_LABEL");
                }

                @Override
                public Object getDataValue(int flags, IProgressMonitor monitor) {
                    return LabelCornerLayer.this.columnHeaderLabelProvider != null ? LabelCornerLayer.this.columnHeaderLabelProvider.getDataValue(0L, this.getRowPosition(), flags, monitor) : "";
                }
            };
        }
        if (columnPosition < columnCount - 1L) {
            return new LayerCell(this, new LayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition), new LayerCellDim(Orientation.VERTICAL, rowId, rowPosition)){

                @Override
                public LabelStack getConfigLabels() {
                    return new LabelStack("ROW_HEADER_LABEL");
                }

                @Override
                public Object getDataValue(int flags, IProgressMonitor monitor) {
                    return LabelCornerLayer.this.rowHeaderLabelProvider != null ? LabelCornerLayer.this.rowHeaderLabelProvider.getDataValue(this.getColumnPosition(), 0L, flags, monitor) : "";
                }
            };
        }
        return new LayerCell(this, new LayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition), new LayerCellDim(Orientation.VERTICAL, rowId, rowPosition)){

            @Override
            public LabelStack getConfigLabels() {
                return new LabelStack("HEADER_PLACEHOLDER");
            }
        };
    }
}

