/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IMenuService;

public class MenuUtils {
    public static void setPullDownPosition(Menu menu, Control control) {
        Point p = control.getLocation();
        p.y += control.getSize().y;
        p = control.getParent().toDisplay(p);
        menu.setLocation(p);
    }

    public static void setPullDownPosition(Menu menu, ToolItem item) {
        Rectangle bounds = item.getBounds();
        Point p = item.getParent().toDisplay(bounds.x, bounds.y + bounds.height);
        menu.setLocation(p);
    }

    public static void registerOneWayMenu(final MenuManager menuManager, final String id) {
        final IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        final Menu menu = menuManager.getMenu();
        menuManager.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToShow(IMenuManager manager) {
                menuService.populateContributionManager((ContributionManager)menuManager, "menu:" + id);
            }

            public void menuAboutToHide(IMenuManager manager) {
                menu.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        menuService.releaseContributions((ContributionManager)menuManager);
                        menuManager.dispose();
                    }
                });
            }
        });
    }

    private MenuUtils() {
    }
}

