/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.jface;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.statet.ecommons.databinding.jface.AbstractSWTObservableValue;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IObjValueWidget;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.swt.widgets.Widget;

public class ObjValueObservable<T>
extends AbstractSWTObservableValue
implements IObjValueListener<T> {
    private final IObjValueWidget<T> fWidget;
    private final int fValueIdx;

    public ObjValueObservable(Realm realm, IObjValueWidget<T> widget) {
        this(realm, widget, 0);
    }

    public ObjValueObservable(Realm realm, IObjValueWidget<T> widget, int idx) {
        super(realm, (Widget)widget.getControl());
        this.fWidget = widget;
        this.fValueIdx = idx;
        this.fWidget.addValueListener(this);
    }

    public Object getValueType() {
        return this.fWidget.getValueType();
    }

    protected void doSetValue(Object value) {
        this.fWidget.setValue(this.fValueIdx, value);
    }

    protected Object doGetValue() {
        return this.fWidget.getValue(this.fValueIdx);
    }

    @Override
    public void valueAboutToChange(ObjValueEvent<T> event) {
    }

    @Override
    public void valueChanged(ObjValueEvent<T> event) {
        if (event.valueIdx != this.fValueIdx) {
            return;
        }
        ValueDiff diff = Diffs.createValueDiff(event.oldValue, event.newValue);
        this.fireValueChange(diff);
    }
}

