/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class AssistInvocationContext
implements IQuickAssistInvocationContext,
TextRegion {
    private final ISourceEditor editor;
    private final SourceViewer sourceViewer;
    private final int invocationOffset;
    private final int selectionOffset;
    private final int selectionLength;
    private final String invocationContentType;
    private @Nullable String invocationPrefix;
    private final @Nullable SourceUnit sourceUnit;
    private @Nullable AstInfo astInfo;
    private @Nullable SourceUnitModelInfo modelInfo;
    private @Nullable AstSelection invocationAstSelection;
    private @Nullable AstSelection astSelection;
    int session;

    public AssistInvocationContext(ISourceEditor editor, int offset, String contentType, int synch, IProgressMonitor monitor) {
        this.editor = editor;
        this.sourceViewer = editor.getViewer();
        this.invocationOffset = offset;
        Point selectedRange = this.sourceViewer.getSelectedRange();
        this.selectionOffset = selectedRange.x;
        this.selectionLength = selectedRange.y;
        this.invocationContentType = contentType;
        this.sourceUnit = editor.getSourceUnit();
        this.init(synch, monitor);
    }

    public AssistInvocationContext(ISourceEditor editor, IRegion region, String contentType, int synch, IProgressMonitor monitor) {
        if (region.getOffset() < 0 || region.getLength() < 0) {
            throw new IllegalArgumentException("region");
        }
        this.editor = editor;
        this.sourceViewer = editor.getViewer();
        this.invocationOffset = region.getOffset();
        this.selectionOffset = region.getOffset();
        this.selectionLength = region.getLength();
        this.invocationContentType = contentType;
        this.sourceUnit = editor.getSourceUnit();
        this.init(synch, monitor);
    }

    public AssistInvocationContext(ISourceEditor editor, TextRegion region, String contentType, int synch, IProgressMonitor monitor) {
        if (region.getStartOffset() < 0 || region.getLength() < 0) {
            throw new IllegalArgumentException("region");
        }
        this.editor = editor;
        this.sourceViewer = editor.getViewer();
        this.invocationOffset = region.getStartOffset();
        this.selectionOffset = region.getStartOffset();
        this.selectionLength = region.getLength();
        this.invocationContentType = contentType;
        this.sourceUnit = editor.getSourceUnit();
        this.init(synch, monitor);
    }

    private void init(int synch, IProgressMonitor monitor) {
        if (this.sourceUnit != null) {
            String type = this.getModelTypeId();
            this.modelInfo = this.sourceUnit.getModelInfo(type, synch, monitor);
            this.astInfo = this.modelInfo != null ? this.modelInfo.getAst() : this.sourceUnit.getAstInfo(type, true, monitor);
        }
    }

    boolean isInitialState() {
        Point selectedRange = this.sourceViewer.getSelectedRange();
        return selectedRange.x == this.getOffset() && selectedRange.y == this.getLength();
    }

    protected boolean reuse(ISourceEditor editor, int offset) {
        return this.editor == editor && this.invocationOffset == offset && this.isInitialState();
    }

    protected @Nullable String getModelTypeId() {
        return null;
    }

    public ISourceEditor getEditor() {
        return this.editor;
    }

    public SourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public IDocument getDocument() {
        return this.getSourceViewer().getDocument();
    }

    public final int getInvocationOffset() {
        return this.invocationOffset;
    }

    public int getStartOffset() {
        return this.selectionOffset;
    }

    public int getOffset() {
        return this.selectionOffset;
    }

    public int getEndOffset() {
        return this.selectionOffset + this.selectionLength;
    }

    public int getLength() {
        return this.selectionLength;
    }

    public final String getInvocationContentType() {
        return this.invocationContentType;
    }

    public String getIdentifierPrefix() {
        String prefix = this.invocationPrefix;
        if (prefix == null) {
            try {
                try {
                    prefix = this.computeIdentifierPrefix(this.getInvocationOffset());
                    if (prefix == null) {
                        prefix = "";
                    }
                }
                catch (BadLocationException | BadPartitioningException e) {
                    prefix = "";
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.invocationPrefix = prefix;
            }
        }
        return prefix;
    }

    public int getIdentifierOffset() {
        return this.getInvocationOffset() - this.getIdentifierPrefix().length();
    }

    protected @Nullable String computeIdentifierPrefix(int offset) throws BadPartitioningException, BadLocationException {
        IDocument document = this.getDocument();
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.getEditor().getDocumentContentInfo().getPartitioning(), (int)offset, (boolean)true);
        int bound = partition.getOffset();
        int prefixOffset = offset;
        while (prefixOffset > bound) {
            if (Character.isWhitespace(document.getChar(prefixOffset - 1))) break;
            --prefixOffset;
        }
        return document.get(prefixOffset, offset - prefixOffset);
    }

    public @Nullable SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public @Nullable AstInfo getAstInfo() {
        return this.astInfo;
    }

    public @Nullable SourceUnitModelInfo getModelInfo() {
        return this.modelInfo;
    }

    public AstSelection getInvocationAstSelection() {
        AstSelection selection = this.invocationAstSelection;
        if (selection == null) {
            if (this.astInfo == null || this.astInfo.getRoot() == null) {
                throw new UnsupportedOperationException("AST is missing.");
            }
            this.invocationAstSelection = selection = AstSelection.search((AstNode)this.astInfo.getRoot(), (int)this.getInvocationOffset(), (int)this.getInvocationOffset(), (int)3);
        }
        return selection;
    }

    public AstSelection getAstSelection() {
        AstSelection selection = this.astSelection;
        if (selection == null) {
            if (this.astInfo == null || this.astInfo.getRoot() == null) {
                throw new UnsupportedOperationException("AST is missing.");
            }
            this.astSelection = selection = AstSelection.search((AstNode)this.astInfo.getRoot(), (int)this.getOffset(), (int)(this.getOffset() + this.getLength()), (int)3);
        }
        return selection;
    }
}

