/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.statet.internal.rhelp.core.REnvHelpImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpWebapp;
import org.eclipse.statet.internal.rhelp.core.index.RHelpHtmlUtils;
import org.eclipse.statet.internal.rhelp.core.server.ServerClientSupport;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.DocResource;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpCore;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpTopicEntry;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rhelp.core.http.CustomMediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.HttpForwardHandler;
import org.eclipse.statet.rhelp.core.http.MediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.ResourceHandler;
import org.eclipse.statet.rhelp.core.http.ServletMediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.SimpleResourceHandler;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RPkgDescription;

@NonNullByDefault
public abstract class RHelpHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String PACKAGE_INDEX_PAGE_NAME = "00Index";
    private static final String ATTR_RENV_ID = "rhelp.renv.id";
    private static final String ATTR_RENV_RESOLVED = "rhelp.renv.resolved";
    private static final String ATTR_RENV_HELP = "rhelp.renv.help";
    private static final String ATTR_RENV_CONFIG = "rhelp.renv.config";
    private static final MediaTypeProvider DOC_MEDIA_TYPES;
    private RHelpManager rHelpManager;
    private ResourceHandler fileResourceHandler;
    private @Nullable HttpForwardHandler serverForwardHandler;
    private final Map<String, byte[]> images = new HashMap<String, byte[]>();

    static {
        CustomMediaTypeProvider docMediaTypes = new CustomMediaTypeProvider();
        docMediaTypes.addName("README", "text/plain;charset=iso-8859-1");
        docMediaTypes.addName("COPYING", "text/plain;charset=iso-8859-1");
        docMediaTypes.addName("LICENSE", "text/plain;charset=iso-8859-1");
        docMediaTypes.addName("AUTHORS", "text/plain;charset=iso-8859-1");
        docMediaTypes.addName("THANKS", "text/plain;charset=iso-8859-1");
        docMediaTypes.addName("DESCRIPTION", "text/plain");
        docMediaTypes.addExt("Rnw", "text/plain");
        DOC_MEDIA_TYPES = docMediaTypes;
    }

    private static String getREnvId(HttpServletRequest req) {
        return (String)req.getAttribute(ATTR_RENV_ID);
    }

    private static REnv getREnv(HttpServletRequest req) {
        return (REnv)req.getAttribute(ATTR_RENV_RESOLVED);
    }

    private static REnvHelpImpl getREnvHelp(HttpServletRequest req) {
        return (REnvHelpImpl)req.getAttribute(ATTR_RENV_HELP);
    }

    private static REnvHelpConfiguration getREnvConfig(HttpServletRequest req) {
        return (REnvHelpConfiguration)req.getAttribute(ATTR_RENV_CONFIG);
    }

    private static void printSaveHtml(Writer writer, String s) throws IOException {
        int length = s.length();
        int next = 0;
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    if (i > next) {
                        writer.write(s, next, i - next);
                    }
                    writer.write("&quot;");
                    next = ++i;
                    break;
                }
                case '&': {
                    if (i > next) {
                        writer.write(s, next, i - next);
                    }
                    writer.write("&amp;");
                    next = ++i;
                    break;
                }
                case '\'': {
                    if (i > next) {
                        writer.write(s, next, i - next);
                    }
                    writer.write("&#39;");
                    next = ++i;
                    break;
                }
                case '<': {
                    if (i > next) {
                        writer.write(s, next, i - next);
                    }
                    writer.write("&lt;");
                    next = ++i;
                    break;
                }
                case '>': {
                    if (i > next) {
                        writer.write(s, next, i - next);
                    }
                    writer.write("&gt;");
                    next = ++i;
                    break;
                }
                default: {
                    ++i;
                }
            }
        }
        if (length > next) {
            writer.write(s, next, length - next);
        }
    }

    protected void init(RHelpManager rHelpManager, @Nullable ResourceHandler fileResourceHandler, @Nullable HttpForwardHandler serverForwardHandler) {
        this.rHelpManager = rHelpManager;
        this.fileResourceHandler = fileResourceHandler != null ? fileResourceHandler : new SimpleResourceHandler(new ServletMediaTypeProvider(this.getServletContext()));
        this.fileResourceHandler.setSpecialMediaTypes(DOC_MEDIA_TYPES);
        this.fileResourceHandler.setCacheControl("max-age=600, must-revalidate");
        this.serverForwardHandler = serverForwardHandler;
        this.loadImages();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
        super.destroy();
    }

    private void loadImages() {
        ImList names = ImCollections.newList((Object[])new String[]{"rpackage.png", "rhelp-page.png", "rhelp-page-internal.png", "rhelp-topic.png", "rhelp-topic-internal.png"});
        try {
            List bundles = CommonsRuntime.getEnvironment().resolveBundles((List)ImCollections.newList((Object)new BundleSpec("org.eclipse.statet.rhelp.core", RHelpCore.class)));
            block2: for (String name : names) {
                String resourcePathString = "images/" + name;
                for (BundleEntry bundle : bundles) {
                    Path resourcePath = bundle.getResourcePath(resourcePathString);
                    if (resourcePath == null || !Files.isReadable(resourcePath)) continue;
                    byte[] bytes = Files.readAllBytes(resourcePath);
                    this.images.put(name, bytes);
                    continue block2;
                }
                throw new IOException(String.format("File note found '%1$s'.", resourcePathString));
            }
        }
        catch (Exception e) {
            this.log("An error occurred when loading images.", e);
            this.images.clear();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        try {
            if (path != null) {
                if (path.startsWith("/images/")) {
                    this.processImage(path.substring("images".length() + 2), req, resp);
                    return;
                }
                if (path.endsWith("/R.css")) {
                    this.processCss(req, resp);
                    return;
                }
                RHelpWebapp.RequestInfo info = RHelpWebapp.extractRequestInfo(path);
                if (info != null) {
                    if (!this.checkREnv(info.rEnvId, req, resp)) {
                        return;
                    }
                    if (info.cat == null) {
                        this.printEnvIndex(req, resp);
                        return;
                    }
                    if (info.cat == "library") {
                        switch (info.cmd) {
                            case 1: {
                                this.processPkgIndex(info.pkgName, req, resp);
                                return;
                            }
                            case 2: {
                                this.processHelpPage(info.pkgName, info.detail, req, resp);
                                return;
                            }
                            case 3: {
                                this.processPkgRes(info.pkgName, "help", info.detail, req, resp);
                                return;
                            }
                            case 4: {
                                this.processTopic(info.pkgName, info.detail, req, resp);
                                return;
                            }
                            case 5: {
                                this.processPkgRes(info.pkgName, "doc", "index.html", req, resp);
                                return;
                            }
                            case 6: {
                                this.processPkgRes(info.pkgName, "doc", info.detail, req, resp);
                                return;
                            }
                            case 7: {
                                this.processPkgRes(info.pkgName, null, "DESCRIPTION", req, resp);
                                return;
                            }
                        }
                    } else if (info.cat == "doc") {
                        this.processEnvDoc(info.detail, req, resp);
                        return;
                    }
                }
            }
            resp.sendError(400);
            return;
        }
        catch (StatusException e) {
            int httpStatus;
            Status status = e.getStatus();
            switch (status.getCode()) {
                case 1001: 
                case 1002: {
                    httpStatus = 504;
                    break;
                }
                default: {
                    httpStatus = 500;
                }
            }
            resp.sendError(httpStatus, status.getMessage());
            return;
        }
        finally {
            REnvHelp help = (REnvHelp)req.getAttribute(ATTR_RENV_HELP);
            if (help != null) {
                help.unlock();
            }
        }
    }

    protected StringBuilder getServletPath(HttpServletRequest req) {
        return new StringBuilder().append(req.getContextPath()).append(req.getServletPath());
    }

    protected void sendPathRedirect(String path, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.resetBuffer();
        resp.setStatus(302);
        resp.setHeader("Location", path);
    }

    private boolean checkREnv(String id, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        REnvHelpConfiguration config;
        REnv rEnv = this.rHelpManager.getREnv(id);
        if (rEnv != null) {
            rEnv = rEnv.resolve();
        }
        if (rEnv != null && (config = (REnvHelpConfiguration)rEnv.get(REnvHelpConfiguration.class)) != null) {
            req.setAttribute(ATTR_RENV_ID, (Object)id);
            req.setAttribute(ATTR_RENV_RESOLVED, (Object)rEnv);
            REnvHelp help = this.rHelpManager.getHelp(rEnv);
            if (help != null) {
                req.setAttribute(ATTR_RENV_HELP, (Object)help);
                req.setAttribute(ATTR_RENV_CONFIG, (Object)config);
                return true;
            }
            resp.sendError(404, "The R library of the requested R environment <code>" + rEnv.getName() + "</code> " + "is not yet indexed. Please run the indexer first to enable R help support.");
            return false;
        }
        String message = id.startsWith("default-") ? "The requested default R environment is missing. Please configure an environment as default." : "The requested R environment doesn't exist. Please change the environment.";
        resp.sendError(404, message);
        return false;
    }

    private void processHelpPage(String pkgName, String detail, HttpServletRequest req, HttpServletResponse resp) throws IOException, StatusException {
        if (detail != null && detail.equalsIgnoreCase(PACKAGE_INDEX_PAGE_NAME)) {
            this.sendPathRedirect(this.getServletPath(req).append('/').append(RHelpHttpServlet.getREnvId(req)).append("/library/").append(pkgName).append('/').toString(), req, resp);
            return;
        }
        REnvHelpImpl help = RHelpHttpServlet.getREnvHelp(req);
        RPkgHelp pkgHelp = help.getPkgHelp(pkgName);
        if (pkgHelp != null) {
            String qs = req.getParameter("qs");
            String html = help.getHtmlPage(pkgHelp, detail, qs);
            if (html != null) {
                if (qs != null) {
                    html = RHelpHtmlUtils.formatHtmlMatches(html);
                }
                this.printHtmlPage(html, req, resp);
                return;
            }
            RHelpPage page = pkgHelp.getPageForTopic(detail);
            if (page != null) {
                this.redirect(page, req, resp);
                return;
            }
        }
        resp.sendError(404, "Help page <code>" + detail + "</code> {<code>" + pkgName + "</code>} not found.");
    }

    private void processPkgRes(String pkgName, @Nullable String resSub, String path, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        Path libDirectory;
        block14: {
            REnvHelpConfiguration rEnvConfig;
            block13: {
                REnvHelpImpl help = RHelpHttpServlet.getREnvHelp(req);
                rEnvConfig = RHelpHttpServlet.getREnvConfig(req);
                libDirectory = null;
                if (!rEnvConfig.isLocal()) break block13;
                RPkgHelp pkgHelp = help.getPkgHelp(pkgName);
                if (pkgHelp != null) {
                    RPkgDescription pkgDescription = pkgHelp.getPkgDescription();
                    RLibLocation libLocation = pkgDescription.getLibLocation();
                    libDirectory = libLocation.getDirectoryPath();
                }
                break block14;
            }
            switch (rEnvConfig.getStateSharedType()) {
                case "server": {
                    this.forwardToServer(rEnvConfig, req, resp);
                    return;
                }
                default: {
                    resp.sendError(500);
                    return;
                }
                case "directory": 
            }
        }
        if (libDirectory == null) {
            resp.sendError(404);
            return;
        }
        Path directory = libDirectory.resolve(pkgName);
        if (resSub != null) {
            directory = directory.resolve(resSub);
        }
        this.serveFileResource(directory, path, null, req, resp);
    }

    private void processPkgIndex(String pkgName, HttpServletRequest req, HttpServletResponse resp) throws IOException, StatusException {
        ImList<RHelpTopicEntry> topics;
        REnvHelpImpl help = RHelpHttpServlet.getREnvHelp(req);
        RPkgHelp pkgHelp = help.getPkgHelp(pkgName);
        if (pkgHelp != null && (topics = pkgHelp.getTopics()) != null) {
            this.printPackageIndex(pkgHelp, (List<RHelpTopicEntry>)topics, req, resp);
            return;
        }
        resp.sendError(404, "Help for package <code>" + pkgName + "</code> not found.");
    }

    private void processTopic(String pkgName, String detail, HttpServletRequest req, HttpServletResponse resp) throws IOException, StatusException {
        RHelpPage page;
        REnvHelpImpl help = RHelpHttpServlet.getREnvHelp(req);
        RPkgHelp pkgHelp = help.getPkgHelp(pkgName);
        if (pkgHelp != null && (page = pkgHelp.getPageForTopic(detail)) != null) {
            this.redirect(page, req, resp);
            return;
        }
        List<RHelpPage> pages = help.getPagesForTopic(detail, null);
        if (pages.size() == 1) {
            this.redirect(pages.get(0), req, resp);
            return;
        }
        this.printTopicList(detail, pages, req, resp);
    }

    private void processCss(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PrintWriter writer = this.createCssDoc(req, resp);
        writer.println("span.acronym { font-size: small }\nspan.env { font-family: monospace }\nspan.file { font-family: monospace }\nspan.option { font-family: monospace }\nspan.pkg { font-weight: bold }\nspan.samp { font-family: monospace }");
        writer.println("body { line-height: 125%; margin: 1em; padding: 0; color: black; }");
        writer.println("table { margin: 0.4em 0 0.4em 0; border-collapse:collapse; border:0px; font-size: 100% }");
        writer.println("td { padding: 0.2em 0.8em 0.2em 0; border:0px; }");
        writer.println("h2 { font-size: 120%; font-weight: bold; margin: 0 0 0.6em 0; }");
        writer.println("h3 { font-size: 110%; font-weight: bold; letter-spacing: 0.05em; margin: 1.0em 0 0.6em 0; }");
        writer.println("p, pre { margin: 0.6em 0 0.6em 0; }");
        writer.println("td { vertical-align: top; }");
        writer.println("hr { margin-top: 0.8em; clear: both; }");
        writer.println("div.toc { display: none; font-size: 80%; line-height: 125%; padding: 0.2em 0.8em 0.4em; }");
        writer.println("div.toc ul { list-style: none; padding: 0; margin: 0 }");
        writer.println("div.toc pre { margin: 0 0 0.4em; }");
        writer.println("div.toc a { text-decoration: none; color: black; }");
        writer.println("div.toc a:visited { text-decoration: none; color: black; }");
        writer.println("a.action { text-decoration: none; }");
        writer.println("a.action small { padding-left: 1px; padding-right: 1px; }");
        writer.println("a.action:hover small { background-color: lightgrey; color: black; }");
        writer.println("img.icon { vertical-align: text-top; padding-top: 1px; padding-right: 2px; margin-right: 2px; }");
        this.customizeCss(writer);
    }

    private void processImage(String imgName, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        byte[] content = this.images.get(imgName);
        if (content != null) {
            resp.setContentType("image/png");
            resp.setHeader("Cache-Control", "max-age=600, public");
            ServletOutputStream out = resp.getOutputStream();
            out.write(content);
            out.close();
            return;
        }
        resp.sendError(404);
    }

    private void processEnvDoc(String path, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path directory;
        block13: {
            REnvHelpConfiguration rEnvConfig;
            block12: {
                REnvHelpImpl help = RHelpHttpServlet.getREnvHelp(req);
                rEnvConfig = RHelpHttpServlet.getREnvConfig(req);
                directory = null;
                if (!rEnvConfig.isLocal()) break block12;
                String docDir = help.getDocDir();
                if (docDir != null) {
                    directory = Paths.get(docDir, new String[0]);
                }
                break block13;
            }
            switch (rEnvConfig.getStateSharedType()) {
                case "server": {
                    this.forwardToServer(rEnvConfig, req, resp);
                    return;
                }
                default: {
                    resp.sendError(500);
                    return;
                }
                case "directory": 
            }
        }
        if (directory == null) {
            resp.sendError(404, "R doc directory not found.");
            return;
        }
        this.serveFileResource(directory, path, req.getParameter("action"), req, resp);
    }

    private PrintWriter createHtmlDoc(String title, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html;charset=UTF-8");
        resp.setHeader("Cache-Control", "max-age=30, must-revalidate");
        PrintWriter writer = resp.getWriter();
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        writer.println("<html><head>");
        writer.write("<title>");
        RHelpHttpServlet.printSaveHtml(writer, title);
        writer.write("</title>");
        writer.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        writer.write(this.getServletPath(req).append("/R.css").toString());
        writer.println("\"/>");
        return writer;
    }

    private void redirect(RHelpPage page, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.sendPathRedirect(this.getServletPath(req).append('/').append(RHelpHttpServlet.getREnvId(req)).append("/library/").append(page.getPackage().getName()).append("/html/").append(page.getName()).append(".html").toString(), req, resp);
    }

    private PrintWriter createCssDoc(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/css;charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        writer.println("@charset \"UTF-8\";");
        return writer;
    }

    private void printHtmlPage(String html, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html;charset=UTF-8");
        resp.setHeader("Cache-Control", "max-age=30, must-revalidate");
        PrintWriter writer = resp.getWriter();
        int idxHead = html.indexOf("</head>");
        if (idxHead > 0) {
            writer.write(html, 0, idxHead);
            this.customizePageHtmlHeader(req, writer);
            int idxEndExamples = html.lastIndexOf("<!-- END-EXAMPLES -->");
            if (idxEndExamples > 0) {
                int idxBeginExamples = html.lastIndexOf("<!-- BEGIN-EXAMPLES -->", idxEndExamples);
                writer.write(html, idxHead, idxBeginExamples - idxHead);
                this.customizeExamples(writer, html.substring(idxBeginExamples + "<!-- BEGIN-EXAMPLES -->".length(), idxEndExamples));
                writer.write(html, idxEndExamples += "<!-- END-EXAMPLES -->".length(), html.length() - idxEndExamples);
            } else {
                writer.write(html, idxHead, html.length() - idxHead);
            }
        } else {
            writer.write(html);
        }
    }

    private void printTopicList(String topic, List<RHelpPage> pages, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PrintWriter writer = this.createHtmlDoc(String.format("Help on topic '%1$s'", topic), req, resp);
        String codeTopic = "<code>" + topic + "</code>";
        this.customizeIndexHtmlHeader(req, writer);
        writer.println("</head><body>");
        writer.write("<h2>");
        writer.write(String.format("Help on topic %1$s", codeTopic));
        writer.write("</h2>");
        String basePath = "../../";
        String baseImagesPath = "../../../images/";
        if (pages != null && !pages.isEmpty()) {
            writer.write("<p>");
            writer.write(String.format("Help on topic %1$s was found in the following pages:", codeTopic));
            writer.println("</p>");
            Collections.sort(pages);
            writer.write("<table>");
            for (RHelpPage page : pages) {
                writer.write("<tr><td style=\"white-space: nowrap;\">");
                this.printIcon(writer, "../../../images/", page.isInternal() ? "rhelp-topic-internal.png" : "rhelp-topic.png");
                writer.write("<a href=\"");
                writer.write("../../");
                writer.write(page.getPackage().getName());
                writer.write("/html/");
                writer.write(page.getName());
                writer.write(".html\"><code>");
                writer.write(page.getName());
                writer.write("</code></a> {");
                writer.write("<a href=\"");
                writer.write("../../");
                writer.write(page.getPackage().getName());
                writer.write("/\" title=\"");
                writer.write(page.getPackage().getName());
                writer.write(" [");
                writer.write(page.getPackage().getVersion().toString());
                writer.write("]\n");
                RHelpHttpServlet.printSaveHtml(writer, page.getPackage().getTitle());
                writer.write("\"><code>");
                writer.write(page.getPackage().getName());
                writer.write("</code></a>}</td>");
                writer.write("<td>");
                RHelpHttpServlet.printSaveHtml(writer, page.getTitle());
                writer.write("</td></tr>");
            }
            writer.write("</table>");
        } else {
            writer.write(String.format("No help found on topic %1$s in any package in the R library.", codeTopic));
        }
        writer.println("</body></html>");
    }

    private void printPackageIndex(RPkgHelp pkgHelp, List<RHelpTopicEntry> packageTopics, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String description;
        RPkgDescription pkgDescription = pkgHelp.getPkgDescription();
        ImList vignettes = ImCollections.emptyList();
        boolean showInternal = this.getShowInternal();
        PrintWriter writer = this.createHtmlDoc(String.format("Package '%1$s' - %2$s", pkgHelp.getName(), pkgHelp.getTitle()), req, resp);
        this.customizeIndexHtmlHeader(req, writer);
        writer.println("</head><body>");
        writer.write("<table class=\"header\"><tr><td>");
        writer.write(pkgHelp.getName());
        writer.write(" [");
        writer.write(pkgHelp.getVersion().toString());
        writer.write("]");
        writer.println("</td></tr></table>");
        writer.println("<div class=\"toc\"><ul>");
        writer.write("<li><a href=\"#topics\">Help Topics</a><pre>");
        char i = 'A';
        int j = 0;
        while (i <= 'Z') {
            block15: {
                if ((i - 65) % 7 == 0) {
                    writer.println();
                }
                writer.print(' ');
                while (j < packageTopics.size()) {
                    char c;
                    RHelpTopicEntry topic = packageTopics.get(j);
                    if (topic.getTopic().length() > 0 && (c = Character.toUpperCase(topic.getTopic().charAt(0))) >= 'A' && c <= 'Z') {
                        if (c > i) break;
                        if (c == i && (showInternal || !topic.getPage().isInternal())) {
                            writer.write("<a href=\"#idx");
                            writer.print((char)(32 + c));
                            writer.write("\" class=\"mnemonic\">");
                            writer.print(c);
                            writer.write("</a>");
                            break block15;
                        }
                    }
                    ++j;
                }
                writer.print(i);
            }
            ++i;
        }
        writer.println("</pre></li>");
        if (!vignettes.isEmpty()) {
            writer.println("<li><a href=\"#vignettes\">Other Documentation</a></li>");
        }
        writer.println("<li><a href=\"#about\">About</a></li>");
        writer.println("</ul></div>");
        writer.write("<h2>");
        RHelpHttpServlet.printSaveHtml(writer, pkgHelp.getTitle());
        writer.write("</h2>");
        if (pkgDescription != null && (description = pkgDescription.getDescription()).length() > 0) {
            writer.write("<h3 id=\"description\">Description</h3>");
            writer.write("<p>");
            RHelpHttpServlet.printSaveHtml(writer, description);
            if (description.charAt(description.length() - 1) != '.') {
                writer.print('.');
            }
            writer.write("</p>");
        }
        writer.write("<h3 id=\"topics\">Help Topics</h3>");
        writer.write("<table>");
        String baseTopicsPath = "html/";
        String baseImagesPath = "../../../images/";
        char lastChar = '\u0000';
        for (RHelpTopicEntry topic : packageTopics) {
            char c;
            RHelpPage page = topic.getPage();
            if (!showInternal && page.isInternal()) continue;
            String alias = topic.getTopic();
            writer.write("<tr><td style=\"white-space: nowrap;\">");
            writer.write("<a href=\"");
            writer.write("html/");
            writer.write(page.getName());
            writer.write(".html");
            writer.write(34);
            if (alias.length() > 0 && (c = Character.toUpperCase(alias.charAt(0))) >= 'A' && c <= 'Z' && c > lastChar) {
                lastChar = c;
                writer.write(" id=\"idx");
                writer.print((char)(32 + c));
                writer.print('\"');
            }
            writer.write(" title=\"");
            writer.write(page.getName());
            writer.write(" {");
            writer.write(pkgHelp.getName());
            writer.write("}\n");
            RHelpHttpServlet.printSaveHtml(writer, page.getTitle());
            writer.write("\">");
            this.printIcon(writer, "../../../images/", page.isInternal() ? "rhelp-topic-internal.png" : "rhelp-topic.png");
            writer.write("<code>");
            writer.write(alias);
            writer.write("</code></a>");
            writer.write("</td><td>");
            RHelpHttpServlet.printSaveHtml(writer, page.getTitle());
            writer.write("</td></tr>");
        }
        writer.write("</table>");
        if (!vignettes.isEmpty()) {
            writer.write("<h3 id=\"vignettes\">Vignettes and Other Documentation</h3>");
        }
        writer.write("<h3 id=\"about\">About</h3>");
        if (pkgDescription != null) {
            writer.write("<table>");
            if (pkgDescription.getAuthor() != null && pkgDescription.getAuthor().length() > 0) {
                writer.write("<tr><td>Author(s):</td>");
                writer.write("<td>");
                RHelpHttpServlet.printSaveHtml(writer, pkgDescription.getAuthor());
                writer.write("</td>");
            }
            if (pkgDescription.getMaintainer() != null && pkgDescription.getMaintainer().length() > 0) {
                writer.write("<tr><td>Maintainer:</td>");
                writer.write("<td>");
                RHelpHttpServlet.printSaveHtml(writer, pkgDescription.getMaintainer());
                writer.write("</td>");
            }
            if (pkgDescription.getUrl() != null && pkgDescription.getUrl().length() > 0) {
                writer.write("<tr><td>URL:</td>");
                writer.write("<td><a href=\"");
                RHelpHttpServlet.printSaveHtml(writer, pkgDescription.getUrl());
                writer.write("\"><code>");
                RHelpHttpServlet.printSaveHtml(writer, pkgDescription.getUrl());
                writer.write("</code></a></td>");
            }
            writer.write("</table>");
        }
        writer.write("<p><a href=\"description\">DESCRIPTION file</a></p>");
        writer.println("</body></html>");
    }

    private void printEnvIndex(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        REnvHelpImpl help = RHelpHttpServlet.getREnvHelp(req);
        REnvHelpConfiguration rEnvConfig = RHelpHttpServlet.getREnvConfig(req);
        REnv rEnv = help.getREnv();
        ImList<RPkgHelp> packages = help.getPkgs();
        PrintWriter writer = this.createHtmlDoc(String.format("R Environment '%1$s'", rEnv.getName()), req, resp);
        String basePath = this.getServletPath(req).append('/').append(rEnv.getId()).toString();
        String baseLibPath = String.valueOf(basePath) + '/' + "library" + '/';
        String baseDocPath = String.valueOf(basePath) + '/' + "doc" + '/';
        String baseImagesPath = String.valueOf(basePath) + "../../" + "images" + '/';
        this.customizeIndexHtmlHeader(req, writer);
        writer.println("</head><body>");
        writer.println("<div class=\"toc\"><ul>");
        writer.write("<li><a href=\"#manuals\">Manuals</a></li>");
        writer.write("<li><a href=\"#packages\">Packages</a><pre>");
        char i = 'A';
        int j = 0;
        while (i <= 'Z') {
            block11: {
                String name;
                if ((i - 65) % 7 == 0) {
                    writer.println();
                }
                writer.print(' ');
                while (j < packages.size() && (name = ((RPkgHelp)packages.get(j)).getName()) != null && name.length() > 0) {
                    char c = Character.toUpperCase(name.charAt(0));
                    if (c >= 'A' && c <= 'Z') {
                        if (c > i) break;
                        if (c == i) {
                            writer.write("<a href=\"#idx");
                            writer.print((char)(32 + c));
                            writer.write("\" class=\"mnemonic\">");
                            writer.print(c);
                            writer.write("</a>");
                            break block11;
                        }
                    }
                    ++j;
                }
                writer.print(i);
            }
            ++i;
        }
        writer.println("</pre></li>");
        if (!help.getMiscResources().isEmpty()) {
            writer.write("<li><a href=\"#misc\">Misc. Material</a></li>");
        }
        writer.println("</ul></div>");
        writer.write("<h2>");
        writer.write(rEnv.getName());
        writer.write("</h2>");
        writer.write("<h3 id=\"manuals\">Manuals</h3>");
        if (!help.getManuals().isEmpty()) {
            this.printDocTable(writer, (List<DocResource>)help.getManuals(), baseDocPath, rEnvConfig.isLocal());
        } else {
            writer.write("<p>No manuals available for this R installation.</p>");
        }
        writer.write("<h3 id=\"packages\">Packages</h3>");
        writer.write("<table>");
        char lastChar = '\u0000';
        for (RPkgHelp pkgHelp : packages) {
            char c;
            String name = pkgHelp.getName();
            writer.write("<tr><td style=\"white-space: nowrap;\">");
            writer.write("<a href=\"");
            writer.write(baseLibPath);
            writer.write(name);
            writer.write("/\" title=\"");
            writer.write(name);
            writer.write(" [");
            RHelpHttpServlet.printSaveHtml(writer, pkgHelp.getVersion().toString());
            writer.print(']');
            writer.print('\"');
            if (name.length() > 0 && (c = Character.toUpperCase(name.charAt(0))) >= 'A' && c <= 'Z' && c > lastChar) {
                lastChar = c;
                writer.write(" id=\"idx");
                writer.print((char)(32 + c));
                writer.print('\"');
            }
            writer.write(">");
            this.printIcon(writer, baseImagesPath, "rpackage.png");
            writer.write("<code>");
            writer.write(pkgHelp.getName());
            writer.write("</code></a>");
            writer.write("</td><td>");
            RHelpHttpServlet.printSaveHtml(writer, pkgHelp.getTitle());
            writer.write("</td></tr>");
        }
        writer.write("</table>");
        if (!help.getMiscResources().isEmpty()) {
            writer.write("<h3 id=\"misc\">Miscellaneous Material</h3>");
            this.printDocTable(writer, (List<DocResource>)help.getMiscResources(), baseDocPath, rEnvConfig.isLocal());
        }
        writer.write("<hr/>");
        writer.println("</body></html>");
    }

    private void printDocTable(PrintWriter writer, List<DocResource> docs, String baseUrl, boolean local) {
        writer.write("<table>");
        for (DocResource doc : docs) {
            writer.write("<tr><td>");
            writer.write("<a href=\"");
            writer.write(baseUrl);
            writer.write(doc.getPath());
            writer.write("\">");
            writer.write(doc.getTitle());
            writer.write("</a>");
            if (doc.getPdfPath() != null) {
                writer.write("&emsp;[&#8239;<a");
                writer.write(" href=\"");
                writer.write(baseUrl);
                writer.write(doc.getPdfPath());
                writer.write("\">PDF</a>");
                if (local && this.canOpenFile("pdf")) {
                    writer.write("&#8239;<a class=\"action\"");
                    writer.write(" href=\"");
                    writer.write(baseUrl);
                    writer.write(doc.getPdfPath());
                    writer.write("?action=open");
                    writer.write("\" title=\"Open PDF with Eclipse\"><small>(open)</small></a>");
                }
                writer.write("&#8239;]");
            }
            writer.write("</td></tr>");
        }
        writer.write("</table>");
    }

    private void printIcon(PrintWriter writer, String imageBasePath, String imageName) {
        if (this.images.isEmpty()) {
            return;
        }
        writer.write("<img class=\"icon\" src=\"");
        writer.write(imageBasePath);
        writer.write(imageName);
        writer.write("\"/>");
    }

    private void customizeExamples(PrintWriter writer, String html) {
        int idx = 0;
        while (idx < html.length()) {
            int end;
            int begin = html.indexOf("<pre", idx);
            if (begin < 0 || (begin = html.indexOf(62, begin + 4)) < 0 || (end = html.indexOf("</pre", ++begin)) < 0) break;
            writer.write(html, idx, begin - idx);
            this.printRCode(writer, html.substring(begin, end));
            idx = end;
        }
        writer.write(html, idx, html.length() - idx);
    }

    protected boolean getShowInternal() {
        return true;
    }

    protected void customizeCss(PrintWriter writer) {
    }

    protected void customizePageHtmlHeader(HttpServletRequest req, PrintWriter writer) {
    }

    protected void customizeIndexHtmlHeader(HttpServletRequest req, PrintWriter writer) {
    }

    protected void printRCode(PrintWriter writer, String html) {
        writer.write(html);
    }

    private @Nullable Path checkPath(Path directory, String path) {
        try {
            Path file = directory.resolve(path).toRealPath(LinkOption.NOFOLLOW_LINKS);
            if (file.getNameCount() >= directory.getNameCount() && file.startsWith(directory)) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void serveFileResource(Path directory, String path, @Nullable String action, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path file = this.checkPath(directory, path);
        if (file == null) {
            resp.sendError(400);
            return;
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            resp.sendError(404, path);
            return;
        }
        if (action != null && action.equals("open")) {
            this.doOpenFile(file);
            resp.setStatus(204);
            return;
        }
        this.fileResourceHandler.doGet(file, req, resp);
    }

    private void forwardToServer(REnvHelpConfiguration rEnvConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.serverForwardHandler == null) {
            resp.sendError(503);
            return;
        }
        try {
            ServerClientSupport serverSupport = ServerClientSupport.getInstance();
            String localId = RHelpHttpServlet.getREnvId(req);
            URI serverUrl = serverSupport.toServerBrowseUrl(rEnvConfig, req.getPathInfo().substring(localId.length() + 1));
            this.serverForwardHandler.forward(serverUrl, req, resp);
        }
        catch (URISyntaxException | StatusException e) {
            throw new ServletException(e);
        }
    }

    protected boolean canOpenFile(String ext) {
        return false;
    }

    protected void doOpenFile(Path file) {
    }
}

