/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.yaml.core.model.SourceAnalyzer;
import org.eclipse.statet.internal.yaml.core.model.YamlModelManagerImpl;
import org.eclipse.statet.internal.yaml.core.model.YamlSourceUnitModelInfoImpl;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.core.SourceModelStamp;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.impl.BasicSourceModelStamp;
import org.eclipse.statet.yaml.core.ast.SourceComponent;
import org.eclipse.statet.yaml.core.ast.YamlParser;
import org.eclipse.statet.yaml.core.model.YamlSourceUnitModelInfo;
import org.eclipse.statet.yaml.core.model.build.YamlProblemReporter;
import org.eclipse.statet.yaml.core.model.build.YamlSourceUnitModelContainer;

public class YamlReconciler {
    private final YamlModelManagerImpl yamlManager;
    protected boolean stop = false;
    private final Object f1AstLock = new Object();
    private final YamlParser f1Parser = new YamlParser();
    private final Object f2ModelLock = new Object();
    private final SourceAnalyzer f2SourceAnalyzer = new SourceAnalyzer();
    private final Object f3ReportLock = new Object();
    private final YamlProblemReporter f3ProblemReporter = new YamlProblemReporter();

    public YamlReconciler(YamlModelManagerImpl manager) {
        this.yamlManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile(YamlSourceUnitModelContainer<?> adapter, int flags, IProgressMonitor monitor) {
        SourceUnit su = adapter.getSourceUnit();
        Data data = new Data(adapter, monitor);
        if (data.content == null) {
            return;
        }
        Object object = this.f1AstLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            this.updateAst(data, flags, monitor);
        }
        if (this.stop || monitor.isCanceled() || (flags & 0xF) < 2) {
            return;
        }
        object = this.f2ModelLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            boolean updated = this.updateModel(data, flags, monitor);
            if (updated) {
                this.yamlManager.getEventJob().addUpdate((LtkModelElement)su, data.oldModel, data.newModel);
            }
        }
        if ((flags & 0x2000000) != 0 && data.newModel != null) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            ProblemRequestor problemRequestor = null;
            Object object2 = this.f3ReportLock;
            synchronized (object2) {
                if (!this.stop && !monitor.isCanceled() && data.newModel == adapter.getCurrentModel() && (problemRequestor = adapter.createProblemRequestor()) != null) {
                    this.f3ProblemReporter.run(data.newModel, data.content, problemRequestor, flags, monitor);
                }
                if (problemRequestor != null) {
                    problemRequestor.finish();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateAst(Data data, int flags, IProgressMonitor monitor) {
        BasicSourceModelStamp stamp = new BasicSourceModelStamp(data.content.getStamp());
        data.ast = data.adapter.getCurrentAst();
        if (data.ast != null && !stamp.equals((Object)data.ast.getStamp())) {
            data.ast = null;
        }
        if (data.ast == null) {
            SourceComponent sourceNode = this.f1Parser.parse(data.content.getText());
            data.ast = new AstInfo(1, (SourceModelStamp)stamp, (AstNode)sourceNode);
            YamlSourceUnitModelContainer<?> yamlSourceUnitModelContainer = data.adapter;
            synchronized (yamlSourceUnitModelContainer) {
                data.adapter.setAst(data.ast);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateModel(Data data, int flags, IProgressMonitor monitor) {
        data.newModel = (YamlSourceUnitModelInfo)data.adapter.getCurrentModel();
        if (data.newModel != null && !data.ast.getStamp().equals(data.newModel.getStamp())) {
            data.newModel = null;
        }
        if (data.newModel == null) {
            boolean isOK;
            YamlSourceUnitModelInfoImpl model = this.f2SourceAnalyzer.createModel(data.adapter.getSourceUnit(), data.content.getText(), data.ast);
            boolean bl = isOK = model != null;
            if (isOK) {
                YamlSourceUnitModelContainer<?> yamlSourceUnitModelContainer = data.adapter;
                synchronized (yamlSourceUnitModelContainer) {
                    data.oldModel = (YamlSourceUnitModelInfo)data.adapter.getCurrentModel();
                    data.adapter.setModel(model);
                }
                data.newModel = model;
                return true;
            }
        }
        return false;
    }

    void stop() {
        this.stop = true;
    }

    protected static class Data {
        public final YamlSourceUnitModelContainer<?> adapter;
        public final SourceContent content;
        public int parseOffset;
        public AstInfo ast;
        public YamlSourceUnitModelInfo oldModel;
        public YamlSourceUnitModelInfo newModel;

        public Data(YamlSourceUnitModelContainer<?> adapter, IProgressMonitor monitor) {
            this.adapter = adapter;
            this.content = adapter.getParseContent(monitor);
        }
    }
}

