/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.tex.r.ui.sourceediting;

import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.LtxSourceViewerConfiguration;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.text.ICharPairMatcher;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionUtils;
import org.eclipse.statet.ecommons.text.ui.presentation.SingleTokenScanner;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.internal.redocs.tex.r.RedocsTexRPlugin;
import org.eclipse.statet.internal.redocs.tex.r.ui.sourceediting.DocRQuickOutlineInformationProvider;
import org.eclipse.statet.internal.redocs.tex.r.ui.sourceediting.RChunkTemplateCompletionComputer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.LTKUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.EcoReconciler2;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.MultiContentSectionSourceViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistCategory;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistProcessor;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.core.source.RPartitionNodeType;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RAutoEditStrategy;
import org.eclipse.statet.r.ui.sourceediting.RSourceViewerConfiguration;
import org.eclipse.statet.r.ui.text.r.RDoubleClickStrategy;
import org.eclipse.statet.redocs.tex.r.core.source.LtxRweaveBracketPairMatcher;
import org.eclipse.statet.redocs.tex.r.core.source.LtxRweaveDocumentContentInfo;
import org.eclipse.statet.redocs.tex.r.core.source.TexRweaveDocumentConstants;
import org.eclipse.statet.redocs.tex.r.ui.editors.LtxRweaveEditor;
import org.eclipse.statet.redocs.tex.r.ui.sourceediting.TexRweaveEditingOptions;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class LtxRweaveSourceViewerConfiguration
extends MultiContentSectionSourceViewerConfiguration {
    private static final String[] CONTENT_TYPES = (String[])TexRweaveDocumentConstants.LTX_R_CONTENT_TYPES.toArray((Object[])new String[TexRweaveDocumentConstants.LTX_R_CONTENT_TYPES.size()]);
    private final LtxConfiguration docConfig;
    private final RChunkConfiguration rConfig;
    private ITextDoubleClickStrategy rDoubleClickStrategy;

    public LtxRweaveSourceViewerConfiguration(int flags) {
        this(flags, null, null, null, null);
    }

    public LtxRweaveSourceViewerConfiguration(int flags, LtxRweaveEditor sourceEditor, TexCoreAccess texCoreAccess, RCoreAccess rCoreAccess, IPreferenceStore preferenceStore) {
        super((DocContentSections)LtxRweaveDocumentContentInfo.INSTANCE, flags, (ISourceEditor)sourceEditor);
        this.docConfig = new LtxConfiguration((DocContentSections)LtxRweaveDocumentContentInfo.INSTANCE, flags, (ISourceEditor)sourceEditor, texCoreAccess, preferenceStore);
        this.rConfig = new RChunkConfiguration((DocContentSections)LtxRweaveDocumentContentInfo.INSTANCE, flags & 0xFF, (IRSourceEditor)sourceEditor, rCoreAccess, preferenceStore);
        this.registerConfig("org.eclipse.statet.Ltx", (SourceEditorViewerConfiguration)this.docConfig);
        this.registerConfig("org.eclipse.statet.R", (SourceEditorViewerConfiguration)this.rConfig);
        this.setup(preferenceStore != null ? preferenceStore : RedocsTexRPlugin.getInstance().getEditorPreferenceStore(), LTKUIPreferences.getEditorDecorationPreferences(), LTKUIPreferences.getAssistPreferences());
    }

    protected void initScanners() {
        TextStyleManager textStyles = this.rConfig.getTextStyles();
        this.addScanner("RweaveChunk.Base", (ITokenScanner)new SingleTokenScanner(textStyles, "text_R_rUndefined"));
    }

    protected ITokenScanner getScanner(String contentType) {
        if (contentType == "RweaveChunk.Control") {
            return this.rConfig.getScanner("R.Default");
        }
        if (contentType == "RweaveChunk.Comment") {
            return this.rConfig.getScanner("R.Comment");
        }
        return super.getScanner(contentType);
    }

    protected void setCoreAccess(TexCoreAccess texCoreAccess, RCoreAccess rCoreAccess) {
        this.docConfig.setCoreAccess(texCoreAccess);
        this.rConfig.setCoreAccess(rCoreAccess);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    protected void initPresentationReconciler(PresentationReconciler reconciler) {
        super.initPresentationReconciler(reconciler);
        for (String contentType : TexRweaveDocumentConstants.RCHUNK_CONTENT_TYPES) {
            ITokenScanner scanner = this.getScanner(contentType);
            if (scanner == null) continue;
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer(scanner);
            reconciler.setDamager((IPresentationDamager)dr, contentType);
            reconciler.setRepairer((IPresentationRepairer)dr, contentType);
        }
    }

    public ICharPairMatcher createPairMatcher() {
        return new LtxRweaveBracketPairMatcher();
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        switch (LtxRweaveDocumentContentInfo.INSTANCE.getTypeByPartition(contentType)) {
            case "org.eclipse.statet.Ltx": {
                return this.docConfig.getDoubleClickStrategy(sourceViewer, contentType);
            }
            case "org.eclipse.statet.LtxR-ChunkControl": 
            case "org.eclipse.statet.R": {
                if (this.rDoubleClickStrategy == null) {
                    RHeuristicTokenScanner scanner = RHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo());
                    this.rDoubleClickStrategy = new RDoubleClickStrategy(scanner, (ICharPairMatcher)LtxRweaveBracketPairMatcher.createRChunkPairMatcher(scanner));
                }
                return this.rDoubleClickStrategy;
            }
        }
        return null;
    }

    protected IReconcilingStrategy getSpellingStrategy(ISourceViewer sourceViewer) {
        if (!((Boolean)this.rConfig.getRCoreAccess().getPrefs().getPreferenceValue((Preference)TexRweaveEditingOptions.LTX_SPELLCHECK_ENABLED_PREF)).booleanValue() || !this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        SpellingService spellingService = EditorsUI.getSpellingService();
        if (spellingService.getActiveSpellingEngineDescriptor(this.fPreferenceStore) == null) {
            return null;
        }
        return new SpellingReconcileStrategy(sourceViewer, spellingService);
    }

    protected void initContentAssist(ContentAssist assistant) {
        super.initContentAssist(assistant);
        RChunkTemplateCompletionComputer chunkComputer = new RChunkTemplateCompletionComputer();
        ContentAssistProcessor texProcessor = (ContentAssistProcessor)assistant.getContentAssistProcessor("Ltx.Default");
        texProcessor.addCategory(new ContentAssistCategory("Ltx.Default", (List)ImCollections.newList((Object)((Object)chunkComputer))));
        texProcessor.setCompletionProposalAutoActivationCharacters(new char[]{'\\', '<'});
        ContentAssistProcessor mathProcessor = (ContentAssistProcessor)assistant.getContentAssistProcessor("Ltx.Math");
        mathProcessor.addCategory(new ContentAssistCategory("Ltx.Math", (List)ImCollections.newList((Object)((Object)chunkComputer))));
        mathProcessor.setCompletionProposalAutoActivationCharacters(new char[]{'\\', '<'});
        ContentAssistProcessor controlProcessor = new ContentAssistProcessor(assistant, "RweaveChunk.Base", RedocsTexRPlugin.getInstance().getLtxRweaveEditorContentAssistRegistry(), this.getSourceEditor());
        controlProcessor.addCategory(new ContentAssistCategory("RweaveChunk.Base", (List)ImCollections.newList((Object)((Object)chunkComputer))));
        assistant.setContentAssistProcessor((IContentAssistProcessor)controlProcessor, "RweaveChunk.Base");
        assistant.setContentAssistProcessor((IContentAssistProcessor)controlProcessor, "RweaveChunk.Control");
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        IReconcilingStrategy spellingStrategy;
        ISourceEditor editor = this.getSourceEditor();
        if (!(editor instanceof SourceEditor1)) {
            return null;
        }
        EcoReconciler2 reconciler = (EcoReconciler2)this.docConfig.getReconciler(sourceViewer);
        if (reconciler != null && (spellingStrategy = this.getSpellingStrategy(sourceViewer)) != null) {
            reconciler.addReconcilingStrategy(spellingStrategy);
        }
        return reconciler;
    }

    protected IInformationProvider getQuickInformationProvider(ISourceViewer sourceViewer, int operation) {
        ISourceEditor editor = this.getSourceEditor();
        if (editor == null) {
            return null;
        }
        switch (operation) {
            case 51: {
                return new DocRQuickOutlineInformationProvider(editor, operation);
            }
        }
        return null;
    }

    private static class LtxConfiguration
    extends LtxSourceViewerConfiguration {
        public LtxConfiguration(DocContentSections documentContentInfo, int flags, ISourceEditor editor, TexCoreAccess texCoreAccess, IPreferenceStore preferenceStore) {
            super(documentContentInfo, flags, editor, texCoreAccess, preferenceStore, null);
        }

        protected void setCoreAccess(TexCoreAccess access) {
            super.setCoreAccess(access);
        }
    }

    private static class RChunkAutoEditStrategy
    extends RAutoEditStrategy {
        public RChunkAutoEditStrategy(RCoreAccess coreAccess, ISourceEditor sourceEditor) {
            super(coreAccess, sourceEditor);
        }

        protected TextRegion getValidRange(int offset, TreePartition partition, int c) {
            switch (LtxRweaveDocumentContentInfo.INSTANCE.getTypeByPartition(partition.getType())) {
                case "org.eclipse.statet.R": {
                    return TreePartitionUtils.searchNodeUp((TreePartitionNode)partition.getTreeNode(), (TreePartitionNodeType)RPartitionNodeType.DEFAULT_ROOT);
                }
                case "org.eclipse.statet.LtxR-ChunkControl": {
                    switch (c) {
                        case 34: 
                        case 37: 
                        case 39: 
                        case 40: 
                        case 91: 
                        case 123: {
                            return TreePartitionUtils.searchPartitionRegion((TreePartition)partition, (PartitionConstraint)TexRweaveDocumentConstants.RCHUNK_PARTITION_CONSTRAINT);
                        }
                    }
                    return null;
                }
            }
            return null;
        }
    }

    private static class RChunkConfiguration
    extends RSourceViewerConfiguration {
        public RChunkConfiguration(DocContentSections documentContentInfo, int flags, IRSourceEditor sourceEditor, RCoreAccess coreAccess, IPreferenceStore preferenceStore) {
            super(documentContentInfo, flags, sourceEditor, coreAccess, preferenceStore, null);
        }

        protected void setCoreAccess(RCoreAccess access) {
            super.setCoreAccess(access);
        }

        protected TextStyleManager getTextStyles() {
            return super.getTextStyles();
        }

        protected ITokenScanner getScanner(String contentType) {
            return super.getScanner(contentType);
        }

        protected RAutoEditStrategy createRAutoEditStrategy() {
            return new RChunkAutoEditStrategy(this.getRCoreAccess(), (ISourceEditor)this.getSourceEditor());
        }
    }
}

