/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.statet.ecommons.waltable.command.AbstractDimPositionsCommand;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.LayerUtil;

public abstract class AbstractSelectDimPositionsCommand
extends AbstractDimPositionsCommand {
    private final int selectionFlags;
    private long positionToReveal;

    public AbstractSelectDimPositionsCommand(ILayerDim dim, long position, int selectionFlags) {
        this(dim, position, Collections.singletonList(new LRange(position)), position, selectionFlags);
    }

    public AbstractSelectDimPositionsCommand(ILayerDim dim, long refPosition, Collection<LRange> positions, long positionToReveal, int selectionFlags) {
        super(dim, refPosition, positions);
        this.positionToReveal = positionToReveal;
        this.selectionFlags = selectionFlags;
    }

    protected AbstractSelectDimPositionsCommand(AbstractSelectDimPositionsCommand command) {
        super(command);
        this.positionToReveal = command.positionToReveal;
        this.selectionFlags = command.selectionFlags;
    }

    public int getSelectionFlags() {
        return this.selectionFlags;
    }

    public long getPositionToReveal() {
        return this.positionToReveal;
    }

    @Override
    protected boolean convertToTargetLayer(ILayerDim dim, long refPosition, ILayerDim targetDim) {
        if (super.convertToTargetLayer(dim, refPosition, targetDim)) {
            if (this.positionToReveal != Long.MIN_VALUE) {
                this.positionToReveal = this.positionToReveal == refPosition ? this.getRefPosition() : LayerUtil.convertPosition(dim, refPosition, this.positionToReveal, targetDim);
            }
            return true;
        }
        return false;
    }
}

