/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.REnvSelectionComposite;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.rhelp.KeywordSelectionDialog;
import org.eclipse.statet.internal.r.ui.rhelp.PackageSelectionDialog;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpSearchUIQuery;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpKeyword;
import org.eclipse.statet.rhelp.core.RHelpKeywordGroup;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RHelpSearchQuery;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

@NonNullByDefault
public class RHelpSearchInputPage
extends DialogPage
implements ISearchPage {
    private static final String PAGE_ID = "RHelpSearchPage";
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("[\\,\\;\\s]+");
    private ISearchPageContainer container;
    private IDialogSettings dialogSettings;
    private final LinkedHashMap<String, RHelpSearchQuery> queryHistory = new LinkedHashMap(25);
    private Combo searchTextControl;
    private Button typeTopicsControl;
    private Button typeFieldsControl;
    private Button typeDocControl;
    private Button fieldTitleControl;
    private Button fieldConceptsControl;
    private Button fieldAliasControl;
    private Combo keywordsInputControl;
    private Combo packagesInputControl;
    private REnvSelectionComposite rEnvControl;
    private final RHelpManager rHelpManager = RCore.getRHelpManager();

    private static String prettyList(List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(list.size() * 10);
        for (String s : list) {
            sb.append(s);
            sb.append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    private static ImList<String> toList(String input) {
        Object[] array = SEPARATOR_PATTERN.split(input);
        if (array.length == 1 && ((String)array[0]).isEmpty()) {
            return ImCollections.emptyList();
        }
        return ImCollections.newList((Object[])array);
    }

    private static String[] notNull(String @Nullable [] array) {
        return array != null ? array : new String[]{};
    }

    private RHelpSearchQuery loadQuery(IDialogSettings settings) {
        int type = settings.getInt("type");
        String text = settings.get("text");
        ImList fields = ImCollections.newList((Object[])settings.getArray("fields"));
        ImList keywords = ImCollections.newList((Object[])settings.getArray("keywords"));
        ImList packages = ImCollections.newList((Object[])settings.getArray("packages"));
        return new RHelpSearchQuery(type, text, (List)fields, (List)keywords, (List)packages, null);
    }

    private void saveQuery(RHelpSearchQuery query, IDialogSettings settings) {
        settings.put("type", query.getSearchType());
        settings.put("text", query.getSearchString());
        ImList fields = query.getEnabledFields();
        settings.put("fields", (String[])fields.toArray((Object[])new String[fields.size()]));
        ImList keywords = query.getKeywords();
        settings.put("keywords", (String[])keywords.toArray((Object[])new String[keywords.size()]));
        ImList packages = query.getPackages();
        settings.put("packages", (String[])packages.toArray((Object[])new String[packages.size()]));
    }

    private IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.dialogSettings = DialogUtils.getDialogSettings((AbstractUIPlugin)RUIPlugin.getInstance(), (String)PAGE_ID);
        }
        return this.dialogSettings;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)1));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText("Search S&tring:");
        this.searchTextControl = new Combo(composite, 4);
        this.searchTextControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchTextControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIdx;
                if (!RHelpSearchInputPage.this.searchTextControl.getListVisible() && (selectionIdx = RHelpSearchInputPage.this.searchTextControl.getSelectionIndex()) >= 0) {
                    RHelpSearchInputPage.this.loadPattern((RHelpSearchQuery)RHelpSearchInputPage.this.queryHistory.get(RHelpSearchInputPage.this.searchTextControl.getItem(selectionIdx)));
                }
            }
        });
        Composite searchInGroup = this.createSearchInGroup(composite);
        searchInGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite restrictToGroup = this.createRestrictToGroup(composite);
        restrictToGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite scopeGroup = this.createScopeGroup(composite);
        scopeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.statet.r.ui.r_help-search_page");
        this.loadSettings();
        this.initSettings();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (UIAccess.isOkToUse((Control)RHelpSearchInputPage.this.searchTextControl)) {
                    RHelpSearchInputPage.this.searchTextControl.setFocus();
                }
                RHelpSearchInputPage.this.updateState();
            }
        });
    }

    private Composite createSearchInGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 4, false, false));
        group.setText("Search in:");
        GridLayout layout = LayoutUtils.newGroupGrid((int)1);
        group.setLayout((Layout)layout);
        Button button = new Button((Composite)group, 16);
        button.setText("&Topics/Alias (strict)");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.typeTopicsControl = button;
        button = new Button((Composite)group, 16);
        button.setText("Selected &Fields");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setSelection(true);
        this.typeFieldsControl = button;
        button = new Button((Composite)group, 16);
        button.setText("Complete &Document");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.typeDocControl = button;
        group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(16384, 4, true, false));
        group.setText("Fields:");
        layout = LayoutUtils.newGroupGrid((int)1);
        group.setLayout((Layout)layout);
        button = new Button((Composite)group, 32);
        button.setText("T&itle");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setSelection(true);
        this.fieldTitleControl = button;
        button = new Button((Composite)group, 32);
        button.setText("Topics/&Alias");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setSelection(true);
        this.fieldAliasControl = button;
        button = new Button((Composite)group, 32);
        button.setText("C&oncepts");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setSelection(true);
        this.fieldConceptsControl = button;
        this.typeFieldsControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RHelpSearchInputPage.this.updateFieldsState();
            }
        });
        return composite;
    }

    private void updateFieldsState() {
        boolean enable = this.typeFieldsControl.getSelection();
        this.fieldTitleControl.setEnabled(enable);
        this.fieldAliasControl.setEnabled(enable);
        this.fieldConceptsControl.setEnabled(enable);
    }

    private @Nullable REnvHelp getREnvHelp(boolean fallbackDefault) {
        REnvHelp help;
        REnv rEnv = this.rEnvControl.getSelection();
        if (rEnv != null && (help = this.rHelpManager.getHelp(rEnv)) != null) {
            return help;
        }
        if (fallbackDefault && (rEnv = RCore.getREnvManager().getDefault()) != null && (help = this.rHelpManager.getHelp(rEnv)) != null) {
            return help;
        }
        return null;
    }

    private Composite createRestrictToGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Restrict to:");
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)3));
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("&Keyword:");
        this.keywordsInputControl = new Combo((Composite)group, 4);
        this.keywordsInputControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button button = new Button((Composite)group, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.setText("Select...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeywordSelectionDialog dialog;
                ImList keywords = null;
                REnvHelp help = RHelpSearchInputPage.this.getREnvHelp(true);
                if (help != null) {
                    try {
                        keywords = help.getKeywords();
                    }
                    finally {
                        help.unlock();
                    }
                }
                if (keywords != null && (dialog = new KeywordSelectionDialog(RHelpSearchInputPage.this.getControl().getShell(), (List<RHelpKeywordGroup>)keywords)).open() == 0) {
                    Object[] result;
                    StringBuilder input = new StringBuilder();
                    Object[] objectArray = result = dialog.getResult();
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selectionItem = objectArray[n2];
                        if (selectionItem instanceof RHelpKeyword) {
                            input.append(((RHelpKeyword)selectionItem).getKeyword());
                            break;
                        }
                        ++n2;
                    }
                    RHelpSearchInputPage.this.keywordsInputControl.setText(input.toString());
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("&Package:");
        this.packagesInputControl = new Combo((Composite)group, 4);
        this.packagesInputControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button = new Button((Composite)group, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.setText("Select...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImList packages = null;
                REnvHelp help = RHelpSearchInputPage.this.getREnvHelp(true);
                if (help != null) {
                    try {
                        packages = help.getPkgs();
                    }
                    finally {
                        help.unlock();
                    }
                }
                if (packages != null) {
                    ImList currentNames = RHelpSearchInputPage.toList(RHelpSearchInputPage.this.packagesInputControl.getText());
                    ArrayList<RPkgHelp> currentPkgs = new ArrayList<RPkgHelp>(currentNames.size());
                    for (String name : currentNames) {
                        for (RPkgHelp pkg : packages) {
                            if (!pkg.getName().equals(name)) continue;
                            currentPkgs.add(pkg);
                        }
                    }
                    PackageSelectionDialog dialog = new PackageSelectionDialog(RHelpSearchInputPage.this.getControl().getShell(), (List<RPkgHelp>)packages, currentPkgs);
                    if (dialog.open() == 0) {
                        StringBuilder input = new StringBuilder();
                        Object[] result = dialog.getResult();
                        if (result.length > 0) {
                            Arrays.sort(result);
                            Object[] objectArray = result;
                            int n = result.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object pkg = objectArray[n2];
                                input.append(pkg.getName());
                                input.append(", ");
                                ++n2;
                            }
                            RHelpSearchInputPage.this.packagesInputControl.setText(input.substring(0, input.length() - 2));
                        } else {
                            RHelpSearchInputPage.this.packagesInputControl.setText("");
                        }
                    }
                }
            }
        });
        return group;
    }

    private Composite createScopeGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Scope:");
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        this.rEnvControl = new REnvSelectionComposite((Composite)group);
        this.rEnvControl.setLayoutData(new GridData(4, 4, true, false));
        this.rEnvControl.addChangeListener(new REnvSelectionComposite.ChangeListener(){

            @Override
            public void settingChanged(REnvSelectionComposite source, String oldValue, String newValue, REnv newREnv) {
                RHelpSearchInputPage.this.updateState();
            }
        });
        return group;
    }

    private void updateState() {
        REnv rEnv = this.rEnvControl.getSelection();
        if (rEnv == null || rEnv.get(REnvHelpConfiguration.class) == null || !this.rHelpManager.hasHelp(rEnv)) {
            this.container.setPerformActionEnabled(false);
            return;
        }
        this.container.setPerformActionEnabled(true);
    }

    private void loadSettings() {
        IDialogSettings section;
        IDialogSettings dialogSettings = this.getDialogSettings();
        this.keywordsInputControl.setItems(RHelpSearchInputPage.notNull(dialogSettings.getArray("keywords")));
        this.packagesInputControl.setItems(RHelpSearchInputPage.notNull(dialogSettings.getArray("packages")));
        int num = 0;
        ArrayList<String> texts = new ArrayList<String>();
        while ((section = dialogSettings.getSection("searchhist" + num++)) != null) {
            RHelpSearchQuery hist = this.loadQuery(section);
            texts.add(hist.getSearchString());
            this.queryHistory.put(hist.getSearchString(), hist);
        }
        if (!this.queryHistory.isEmpty()) {
            this.searchTextControl.setItems(texts.toArray(new String[texts.size()]));
        }
    }

    private void initREnv(@Nullable IWorkbenchPart part) {
        REnv defaultREnv = RCore.getREnvManager().getDefault();
        this.rEnvControl.setSetting(defaultREnv);
        if (part == null) {
            return;
        }
        REnv rEnv = (REnv)part.getAdapter(REnv.class);
        if (rEnv == null) {
            return;
        }
        if (rEnv != defaultREnv && rEnv.resolve() != defaultREnv.resolve() && this.rHelpManager.hasHelp(rEnv)) {
            this.rEnvControl.setSetting(rEnv);
        }
    }

    private void initSettings() {
        LtkModelElement element;
        Object firstElement;
        IWorkbenchPart part = UIAccess.getActiveWorkbenchPart((boolean)true);
        this.initREnv(part);
        ISelection selection = this.container.getSelection();
        if (selection instanceof ITextSelection) {
            this.searchTextControl.setText(((ITextSelection)selection).getText());
            return;
        }
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof LtkModelElement && (element = (LtkModelElement)firstElement).getModelTypeId() == "R" && element.getElementName().getSegmentName() != null) {
            this.searchTextControl.setText(element.getElementName().getDisplayName());
            return;
        }
        if (!this.queryHistory.isEmpty()) {
            this.loadPattern(this.queryHistory.values().iterator().next());
            return;
        }
    }

    private void saveSettings(RHelpSearchQuery query) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put("keywords", DialogUtils.combineHistoryItems((String[])this.keywordsInputControl.getItems(), (String)RHelpSearchInputPage.prettyList((List<String>)query.getKeywords())));
        dialogSettings.put("packages", DialogUtils.combineHistoryItems((String[])this.packagesInputControl.getItems(), (String)RHelpSearchInputPage.prettyList((List<String>)query.getPackages())));
        this.queryHistory.remove(query.getSearchString());
        int num = 0;
        this.saveQuery(query, dialogSettings.addNewSection("searchhist" + num++));
        for (RHelpSearchQuery hist : this.queryHistory.values()) {
            this.saveQuery(hist, dialogSettings.addNewSection("searchhist" + num++));
            if (num >= 25) break;
        }
    }

    private void loadPattern(@Nullable RHelpSearchQuery query) {
        if (query == null) {
            return;
        }
        this.searchTextControl.setText(query.getSearchString());
        this.typeTopicsControl.setSelection(false);
        this.typeFieldsControl.setSelection(false);
        this.typeDocControl.setSelection(false);
        switch (query.getSearchType()) {
            case 1: {
                this.typeTopicsControl.setSelection(true);
                break;
            }
            case 2: {
                this.typeFieldsControl.setSelection(true);
                break;
            }
            case 3: {
                this.typeDocControl.setSelection(true);
            }
        }
        this.fieldAliasControl.setSelection(query.getEnabledFields().contains((Object)"alias.txt"));
        this.fieldTitleControl.setSelection(query.getEnabledFields().contains((Object)"title.txt"));
        this.fieldConceptsControl.setSelection(query.getEnabledFields().contains((Object)"concept.txt"));
        this.updateFieldsState();
        this.keywordsInputControl.setText(RHelpSearchInputPage.prettyList((List<String>)query.getKeywords()));
        this.packagesInputControl.setText(RHelpSearchInputPage.prettyList((List<String>)query.getPackages()));
    }

    private RHelpSearchQuery createPattern() {
        int type = 0;
        if (this.typeTopicsControl.getSelection()) {
            type = 1;
        } else if (this.typeFieldsControl.getSelection()) {
            type = 2;
        } else if (this.typeDocControl.getSelection()) {
            type = 3;
        }
        String text = this.searchTextControl.getText();
        ArrayList<String> fields = new ArrayList<String>(3);
        if (this.fieldAliasControl.getSelection()) {
            fields.add("alias.txt");
        }
        if (this.fieldTitleControl.getSelection()) {
            fields.add("title.txt");
        }
        if (this.fieldConceptsControl.getSelection()) {
            fields.add("concept.txt");
        }
        ImList<String> keywords = RHelpSearchInputPage.toList(this.keywordsInputControl.getText());
        ImList<String> packages = RHelpSearchInputPage.toList(this.packagesInputControl.getText());
        REnv renv = this.rEnvControl.getSelection();
        return new RHelpSearchQuery(type, text, fields, keywords, packages, renv);
    }

    public boolean performAction() {
        RHelpSearchQuery query = this.createPattern();
        try {
            query.validate();
            this.saveSettings(query);
            RHelpSearchUIQuery uiQuery = new RHelpSearchUIQuery(query);
            NewSearchUI.runQueryInBackground((ISearchQuery)uiQuery);
            return true;
        }
        catch (StatusException e) {
            this.setErrorMessage(e.getLocalizedMessage());
            return false;
        }
    }
}

