/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.lang.management.ManagementFactory;
import java.util.Date;
import javax.management.JMException;
import javax.management.ObjectName;
import org.eclipse.statet.internal.rj.servi.MXNodeState;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.servi.jmx.NodeStateMX;
import org.eclipse.statet.rj.servi.jmx.PoolStatusMX;
import org.eclipse.statet.rj.servi.pool.PoolNodeItem;
import org.eclipse.statet.rj.servi.pool.PoolServer;
import org.eclipse.statet.rj.servi.pool.PoolStatus;

@NonNullByDefault
public class MXPoolStatus
extends PoolStatus<NodeStateMX>
implements PoolStatusMX {
    private @Nullable ObjectName jmName;
    private Date time;

    public MXPoolStatus(PoolServer server) {
        super(server);
        this.refresh();
    }

    public void initJM() throws JMException {
        ObjectName jmName;
        this.jmName = jmName = new ObjectName(String.valueOf(this.server.getJMBaseName()) + "type=Server.PoolStatus");
        ManagementFactory.getPlatformMBeanServer().registerMBean(this, jmName);
    }

    public void disposeJM() throws JMException {
        ObjectName jmName = this.jmName;
        if (jmName != null) {
            this.jmName = null;
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(jmName);
        }
    }

    protected synchronized void refresh() {
        long stamp = System.currentTimeMillis();
        this.refresh(this.server.getManager(), stamp);
        this.time = new Date(stamp);
    }

    @Override
    protected NodeStateMX createNodeState(PoolNodeItem item) {
        return new MXNodeState(item);
    }

    @Override
    public synchronized Date getStatusTime() {
        return this.time;
    }
}

