/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.launching;

import java.util.Map;
import org.eclipse.statet.internal.r.apps.ui.launching.AppRunner;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.statet.jcommons.ts.core.ToolCommandHandler;
import org.eclipse.statet.jcommons.ts.core.util.ToolCommandHandlerUtils;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.rj.ts.core.AbstractRToolCommandHandler;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
class AppRCommandHandler
extends AbstractRToolCommandHandler {
    private static final String ON_APP_STARTED_ID = "org.eclipse.statet.r.apps.onAppStarted";
    private static final String ON_APP_STOPPED_ID = "org.eclipse.statet.r.apps.onAppStopped";
    private @Nullable AppRunner currentRunner;

    static AppRCommandHandler connect(AppRunner runner, RToolService r, ProgressMonitor m) throws StatusException {
        ToolController controller = ((RProcess)r.getTool()).getController();
        AppRCommandHandler handler = (AppRCommandHandler)controller.getCommandHandler(ON_APP_STARTED_ID);
        if (handler == null) {
            handler = new AppRCommandHandler();
            controller.addCommandHandler(ON_APP_STARTED_ID, (ToolCommandHandler)handler);
            controller.addCommandHandler(ON_APP_STOPPED_ID, (ToolCommandHandler)handler);
        }
        handler.currentRunner = runner;
        return handler;
    }

    private AppRCommandHandler() {
    }

    protected Status execute(String id, RToolService r, Map<String, Object> data, ProgressMonitor m) throws StatusException {
        if (id.equals(ON_APP_STARTED_ID) && this.currentRunner != null) {
            this.currentRunner.onAppStarted((String)ToolCommandHandlerUtils.getCheckedData(data, (String)"url", String.class, (boolean)false), (String)ToolCommandHandlerUtils.getCheckedData(data, (String)"typeId", String.class, (boolean)false));
        }
        if (id.equals(ON_APP_STOPPED_ID) && this.currentRunner != null) {
            this.currentRunner.onAppStopped((String)ToolCommandHandlerUtils.getCheckedData(data, (String)"url", String.class, (boolean)false));
        }
        return Statuses.OK_STATUS;
    }

    void disconnect(AppRunner runner) {
        if (this.currentRunner == runner) {
            this.currentRunner = null;
        }
    }
}

