/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class RealProjectRestrictStatistics
extends RealNoPutResultSetStatistics {
    public boolean doesProjection;
    public boolean restriction;
    public long restrictionTime;
    public long projectionTime;
    public ResultSetStatistics childResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public RealProjectRestrictStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, int n4, long l5, long l6, ResultSetStatistics[] resultSetStatisticsArray, boolean bl, boolean bl2, double d, double d2, ResultSetStatistics resultSetStatistics) {
        super(n, n2, n3, l, l2, l3, l4, n4, d, d2);
        this.restriction = bl;
        this.doesProjection = bl2;
        this.restrictionTime = l5;
        this.projectionTime = l6;
        this.subqueryTrackingArray = ArrayUtil.copy(resultSetStatisticsArray);
        this.childResultSetStatistics = resultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int n) {
        String string = "";
        this.initFormatInfo(n);
        if (this.subqueryTrackingArray != null) {
            boolean bl = false;
            for (int i = 0; i < this.subqueryTrackingArray.length; ++i) {
                if (this.subqueryTrackingArray[i] == null) continue;
                if (!bl) {
                    string = this.indent + MessageService.getTextMessage("43X56.U", new Object[0]) + ":\n";
                    bl = true;
                }
                string = string + this.subqueryTrackingArray[i].getStatementExecutionPlanText(this.sourceDepth);
            }
        }
        return string + this.indent + MessageService.getTextMessage("43X93.U", new Object[0]) + " (" + this.resultSetNumber + "):" + "\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U", new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U", new Object[0]) + " = " + this.rowsFiltered + "\n" + this.indent + MessageService.getTextMessage("43X94.U", new Object[0]) + " = " + this.restriction + "\n" + this.indent + MessageService.getTextMessage("43X95.U", new Object[0]) + " = " + this.doesProjection + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.subIndent + MessageService.getTextMessage("43X96.U", new Object[0]) + " = " + this.restrictionTime + "\n" + this.subIndent + MessageService.getTextMessage("43X97.U", new Object[0]) + " = " + this.projectionTime + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X05.U", new Object[0]) + ":" + "\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth);
    }

    @Override
    public String getScanStatisticsText(String string, int n) {
        String string2 = "";
        if (this.subqueryTrackingArray != null) {
            for (int i = 0; i < this.subqueryTrackingArray.length; ++i) {
                if (this.subqueryTrackingArray[i] == null) continue;
                string2 = string2 + "\n" + MessageService.getTextMessage("43X01.U", new Object[0]) + " " + i + "\n" + this.subqueryTrackingArray[i].getScanStatisticsText(string, n) + MessageService.getTextMessage("43X06.U", new Object[0]) + " " + i + "\n\n";
            }
        }
        return string2 + this.childResultSetStatistics.getScanStatisticsText(string, n);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.childResultSetStatistics);
        if (this.subqueryTrackingArray != null) {
            for (int i = 0; i < this.subqueryTrackingArray.length; ++i) {
                if (this.subqueryTrackingArray[i] == null) continue;
                vector.addElement(this.subqueryTrackingArray[i]);
            }
        }
        return vector;
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X98.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n = 0;
        if (this.childResultSetStatistics != null) {
            ++n;
        }
        if (this.subqueryTrackingArray != null) {
            n += this.subqueryTrackingArray.length;
        }
        xPLAINVisitor.setNumberOfChildren(n);
        xPLAINVisitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(xPLAINVisitor);
        }
        if (this.subqueryTrackingArray != null) {
            boolean bl = false;
            for (int i = 0; i < this.subqueryTrackingArray.length; ++i) {
                if (this.subqueryTrackingArray[i] == null) continue;
                this.subqueryTrackingArray[i].accept(xPLAINVisitor);
            }
        }
    }

    @Override
    public String getRSXplainType() {
        if (this.restriction && this.doesProjection) {
            return "PROJECT-FILTER";
        }
        if (this.doesProjection) {
            return "PROJECTION";
        }
        if (this.restriction) {
            return "FILTER";
        }
        return "PROJECT-FILTER";
    }

    @Override
    public String getRSXplainDetails() {
        return this.resultSetNumber + ";";
    }

    @Override
    public Object getResultSetTimingsDescriptor(Object object) {
        return new XPLAINResultSetTimingsDescriptor((UUID)object, new Long(this.constructorTime), new Long(this.openTime), new Long(this.nextTime), new Long(this.closeTime), new Long(this.getNodeTime()), XPLAINUtil.getAVGNextTime(this.nextTime, this.rowsSeen), new Long(this.projectionTime), new Long(this.restrictionTime), null, null);
    }
}

