/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BitConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class VarbitConstantNode
extends BitConstantNode {
    static final int K_VAR = 0;
    static final int K_LONGVAR = 1;
    static final int K_BLOB = 2;
    final int kind;

    VarbitConstantNode(TypeId typeId, ContextManager contextManager) throws StandardException {
        super(typeId, contextManager);
        switch (typeId.getJDBCTypeId()) {
            case -3: {
                this.kind = 0;
                break;
            }
            case -4: {
                this.kind = 1;
                break;
            }
            case 2004: {
                this.kind = 2;
                break;
            }
            default: {
                this.kind = -1;
            }
        }
    }

    VarbitConstantNode(String string, int n, ContextManager contextManager) throws StandardException {
        super(string, n, contextManager);
        this.kind = 0;
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((VarbitConstantNode)valueNode).kind == this.kind;
    }
}

