/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.ScannerImpl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.StatusDetail;
import org.eclipse.statet.yaml.core.ast.Collection;
import org.eclipse.statet.yaml.core.ast.Directive;
import org.eclipse.statet.yaml.core.ast.DocContent;
import org.eclipse.statet.yaml.core.ast.Dummy;
import org.eclipse.statet.yaml.core.ast.Instruction;
import org.eclipse.statet.yaml.core.ast.Label;
import org.eclipse.statet.yaml.core.ast.NContainer;
import org.eclipse.statet.yaml.core.ast.NodeType;
import org.eclipse.statet.yaml.core.ast.Scalar;
import org.eclipse.statet.yaml.core.ast.SourceComponent;
import org.eclipse.statet.yaml.core.ast.Tag;
import org.eclipse.statet.yaml.core.ast.Tuple;
import org.eclipse.statet.yaml.core.ast.YamlAstNode;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.tokens.AliasToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.TagTuple;
import org.yaml.snakeyaml.tokens.Token;

@NonNullByDefault
public class YamlParser {
    private final ScannerImpl scanner = new ScannerImpl(new StreamReader(""), true, true, false){

        @Override
        protected void handleComment(int startIndex, int endIndex) {
        }

        @Override
        protected void handleSyntaxProblem(byte context, @Nullable Mark contextMark, byte problem, @Nullable Mark problemMark, @Nullable String problemArg1, @Nullable String problemArg2) {
            YamlParser.this.handleScannerProblem(new ProblemInfo(context, contextMark, problem, problemMark, problemArg1));
        }
    };
    private @Nullable YamlAstNode currentNode;
    private int depth;
    private final List<List<YamlAstNode>> childrenStack = new ArrayList<List<YamlAstNode>>();
    private final List<ProblemInfo> problemInfos = new ArrayList<ProblemInfo>();

    public void setScalarText(boolean create) {
        this.scanner.setCreateScalarText(create);
    }

    public SourceComponent parse(String text) {
        return this.parse(text, null, 0);
    }

    /*
     * Unable to fully structure code
     */
    public SourceComponent parse(String text, @Nullable AstNode parent, int offset) {
        try {
            this.depth = -1;
            this.scanner.reset(text, offset);
            sourceComponent = new SourceComponent(parent, offset, text.length());
            this.enterNode(sourceComponent);
            this.processTokens();
            while (this.depth >= 0) {
                this.exit();
            }
            var6_5 = sourceComponent;
            ** while (this.depth >= 0)
        }
        catch (Throwable var5_8) {
            ** while (this.depth >= 0)
        }
lbl-1000:
        // 1 sources

        {
            list = this.childrenStack.get(this.depth);
            list.clear();
            --this.depth;
            continue;
        }
lbl16:
        // 1 sources

        this.problemInfos.clear();
        return var6_5;
lbl-1000:
        // 1 sources

        {
            list = this.childrenStack.get(this.depth);
            list.clear();
            --this.depth;
            continue;
        }
lbl24:
        // 1 sources

        this.problemInfos.clear();
        throw var5_8;
    }

    private void addChildTerm(YamlAstNode node) {
        this.addChild(node);
        this.checkExit();
    }

    private void addChild(YamlAstNode node) {
        YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
        if (currentNode.getNodeType() == NodeType.MAP_ENTRY) {
            Tuple entry = (Tuple)currentNode;
            if (entry.keyNode == null && entry.valueIndicatorOffset == Integer.MIN_VALUE) {
                entry.keyNode = node;
            } else {
                entry.valueNode = node;
            }
        } else {
            List<YamlAstNode> children = this.childrenStack.get(this.depth);
            children.add(node);
            if (this.depth == 0) {
                this.clearProblems(node.getStartOffset());
            }
        }
    }

    private void finish(int endOffset) {
        List<YamlAstNode> children;
        YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
        switch (currentNode.getNodeType()) {
            case MAP_ENTRY: {
                int min;
                Tuple entry = (Tuple)currentNode;
                if (entry.keyNode == null) {
                    entry.keyNode = new Dummy(0, entry, entry.keyIndicatorOffset != Integer.MIN_VALUE ? entry.keyIndicatorOffset : entry.startOffset);
                }
                if (entry.status == 0 && entry.valueIndicatorOffset == Integer.MAX_VALUE) {
                    entry.status = 70425;
                }
                if (entry.valueNode == null) {
                    entry.valueNode = new Dummy(0, entry, entry.valueIndicatorOffset != Integer.MIN_VALUE ? entry.valueIndicatorOffset : entry.keyNode.endOffset);
                }
                if (entry.endOffset < (min = entry.valueNode.endOffset)) {
                    entry.endOffset = min;
                }
                return;
            }
            case MAP: {
                Collection collection = (Collection)currentNode;
                switch (collection.getOperator()) {
                    case '[': {
                        if (collection.getCloseIndicatorOffset() != Integer.MIN_VALUE) break;
                        collection.status = 70931;
                        break;
                    }
                    case '{': {
                        if (collection.getCloseIndicatorOffset() != Integer.MIN_VALUE) break;
                        collection.status = 70932;
                    }
                }
                break;
            }
        }
        NContainer container = (NContainer)currentNode;
        if (endOffset != Integer.MIN_VALUE) {
            container.endOffset = endOffset;
        }
        if (!(children = this.childrenStack.get(this.depth)).isEmpty()) {
            container.children = children.toArray(new YamlAstNode[children.size()]);
            children.clear();
            int min = container.children[container.children.length - 1].getEndOffset();
            if (container.endOffset < min) {
                container.endOffset = min;
            }
        }
    }

    private void enterNode(NContainer node) {
        if (this.depth >= 0) {
            this.addChild(node);
        }
        ++this.depth;
        this.currentNode = node;
        while (this.depth >= this.childrenStack.size()) {
            this.childrenStack.add(new ArrayList());
        }
    }

    private void enterNode(Tuple node) {
        this.addChild(node);
        ++this.depth;
        this.currentNode = node;
    }

    private boolean exitTo(Class<?> type1) {
        while (this.depth > 1) {
            if (((Object)((Object)this.currentNode)).getClass() == type1) {
                return true;
            }
            this.exit();
        }
        return false;
    }

    private boolean exitTo(Class<?> type1, Class<?> type2) {
        while (this.depth > 1) {
            if (((Object)((Object)this.currentNode)).getClass() == type1 || ((Object)((Object)this.currentNode)).getClass() == type2) {
                return true;
            }
            this.exit();
        }
        return false;
    }

    private boolean exitTo1(Class<?> type1) {
        if (this.depth > 1) {
            if (((Object)((Object)this.currentNode)).getClass() == type1) {
                return true;
            }
            if (this.currentNode.getNodeType() == NodeType.MAP_ENTRY) {
                this.exit();
            }
        }
        int checkDepth = this.depth - 1;
        YamlAstNode node = this.currentNode.getYamlParent();
        while (checkDepth > 1 && node != null) {
            if (((Object)((Object)node)).getClass() == type1) {
                while (this.depth > checkDepth) {
                    this.exit();
                }
                return true;
            }
            --checkDepth;
            node = node.getYamlParent();
        }
        return false;
    }

    private boolean exitTo1(Class<?> type1, Class<?> type2) {
        if (this.depth > 1) {
            if (((Object)((Object)this.currentNode)).getClass() == type1 || ((Object)((Object)this.currentNode)).getClass() == type2) {
                return true;
            }
            if (this.currentNode.getNodeType() == NodeType.MAP_ENTRY) {
                this.exit();
            }
        }
        int checkDepth = this.depth - 1;
        YamlAstNode node = this.currentNode.getYamlParent();
        while (checkDepth > 1 && node != null) {
            if (((Object)((Object)node)).getClass() == type1 || ((Object)((Object)node)).getClass() == type2) {
                while (this.depth > checkDepth) {
                    this.exit();
                }
                return true;
            }
            --checkDepth;
            node = node.getYamlParent();
        }
        return false;
    }

    private boolean exitTo(NodeType type1) {
        while (this.depth > 1) {
            if (this.currentNode.getNodeType() == type1) {
                return true;
            }
            this.exit();
        }
        return false;
    }

    private boolean exitTo(NodeType type1, NodeType type2) {
        while (this.depth > 1) {
            if (this.currentNode.getNodeType() == type1 || this.currentNode.getNodeType() == type2) {
                return true;
            }
            this.exit();
        }
        return false;
    }

    private void exitToSourceComponent(int offset) {
        while (this.depth > 1) {
            this.exit();
        }
        if (this.depth > 0) {
            this.exit(offset);
        }
    }

    private void exit(int offset) {
        this.finish(offset);
        this.currentNode = this.currentNode.yamlParent;
        --this.depth;
        this.checkExit();
    }

    private void exit() {
        this.finish(Integer.MIN_VALUE);
        this.currentNode = this.currentNode.yamlParent;
        --this.depth;
        this.checkExit();
    }

    private void checkExit() {
        if (this.depth > 0 && this.currentNode.getNodeType() == NodeType.MAP_ENTRY && ((Tuple)this.currentNode).valueNode != null) {
            this.exit();
        }
    }

    private void processTokens() {
        Token token;
        block25: while ((token = this.scanner.nextToken()) != null) {
            switch (token.getTokenId()) {
                case StreamEnd: 
                case StreamStart: {
                    continue block25;
                }
                case Directive: {
                    this.exitToSourceComponent(token.getStartMark().getIndex());
                    Directive node = new Directive((SourceComponent)this.currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex());
                    this.addChildTerm(node);
                    this.checkForProblem(token.getStartMark(), node);
                    continue block25;
                }
                case DocumentStart: {
                    this.exitToSourceComponent(token.getStartMark().getIndex());
                    Instruction.DocStart node = new Instruction.DocStart((SourceComponent)this.currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex());
                    this.addChildTerm(node);
                    this.checkForProblem(token.getStartMark(), node);
                    this.enterNode(new DocContent((SourceComponent)this.currentNode, token.getStartMark().getIndex()));
                    continue block25;
                }
                case DocumentEnd: {
                    this.exitToSourceComponent(token.getStartMark().getIndex());
                    Instruction.DocEnd node = new Instruction.DocEnd((SourceComponent)this.currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex());
                    this.addChildTerm(node);
                    this.checkForProblem(token.getStartMark(), node);
                    continue block25;
                }
                case BlockSequenceStart: {
                    Collection.BlockSeq node = new Collection.BlockSeq(this.currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex());
                    this.enterNode(node);
                    this.checkForProblem(token.getStartMark(), node);
                    continue block25;
                }
                case BlockMappingStart: {
                    Collection.BlockMap node = new Collection.BlockMap(this.currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex());
                    this.enterNode(node);
                    this.checkForProblem(token.getStartMark(), node);
                    continue block25;
                }
                case BlockEnd: {
                    boolean found = this.exitTo(Collection.BlockSeq.class, Collection.BlockMap.class);
                    if (!found) continue block25;
                    this.exit(token.getEndMark().getIndex());
                    continue block25;
                }
                case FlowSequenceStart: {
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    YamlAstNode node = new Collection.FlowSeq(currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex());
                    this.enterNode((NContainer)node);
                    this.checkForProblem(token.getStartMark(), node);
                    continue block25;
                }
                case FlowSequenceEnd: {
                    boolean found = this.exitTo(Collection.FlowSeq.class);
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    if (found) {
                        Collection.FlowSeq collection = (Collection.FlowSeq)currentNode;
                        collection.closeIndicatorOffset = token.getStartMark().getIndex();
                        this.exit(token.getEndMark().getIndex());
                        continue block25;
                    }
                    this.addChildTerm(new Dummy(69984, currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex()));
                    continue block25;
                }
                case FlowMappingStart: {
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    YamlAstNode node = new Collection.FlowMap(currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex());
                    this.enterNode((NContainer)node);
                    this.checkForProblem(token.getStartMark(), node);
                    continue block25;
                }
                case FlowMappingEnd: {
                    YamlAstNode node;
                    boolean found = this.exitTo(Collection.FlowMap.class);
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    if (found) {
                        node = (Collection.FlowMap)currentNode;
                        ((Collection.FlowMap)node).closeIndicatorOffset = token.getStartMark().getIndex();
                        this.exit(token.getEndMark().getIndex());
                        continue block25;
                    }
                    this.addChildTerm(new Dummy(69984, currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex()));
                    continue block25;
                }
                case BlockEntry: {
                    YamlAstNode node;
                    boolean found = this.exitTo1(Collection.BlockSeq.class);
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    if (found) {
                        node = (Collection.BlockSeq)currentNode;
                        continue block25;
                    }
                    node = new Collection.BlockSeq(currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex());
                    this.enterNode((NContainer)node);
                    this.checkForProblem(token.getStartMark(), node);
                    continue block25;
                }
                case FlowEntry: {
                    boolean found = this.exitTo1(Collection.FlowSeq.class, Collection.FlowMap.class);
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    if (found) continue block25;
                    this.addChildTerm(new Dummy(69991, currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex()));
                    continue block25;
                }
                case Anchor: {
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    YamlAstNode node = new Label.Anchor(currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex(), ((AliasToken)token).getValue());
                    this.addChildTerm(node);
                    this.checkForProblem(token.getStartMark(), node);
                    continue block25;
                }
                case Alias: {
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    YamlAstNode node = new Label.Reference(currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex(), ((AliasToken)token).getValue());
                    this.addChildTerm(node);
                    this.checkForProblem(token.getStartMark(), node);
                    continue block25;
                }
                case Key: {
                    boolean found = this.exitTo(NodeType.MAP);
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    YamlAstNode node = new Tuple(currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex());
                    if (!found) {
                        ((Tuple)node).status |= 0x11168;
                    }
                    this.enterNode((Tuple)node);
                    this.checkForProblem(token.getStartMark(), node);
                    if (node.getLength() <= 0) continue block25;
                    ((Tuple)node).keyIndicatorOffset = ((Tuple)node).startOffset;
                    continue block25;
                }
                case Value: {
                    YamlAstNode node;
                    boolean found = this.exitTo(NodeType.MAP_ENTRY, NodeType.MAP);
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    if (currentNode.getNodeType() == NodeType.MAP_ENTRY) {
                        node = (Tuple)currentNode;
                    } else {
                        node = new Tuple(currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex());
                        if (!found) {
                            ((Tuple)node).status |= 0x11169;
                        }
                        this.enterNode((Tuple)node);
                    }
                    this.checkForProblem(token.getStartMark(), node);
                    ((Tuple)node).valueIndicatorOffset = token.getStartMark().getIndex();
                    ((Tuple)node).endOffset = token.getEndMark().getIndex();
                    continue block25;
                }
                case Tag: {
                    TagTuple tagTuple = ((TagToken)token).getValue();
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    YamlAstNode node = new Tag(currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex(), tagTuple.getHandle(), tagTuple.getSuffix());
                    this.addChildTerm(node);
                    this.checkForProblem(token.getStartMark(), node);
                    continue block25;
                }
                case Scalar: {
                    YamlAstNode node;
                    ScalarToken scalarToken = (ScalarToken)token;
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    switch (scalarToken.getStyle()) {
                        case DOUBLE_QUOTED: {
                            node = new Scalar.DQuoted(currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex(), scalarToken.getValue());
                            break;
                        }
                        case SINGLE_QUOTED: {
                            node = new Scalar.SQuoated(currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex(), scalarToken.getValue());
                            break;
                        }
                        default: {
                            node = new Scalar.Plain(currentNode, token.getStartMark().getIndex(), token.getEndMark().getIndex(), scalarToken.getValue());
                        }
                    }
                    this.addChildTerm(node);
                    this.checkForProblem(token.getStartMark(), node);
                    continue block25;
                }
            }
        }
    }

    private void handleScannerProblem(ProblemInfo p) {
        if (p.contextMark == null) {
            if (p.problemMark != null && p.problemText != null) {
                switch (p.problemText.length() == 1 ? (int)p.problemText.charAt(0) : 0) {
                    case 37: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 58: 
                    case 62: 
                    case 63: 
                    case 124: {
                        this.addChildTerm(new Dummy(69984, this.currentNode, p.problemMark.getIndex(), p.problemMark.getIndex() + p.problemText.length()));
                        break;
                    }
                    default: {
                        this.addChildTerm(new Dummy(69968, this.currentNode, p.problemMark.getIndex(), p.problemMark.getIndex() + p.problemText.length()));
                        break;
                    }
                }
            }
        } else {
            this.keepProblem(p);
        }
    }

    private void keepProblem(ProblemInfo p) {
        int contextIndex = p.contextMark.getIndex();
        int idx = this.problemInfos.size();
        while (idx > 0) {
            if (this.problemInfos.get(idx - 1).contextMark.getIndex() <= contextIndex) break;
            --idx;
        }
        this.problemInfos.add(idx, p);
    }

    private void clearProblems(int contextIndex) {
        int idx = 0;
        while (idx < this.problemInfos.size()) {
            if (this.problemInfos.get(idx).contextMark.getIndex() >= contextIndex) break;
            ++idx;
        }
        if (idx > 1) {
            if (idx == 2) {
                this.problemInfos.remove(0);
            } else {
                this.problemInfos.subList(0, idx - 1).clear();
            }
        }
    }

    private void checkForProblem(Mark startMark, YamlAstNode node) {
        int contextIndex = startMark.getIndex();
        int idx = 0;
        while (idx < this.problemInfos.size()) {
            ProblemInfo p = this.problemInfos.get(idx);
            if (p.contextMark == startMark && this.attachProblem(node, p)) {
                this.problemInfos.remove(idx);
                continue;
            }
            if (p.contextMark.getIndex() > contextIndex) break;
            ++idx;
        }
    }

    private boolean attachProblem(YamlAstNode node, ProblemInfo p) {
        if (node.getStatusCode() != 0) {
            return false;
        }
        switch (p.problem) {
            case 1: 
            case 2: {
                if (p.problemMark == null || p.problemMark.getIndex() < node.getStartOffset() || p.problemMark.getIndex() >= node.getEndOffset() || p.problemText == null) break;
                node.status = 69936;
                node.addAttachment(new StatusDetail(p.problemMark.getIndex(), p.problemText.length(), p.problemText));
                return true;
            }
            case 3: {
                if (node.getNodeType() != NodeType.SCALAR) break;
                node.status = 69920;
                if (p.problemMark != null && p.problemText != null) {
                    node.addAttachment(new StatusDetail(p.problemMark.getIndex() - 1, p.problemText.length() + 1, String.valueOf('\\') + p.problemText));
                }
                return true;
            }
            case 4: {
                if (node.getNodeType() != NodeType.SCALAR) break;
                node.status = 69904;
                return true;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                if (((Object)((Object)node)).getClass() != Collection.BlockSeq.class) break;
                node.status = 69991;
                return true;
            }
            case 19: {
                if (node.getNodeType() == NodeType.MAP_ENTRY) {
                    node.status = 69992;
                    return true;
                }
                if (node.getYamlParent() == null || node.getYamlParent().getNodeType() != NodeType.MAP_ENTRY || node.getYamlParent().getStatusCode() != 0) break;
                node.getYamlParent().status = 69992;
                return true;
            }
            case 20: {
                if (node.getNodeType() == NodeType.MAP_ENTRY) {
                    node.status = 69993;
                    return true;
                }
                if (node.getYamlParent() == null || node.getYamlParent().getNodeType() != NodeType.MAP_ENTRY || node.getYamlParent().getStatusCode() != 0) break;
                node.getYamlParent().status = 69993;
                return true;
            }
        }
        return false;
    }

    private static class ProblemInfo {
        private final @Nullable Mark contextMark;
        private final byte problem;
        private final @Nullable Mark problemMark;
        private final @Nullable String problemText;

        public ProblemInfo(byte context, @Nullable Mark contextMark, byte problem, @Nullable Mark problemMark, @Nullable String problemText) {
            this.contextMark = contextMark;
            this.problem = problem;
            this.problemMark = problemMark;
            this.problemText = problemText;
        }
    }
}

