/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.ui.editors;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextModel;
import org.eclipse.statet.docmlet.wikitext.ui.editors.WikitextEditorBuild;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceProblemAnnotation;
import org.eclipse.statet.r.ui.editors.REditorBuild;
import org.eclipse.statet.redocs.wikitext.r.core.model.WikidocRweaveSourceUnit;

@NonNullByDefault
public class WikidocRweaveDocumentProvider
extends SourceDocumentProvider<WikidocRweaveSourceUnit>
implements Disposable {
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SettingsChangeNotifier.ChangeListener editorPrefListener = new SettingsChangeNotifier.ChangeListener(){

        public void settingsChanged(Set<String> groupIds) {
            if (groupIds.contains("r/r.editor/build.options") || groupIds.contains("Wikitext/editor/build")) {
                WikidocRweaveDocumentProvider.this.updateEditorPrefs();
            }
        }
    };
    private boolean handleTemporaryDocProblems;
    private boolean handleTemporaryRProblems;

    public WikidocRweaveDocumentProvider() {
        super("WikidocRweave", null);
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener(this.editorPrefListener);
        PreferenceAccess access = PreferenceUtils.getInstancePrefs();
        this.handleTemporaryDocProblems = (Boolean)access.getPreferenceValue((Preference)WikitextEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        this.handleTemporaryRProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
    }

    public void dispose() {
        if (this.editorPrefListener != null) {
            PreferencesUtil.getSettingsChangeNotifier().removeChangeListener(this.editorPrefListener);
            this.editorPrefListener = null;
        }
    }

    private void updateEditorPrefs() {
        PreferenceAccess access = PreferenceUtils.getInstancePrefs();
        boolean newHandleTemporaryDocProblems = (Boolean)access.getPreferenceValue((Preference)WikitextEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        boolean newHandleTemporaryRProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        if (this.handleTemporaryDocProblems != newHandleTemporaryDocProblems || this.handleTemporaryRProblems != newHandleTemporaryRProblems) {
            boolean enabled = this.handleTemporaryDocProblems != newHandleTemporaryDocProblems && newHandleTemporaryDocProblems || this.handleTemporaryRProblems != newHandleTemporaryRProblems && newHandleTemporaryRProblems;
            this.handleTemporaryDocProblems = newHandleTemporaryRProblems;
            this.handleTemporaryRProblems = newHandleTemporaryRProblems;
            if (enabled) {
                WikitextModel.getWikidocModelManager().refresh(Ltk.EDITOR_CONTEXT);
            } else {
                Object mode = !this.handleTemporaryDocProblems ? (!this.handleTemporaryRProblems ? null : "Wikidoc") : "R";
                List sus = LtkModels.getSourceUnitManager().getOpenSourceUnits("R", Ltk.EDITOR_CONTEXT);
                for (SourceUnit su : sus) {
                    IAnnotationModel model = this.getAnnotationModel(su);
                    if (!(model instanceof ThisAnnotationModel)) continue;
                    ((ThisAnnotationModel)model).clearProblems((String)mode);
                }
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new ThisAnnotationModel((IResource)file);
    }

    private class ThisAnnotationModel
    extends SourceAnnotationModel {
        public ThisAnnotationModel(IResource resource) {
            super(resource);
        }

        protected boolean isHandlingTemporaryProblems() {
            return WikidocRweaveDocumentProvider.this.handleTemporaryDocProblems;
        }

        protected boolean isHandlingTemporaryRProblems() {
            return WikidocRweaveDocumentProvider.this.handleTemporaryRProblems;
        }

        protected ProblemRequestor doCreateProblemRequestor() {
            return new ThisProblemRequestor();
        }

        protected @Nullable SourceProblemAnnotation createAnnotation(Problem problem) {
            if (problem.getCategoryId() == "R") {
                switch (problem.getSeverity()) {
                    case 2: {
                        return new SourceProblemAnnotation("org.eclipse.statet.r.ui.error", problem, SourceProblemAnnotation.ERROR_CONFIG);
                    }
                    case 1: {
                        return new SourceProblemAnnotation("org.eclipse.statet.r.ui.warning", problem, SourceProblemAnnotation.WARNING_CONFIG);
                    }
                }
                return new SourceProblemAnnotation("org.eclipse.statet.r.ui.info", problem, SourceProblemAnnotation.INFO_CONFIG);
            }
            if (problem.getCategoryId() == "Wikidoc") {
                switch (problem.getSeverity()) {
                    case 2: {
                        return new SourceProblemAnnotation("org.eclipse.statet.docmlet.wikitext.ui.error", problem, SourceProblemAnnotation.ERROR_CONFIG);
                    }
                    case 1: {
                        return new SourceProblemAnnotation("org.eclipse.statet.docmlet.wikitext.ui.warning", problem, SourceProblemAnnotation.WARNING_CONFIG);
                    }
                }
                return new SourceProblemAnnotation("org.eclipse.statet.docmlet.wikitext.ui.info", problem, SourceProblemAnnotation.INFO_CONFIG);
            }
            if (problem.getCategoryId() == "Yaml") {
                switch (problem.getSeverity()) {
                    case 2: {
                        return new SourceProblemAnnotation("org.eclipse.statet.yaml.ui.error", problem, SourceProblemAnnotation.ERROR_CONFIG);
                    }
                    case 1: {
                        return new SourceProblemAnnotation("org.eclipse.statet.yaml.ui.warning", problem, SourceProblemAnnotation.WARNING_CONFIG);
                    }
                }
                return new SourceProblemAnnotation("org.eclipse.statet.yaml.ui.info", problem, SourceProblemAnnotation.INFO_CONFIG);
            }
            return null;
        }

        private class ThisProblemRequestor
        extends SourceAnnotationModel.SourceAnnotationProblemRequestor {
            private final boolean handleTemporaryRProblems;

            public ThisProblemRequestor() {
                super((SourceAnnotationModel)ThisAnnotationModel.this);
                this.handleTemporaryRProblems = ThisAnnotationModel.this.isHandlingTemporaryRProblems();
            }

            public void acceptProblems(Problem problem) {
                if (problem.getCategoryId() == "R") {
                    if (this.handleTemporaryRProblems) {
                        this.reportedProblems.add(problem);
                    }
                } else if (this.handleTemporaryProblems) {
                    this.reportedProblems.add(problem);
                }
            }

            public void acceptProblems(String modelTypeId, List<Problem> problems) {
                if (modelTypeId == "R") {
                    if (this.handleTemporaryRProblems) {
                        this.reportedProblems.addAll(problems);
                    }
                } else if (this.handleTemporaryProblems) {
                    this.reportedProblems.addAll(problems);
                }
            }
        }
    }
}

