/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.wizards.Messages;
import org.eclipse.statet.internal.r.ui.wizards.NewRdFileCreationWizardPage;
import org.eclipse.statet.ltk.ui.templates.TemplateUtils;
import org.eclipse.statet.ltk.ui.wizards.NewElementWizard;
import org.eclipse.statet.ltk.ui.wizards.NewElementWizardPage;
import org.eclipse.statet.r.codegeneration.CodeGeneration;
import org.eclipse.statet.r.core.BasicRResourceSourceUnit;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public class NewRdFileCreationWizard
extends NewElementWizard {
    private NewRdFileCreationWizardPage firstPage;
    private NewElementWizard.NewFile newRdFile;

    public NewRdFileCreationWizard() {
        this.setDialogSettings(DialogUtils.getDialogSettings((AbstractUIPlugin)RUIPlugin.getInstance(), (String)"NewElementWizard"));
        this.setDefaultPageImageDescriptor(RUI.getImageDescriptor("org.eclipse.statet.r.ui/image/wizban/new.rd-file"));
        this.setWindowTitle(Messages.NewRDocFileWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.firstPage = new NewRdFileCreationWizardPage(this.getSelection());
        this.addPage((IWizardPage)this.firstPage);
    }

    protected ISchedulingRule getSchedulingRule() {
        ISchedulingRule rule = this.createRule((IResource)this.newRdFile.getResource());
        if (rule != null) {
            return rule;
        }
        return super.getSchedulingRule();
    }

    public boolean performFinish() {
        NewElementWizardPage.ResourceGroup resourceGroup = this.firstPage.getResourceGroup();
        this.newRdFile = new NewRdFile(resourceGroup.getContainerFullPath(), resourceGroup.getResourceName());
        boolean result = super.performFinish();
        if (result && this.newRdFile.getResource() != null) {
            this.selectAndReveal((IResource)this.newRdFile.getResource());
            this.openResource(this.newRdFile);
        }
        return result;
    }

    protected void performOperations(IProgressMonitor monitor) throws InterruptedException, CoreException, InvocationTargetException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create new Rd file...", (int)11);
        this.newRdFile.createFile((IProgressMonitor)m.newChild(10));
        this.firstPage.saveSettings();
        m.worked(1);
    }

    private static class NewRdFile
    extends NewElementWizard.NewFile {
        public NewRdFile(IPath containerPath, String resourceName) {
            super(containerPath, resourceName, RCore.RD_CONTENT_TYPE);
        }

        protected String getInitialFileContent(IFile newFileHandle, SubMonitor progress) {
            String lineDelimiter = TextUtil.getLineDelimiter((IProject)newFileHandle.getProject());
            try {
                BasicRResourceSourceUnit rcu = BasicRResourceSourceUnit.createTempUnit((IFile)newFileHandle, (String)"rd");
                TemplateUtils.EvaluatedTemplate data = CodeGeneration.getNewRdFileContent(rcu, lineDelimiter);
                if (data != null) {
                    this.initialSelection = data.getRegionToSelect();
                    return data.getContent();
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, "An error occured when applying template to new Rd file.", (Throwable)e));
            }
            return null;
        }
    }
}

