/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.r.ui.correction.RLinkedNamesAssistProposal;
import org.eclipse.statet.internal.r.ui.correction.RenameInRegionAssistProposal;
import org.eclipse.statet.internal.r.ui.correction.RenameInWorkspaceAssistProposal;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.QuickAssistComputer;
import org.eclipse.statet.r.core.model.RCompositeSourceElement;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RLangSourceElement;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

@NonNullByDefault
public class RQuickRefactoringComputer
implements QuickAssistComputer {
    public void computeAssistProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        block8: {
            if (!(context.getAstSelection().getCovering() instanceof RAstNode)) {
                return;
            }
            RAstNode node = (RAstNode)context.getAstSelection().getCovering();
            if (node.getNodeType() == NodeType.SYMBOL || node.getNodeType() == NodeType.STRING_CONST) {
                RAstNode candidate = node;
                while (candidate != null) {
                    ImList attachments = candidate.getAttachments();
                    block1: for (Object attachment : attachments) {
                        if (!(attachment instanceof RElementAccess)) continue;
                        RElementAccess access = (RElementAccess)attachment;
                        while (access != null) {
                            if (access.getSegmentName() == null) continue block1;
                            if (access.getNameNode() == node) {
                                this.addAccessAssistProposals(context, access, proposals);
                                break block8;
                            }
                            access = access.getNextSegment();
                        }
                    }
                    candidate = candidate.getRParent();
                }
            } else if (context.getLength() > 0 && context.getSourceUnit() instanceof RSourceUnit) {
                proposals.add((AssistProposal)new RenameInRegionAssistProposal(context));
            }
        }
    }

    protected void addAccessAssistProposals(AssistInvocationContext context, RElementAccess access, AssistProposalCollector proposals) {
        RAstNode accessNameNode = access.getNameNode();
        if (accessNameNode == null) {
            return;
        }
        ImIdentityList allAccess = ImCollections.toIdentityList((Collection)access.getAllInUnit(false));
        int current = allAccess.indexOf((Object)access);
        if (current < 0) {
            return;
        }
        proposals.add((AssistProposal)new RLinkedNamesAssistProposal(1, context, access));
        if (allAccess.size() > 1) {
            List elements;
            RLangSourceElement element;
            TextRegion chunk = null;
            SourceStructElement sourceElement = context.getModelInfo().getSourceElement();
            if (sourceElement instanceof RCompositeSourceElement && (element = (RLangSourceElement)LtkModelUtils.getCoveringSourceElement((List)(elements = ((RCompositeSourceElement)sourceElement).getCompositeElements()), (int)accessNameNode.getStartOffset())) != null) {
                chunk = element.getSourceRange();
            }
            proposals.add((AssistProposal)new RLinkedNamesAssistProposal(2, context, access));
            proposals.add((AssistProposal)new RLinkedNamesAssistProposal(3, context, access));
            if (chunk != null) {
                int chunkBegin = 0;
                int offset = chunk.getStartOffset();
                while (chunkBegin < current) {
                    RAstNode nameNode = ((RElementAccess)allAccess.get(chunkBegin)).getNameNode();
                    if (nameNode != null && offset <= nameNode.getStartOffset()) break;
                    ++chunkBegin;
                }
                int chunkEnd = current + 1;
                int offset2 = chunk.getEndOffset();
                while (chunkEnd < allAccess.size()) {
                    RAstNode nameNode = ((RElementAccess)allAccess.get(chunkEnd)).getNameNode();
                    if (nameNode != null && offset2 <= nameNode.getStartOffset()) break;
                    ++chunkEnd;
                }
                if (chunkEnd - chunkBegin > 1) {
                    proposals.add((AssistProposal)new RLinkedNamesAssistProposal(4, context, access, chunk));
                }
            }
        }
        if (context.getSourceUnit() instanceof RWorkspaceSourceUnit) {
            proposals.add((AssistProposal)new RenameInWorkspaceAssistProposal(context, access.getNameNode()));
        }
    }
}

