/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.ui.RUIMessages;
import org.eclipse.statet.ltk.model.core.element.SourceDocumentRunnable;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAssociated;
import org.eclipse.statet.ltk.ui.templates.TemplateUtils;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.statet.r.codegeneration.CodeGeneration;
import org.eclipse.statet.r.core.model.RLangClass;
import org.eclipse.statet.r.core.model.RLangMethod;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.refactoring.RRefactoring;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class GenerateRoxygenElementComment
extends AbstractHandler
implements IElementUpdater {
    public void updateElement(UIElement element, Map parameters) {
        WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
        try {
            element.setText(RUIMessages.GenerateRoxygenElementComment_label);
        }
        finally {
            WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        int selectionLength;
        int selectionStart;
        MultiTextEdit multi;
        AbstractDocument doc;
        ISourceEditor editor;
        IWorkbenchWindow workbenchWindow;
        SourceUnitModelInfo info;
        SourceUnit su;
        block29: {
            if (!(event.getApplicationContext() instanceof IEvaluationContext)) {
                return null;
            }
            SubMonitor m = SubMonitor.convert(null, (int)2);
            su = null;
            SourceStructElement[] elements = null;
            info = null;
            IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
            ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)context);
            workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            IWorkbenchPart part = (IWorkbenchPart)context.getVariable("activePart");
            if (selection instanceof IStructuredSelection) {
                ISourceEditorAssociated associated;
                elements = LTKSelectionUtils.getSelectedSourceStructElements((IStructuredSelection)((IStructuredSelection)selection));
                if (elements != null && elements.length > 0) {
                    su = elements[0].getSourceUnit();
                    int i = 0;
                    while (i < elements.length) {
                        if (elements[i].getSourceUnit() != su) {
                            return null;
                        }
                        ++i;
                    }
                    info = su.getModelInfo("R", 2, (IProgressMonitor)m.newChild(1));
                }
                editor = (associated = (ISourceEditorAssociated)part.getAdapter(ISourceEditorAssociated.class)) != null ? associated.getSourceEditor() : null;
            } else if (selection instanceof ITextSelection) {
                editor = (ISourceEditor)part.getAdapter(ISourceEditor.class);
                if (editor != null && (su = editor.getSourceUnit()) != null) {
                    info = su.getModelInfo("R", 2, (IProgressMonitor)m.newChild(1));
                    elements = LTKSelectionUtils.getSelectedSourceStructElement((SourceUnitModelInfo)info, (ITextSelection)((ITextSelection)selection));
                }
            } else {
                editor = null;
            }
            if (su == null || elements == null || elements.length == 0 || !(su instanceof RSourceUnit)) {
                return null;
            }
            if (!su.checkState(true, (IProgressMonitor)new NullProgressMonitor())) {
                return false;
            }
            RSourceUnit rsu = (RSourceUnit)su;
            doc = su.getDocument(null);
            TemplateUtils.EvaluatedTemplate[] templates = new TemplateUtils.EvaluatedTemplate[elements.length];
            String lineDelimiter = doc.getDefaultLineDelimiter();
            Arrays.sort(elements, RRefactoring.getFactory().createAdapter((Object)elements).getModelElementComparator());
            int i = 0;
            while (i < elements.length) {
                block2 : switch (elements[i].getElementType() & 0xF00) {
                    case 1024: {
                        templates[i] = CodeGeneration.getClassRoxygenComment((RLangClass)elements[i], lineDelimiter);
                        break;
                    }
                    case 1280: {
                        switch (elements[i].getElementType() & 0xFF0) {
                            case 1408: {
                                templates[i] = CodeGeneration.getMethodRoxygenComment((RLangMethod)elements[i], lineDelimiter);
                                break block2;
                            }
                        }
                        templates[i] = CodeGeneration.getCommonFunctionRoxygenComment((RLangMethod)elements[i], lineDelimiter);
                    }
                }
                ++i;
            }
            IndentUtil indentUtil = new IndentUtil((IDocument)doc, (IIndentSettings)rsu.getRCoreAccess().getRCodeStyle());
            multi = new MultiTextEdit();
            selectionStart = 0;
            selectionLength = 0;
            boolean first = true;
            int i2 = 0;
            while (i2 < elements.length) {
                if (templates[i2] != null) {
                    int line = doc.getLineOfOffset(elements[i2].getSourceRange().getStartOffset());
                    String lineIndent = indentUtil.copyLineIndent(line);
                    AbstractDocument templateDoc = templates[i2].startPostEdit();
                    TemplateUtils.indentTemplateDocument((AbstractDocument)templateDoc, (String)lineIndent);
                    templates[i2].finishPostEdit();
                    int lineOffset = doc.getLineOffset(line);
                    multi.addChild((TextEdit)new InsertEdit(lineOffset, templates[i2].getContent()));
                    if (first) {
                        first = false;
                        selectionStart = doc.getLineOffset(line);
                        IRegion templateSelection = templates[i2].getRegionToSelect();
                        if (templateSelection != null) {
                            selectionStart += templateSelection.getOffset();
                            selectionLength = templateSelection.getLength();
                        } else {
                            selectionStart += lineIndent.length();
                        }
                    }
                }
                ++i2;
            }
            if (!first) break block29;
            return null;
        }
        try {
            IFile resource = (IFile)su.getResource();
            Region initialSelection = new Region(selectionStart, selectionLength);
            su.syncExec(new SourceDocumentRunnable(doc, info.getStamp().getContentStamp(), DocumentRewriteSessionType.SEQUENTIAL, (IRegion)initialSelection, resource, workbenchWindow){
                private final /* synthetic */ IRegion val$initialSelection;
                private final /* synthetic */ IFile val$resource;
                private final /* synthetic */ IWorkbenchWindow val$workbenchWindow;
                {
                    this.val$initialSelection = iRegion;
                    this.val$resource = iFile;
                    this.val$workbenchWindow = iWorkbenchWindow;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void run() throws InvocationTargetException {
                    try {
                        multi.apply((IDocument)this.getDocument(), 0);
                        if (editor != null) {
                            editor.getViewer().setSelectedRange(this.val$initialSelection.getOffset(), this.val$initialSelection.getLength());
                        } else if (this.val$resource != null) {
                            LTKWorkbenchUIUtil.openEditor((IWorkbenchPage)this.val$workbenchWindow.getActivePage(), (IFile)this.val$resource, (IRegion)this.val$initialSelection);
                        }
                    }
                    catch (MalformedTreeException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (BadLocationException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException(RUIMessages.GenerateRoxygenElementComment_error_message, e.getCause());
        }
        catch (BadLocationException e) {
            throw new ExecutionException(RUIMessages.GenerateRoxygenElementComment_error_message, (Throwable)e);
        }
        catch (CoreException e) {
            throw new ExecutionException(RUIMessages.GenerateRoxygenElementComment_error_message, (Throwable)e);
        }
        return null;
    }
}

