/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.internal.r.debug.ui.RDebugUIPlugin;
import org.eclipse.statet.ltk.core.input.SourceFragment;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceFragmentEditorInput;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.r.debug.core.sourcelookup.RRuntimeSourceFragment;
import org.eclipse.ui.IPersistableElement;

public class RRuntimeSourceEditorInput
implements ISourceFragmentEditorInput {
    private final RRuntimeSourceFragment fragment;

    public RRuntimeSourceEditorInput(RRuntimeSourceFragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("fragment");
        }
        this.fragment = fragment;
    }

    public SourceFragment getSourceFragment() {
        return this.fragment;
    }

    public ImageDescriptor getImageDescriptor() {
        return RDebugUIPlugin.getInstance().getImageRegistry().getDescriptor("org.eclipse.statet.r.images/obj/r_source.runtime");
    }

    public String getName() {
        return this.fragment.getName();
    }

    public boolean exists() {
        return !this.fragment.getProcess().isTerminated();
    }

    public String getToolTipText() {
        return String.valueOf(this.fragment.getFullName()) + '\n' + this.fragment.getProcess().getLabel(1);
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == ToolProcess.class) {
            return (T)this.fragment.getProcess();
        }
        return null;
    }

    public int hashCode() {
        return this.fragment.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RRuntimeSourceEditorInput)) {
            return false;
        }
        RRuntimeSourceEditorInput other = (RRuntimeSourceEditorInput)obj;
        return this.fragment.equals((Object)other.fragment);
    }

    public String toString() {
        return String.valueOf(this.fragment.getFullName()) + " - " + this.fragment.getProcess().getLabel(1);
    }
}

