/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.r.core.rsource.ast.Arithmetic;
import org.eclipse.statet.r.core.rsource.ast.Assignment;
import org.eclipse.statet.r.core.rsource.ast.Block;
import org.eclipse.statet.r.core.rsource.ast.CForLoop;
import org.eclipse.statet.r.core.rsource.ast.CIfElse;
import org.eclipse.statet.r.core.rsource.ast.CRepeatLoop;
import org.eclipse.statet.r.core.rsource.ast.CWhileLoop;
import org.eclipse.statet.r.core.rsource.ast.Dummy;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.FDef;
import org.eclipse.statet.r.core.rsource.ast.Group;
import org.eclipse.statet.r.core.rsource.ast.Help;
import org.eclipse.statet.r.core.rsource.ast.Logical;
import org.eclipse.statet.r.core.rsource.ast.Model;
import org.eclipse.statet.r.core.rsource.ast.NSGet;
import org.eclipse.statet.r.core.rsource.ast.NumberConst;
import org.eclipse.statet.r.core.rsource.ast.Power;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.Relational;
import org.eclipse.statet.r.core.rsource.ast.Seq;
import org.eclipse.statet.r.core.rsource.ast.Sign;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.statet.r.core.rsource.ast.Special;
import org.eclipse.statet.r.core.rsource.ast.StringConst;
import org.eclipse.statet.r.core.rsource.ast.SubIndexed;
import org.eclipse.statet.r.core.rsource.ast.SubNamed;
import org.eclipse.statet.r.core.rsource.ast.Symbol;

class RScannerPostExprVisitor
extends RAstVisitor {
    static final int SYNTAXERROR_MASK = 0x1010000;
    private boolean syntaxError;

    RScannerPostExprVisitor() {
    }

    public int check(RAstNode node) {
        this.syntaxError = false;
        try {
            node.acceptInR(this);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.syntaxError) {
            return 0x1000000;
        }
        return 0;
    }

    public int checkTerminal(RAstNode node) {
        if ((node.getStatusCode() & 0x1010000) != 0) {
            return 0x1000000;
        }
        return 0;
    }

    private void doAcceptIn(RAstNode child) throws InvocationTargetException {
        boolean savedSyntaxError = this.syntaxError;
        this.syntaxError = false;
        child.acceptInR(this);
        if (this.syntaxError) {
            child.rParent.status |= 0x1000000;
        }
        this.syntaxError |= savedSyntaxError;
    }

    private void doAccecptInChildren(RAstNode node) throws InvocationTargetException {
        boolean savedSyntaxError = this.syntaxError;
        this.syntaxError = false;
        node.acceptInRChildren(this);
        if (this.syntaxError) {
            node.status |= 0x1000000;
        }
        this.syntaxError |= savedSyntaxError;
    }

    @Override
    public void visit(SourceComponent node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Block node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Group node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(CIfElse node) throws InvocationTargetException {
        if (node.withElse) {
            this.doAcceptIn(node.elseExpr.node);
        }
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(CForLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(CRepeatLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(CWhileLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(FCall node) throws InvocationTargetException {
        this.doAcceptIn(node.refExpr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(FCall.Args node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(FCall.Arg node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(FDef node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(FDef.Args node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(FDef.Arg node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Assignment node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Model node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Relational node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Logical node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Arithmetic node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Power node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Seq node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Special node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Sign node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(SubIndexed node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(SubIndexed.Args node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(SubIndexed.Arg node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(SubNamed node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(NSGet node) throws InvocationTargetException {
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(StringConst node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(NumberConst node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Symbol node) {
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Help node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }

    @Override
    public void visit(Dummy node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x1010000) != 0;
    }
}

