/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.Objects;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.ui.viewers.ViewerLabelUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public abstract class ElementNameCompletionProposal<TContext extends AssistInvocationContext, TElement extends LtkModelElement>
extends SourceProposal<TContext>
implements ICompletionProposalExtension3,
ICompletionProposalExtension6 {
    private final ElementName replacementName;
    private final TElement element;
    private final ElementLabelProvider labelProvider;

    public ElementNameCompletionProposal(SourceProposal.ProposalParameters<? extends TContext> parameters, ElementName replacementName, TElement element, ElementLabelProvider labelProvider) {
        super(parameters);
        this.replacementName = replacementName;
        this.element = element;
        this.labelProvider = labelProvider;
    }

    public final TElement getElement() {
        return this.element;
    }

    public ElementName getReplacementName() {
        return this.replacementName;
    }

    @Override
    protected String getName() {
        return this.getReplacementName().getDisplayName();
    }

    @Override
    protected String getValidationName() {
        return this.getReplacementName().getSegmentName();
    }

    @Override
    public String getSortingString() {
        return this.getReplacementName().getSegmentName();
    }

    protected final ElementLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public String getDisplayString() {
        return this.element != null ? this.labelProvider.getText((LtkModelElement)this.element) : this.getReplacementName().getDisplayName();
    }

    @Override
    public StyledString computeStyledText() {
        return this.element != null ? this.labelProvider.getStyledText((LtkModelElement)this.element) : new StyledString(this.getDisplayString());
    }

    @Override
    protected void styleMatchingRegions(StyledString styledText, int matchRule, int[] matchingRegions, BoldStylerProvider boldStylerProvider) {
        matchingRegions = this.element != null ? this.labelProvider.getStyledTextRegions((LtkModelElement)this.element, 0, matchingRegions) : this.getReplacementName().correctDisplayNameRegions(matchingRegions, 0);
        ViewerLabelUtils.setStyle((StyledString)styledText, (int[])matchingRegions, (StyledString.Styler)boldStylerProvider.getBoldStyler());
    }

    @Override
    public Image getImage() {
        return this.element != null ? this.labelProvider.getImage((LtkModelElement)this.element) : super.getImage();
    }

    public int hashCode() {
        return this.getClass().hashCode() * Objects.hashCode(this.getReplacementName());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            ElementNameCompletionProposal other = (ElementNameCompletionProposal)obj;
            return Objects.equals(this.getReplacementName(), other.getReplacementName()) && Objects.equals(this.getElement(), other.getElement());
        }
        return false;
    }
}

