/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.buildpath.core;

import java.util.Objects;
import org.eclipse.core.runtime.IPath;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.buildpath.core.BuildpathAttribute;
import org.eclipse.statet.ltk.buildpath.core.BuildpathElement;
import org.eclipse.statet.ltk.buildpath.core.BuildpathElementType;
import org.eclipse.statet.ltk.buildpath.core.BuildpathUtils;

@NonNullByDefault
public class BasicBuildpathElement
implements BuildpathElement {
    private static final ImList<String> UNINITIALIZED_PATTERNS = ImCollections.newList((Object)"UNINITIALIZED_PATTERNS");
    private final BuildpathElementType type;
    private final IPath path;
    private final @Nullable ImList<IPath> inclusionPatterns;
    private volatile @Nullable ImList<String> fullInclusionPatterns;
    private final @Nullable ImList<IPath> exclusionPatterns;
    private volatile @Nullable ImList<String> fullExclusionPatterns;
    private final @Nullable IPath sourceAttachmentPath;
    private final @Nullable IPath sourceAttachmentRootPath;
    private final @Nullable BuildpathElement referencingElement;
    private final @Nullable IPath specificOutputPath;
    private final boolean isExported;
    private final ImList<BuildpathAttribute> extraAttributes;

    public BasicBuildpathElement(BuildpathElementType type, IPath path, @Nullable ImList<IPath> inclusionPatterns, @Nullable ImList<IPath> exclusionPatterns, @Nullable IPath sourceAttachmentPath, @Nullable IPath sourceAttachmentRootPath, @Nullable IPath specificOutputLocation, @Nullable BuildpathElement referencingEntry, boolean isExported, @Nullable ImList<BuildpathAttribute> extraAttributes) {
        this.type = (BuildpathElementType)ObjectUtils.nonNullAssert((Object)type);
        this.path = (IPath)ObjectUtils.nonNullAssert((Object)path);
        this.inclusionPatterns = inclusionPatterns;
        this.fullInclusionPatterns = UNINITIALIZED_PATTERNS;
        this.exclusionPatterns = exclusionPatterns;
        this.fullExclusionPatterns = UNINITIALIZED_PATTERNS;
        this.referencingElement = referencingEntry;
        this.sourceAttachmentPath = sourceAttachmentPath;
        this.sourceAttachmentRootPath = sourceAttachmentRootPath;
        this.specificOutputPath = specificOutputLocation;
        this.isExported = isExported;
        this.extraAttributes = extraAttributes != null ? extraAttributes : ImCollections.emptyList();
    }

    @Override
    public final BuildpathElementType getType() {
        return this.type;
    }

    @Override
    public final String getTypeName() {
        return this.type.getName();
    }

    @Override
    public final IPath getPath() {
        return this.path;
    }

    @Override
    public final @Nullable ImList<IPath> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    @Override
    public final @Nullable ImList<IPath> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    private @Nullable ImList<String> createFullPatterns(@Nullable ImList<IPath> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return null;
        }
        int length = patterns.size();
        Object[] fullPatterns = new String[length];
        IPath prefixPath = this.path.removeTrailingSeparator();
        int i = 0;
        while (i < length) {
            fullPatterns[i] = prefixPath.append((IPath)patterns.get(i)).toString();
            ++i;
        }
        return ImCollections.newList((Object[])fullPatterns);
    }

    public @Nullable ImList<String> getFullInclusionPatterns() {
        ImList<String> patterns = this.fullInclusionPatterns;
        if (patterns == UNINITIALIZED_PATTERNS) {
            patterns = this.fullInclusionPatterns = this.createFullPatterns(this.inclusionPatterns);
        }
        return patterns;
    }

    public @Nullable ImList<String> getFullExclusionPatterns() {
        ImList<String> patterns = this.fullExclusionPatterns;
        if (patterns == UNINITIALIZED_PATTERNS) {
            patterns = this.fullExclusionPatterns = this.createFullPatterns(this.exclusionPatterns);
        }
        return patterns;
    }

    @Override
    public @Nullable IPath getOutputPath() {
        return this.specificOutputPath;
    }

    @Override
    public ImList<BuildpathAttribute> getExtraAttributes() {
        return this.extraAttributes;
    }

    public @Nullable BuildpathAttribute getAttribute(String name) {
        for (BuildpathAttribute attribute : this.extraAttributes) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public @Nullable IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    public @Nullable IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public @Nullable BuildpathElement getReferencingEntry() {
        return this.referencingElement;
    }

    @Override
    public boolean isExported() {
        return this.isExported;
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.path.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BasicBuildpathElement) {
            BasicBuildpathElement other = (BasicBuildpathElement)obj;
            return this.type == other.type && this.isExported == other.isExported() && this.path.equals((Object)other.getPath()) && Objects.equals(this.sourceAttachmentPath, other.sourceAttachmentPath) && Objects.equals(this.getSourceAttachmentRootPath(), other.sourceAttachmentRootPath) && BuildpathUtils.equalPatterns(this.inclusionPatterns, other.getInclusionPatterns()) && BuildpathUtils.equalPatterns(this.exclusionPatterns, other.getExclusionPatterns()) && Objects.equals(this.specificOutputPath, other.specificOutputPath) && this.extraAttributes.equals(other.extraAttributes);
        }
        return false;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("BasicBuildpathElement");
        sb.append(" [");
        sb.append(this.type.getName());
        sb.append("]:");
        sb.append(this.getPath().toString());
        sb.addProp("including", this.getInclusionPatterns());
        sb.addProp("excluding", this.getExclusionPatterns());
        sb.addProp("sourcePath", (Object)this.getSourceAttachmentPath());
        IPath rootPath = this.getSourceAttachmentRootPath();
        if (rootPath != null) {
            sb.append(':');
            sb.append(rootPath.toString());
        }
        sb.addProp("outputPath", (Object)this.getOutputPath());
        sb.addProp("isExported", this.isExported);
        ImList<BuildpathAttribute> attributes = this.getExtraAttributes();
        if (!attributes.isEmpty()) {
            sb.addProp("extraAttributes", attributes);
        }
        return sb.toString();
    }
}

