/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport;

import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.coordinate.Direction;
import org.eclipse.statet.ecommons.waltable.viewport.IViewportDim;
import org.eclipse.statet.ecommons.waltable.viewport.ScrollStepCommand;
import org.eclipse.statet.ecommons.waltable.viewport.ViewportLayer;

public class ScrollStepCommandHandler
extends AbstractLayerCommandHandler<ScrollStepCommand> {
    private final ViewportLayer viewportLayer;

    public ScrollStepCommandHandler(ViewportLayer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<ScrollStepCommand> getCommandClass() {
        return ScrollStepCommand.class;
    }

    @Override
    protected boolean doCommand(ScrollStepCommand command) {
        Direction direction = command.getDirection();
        IViewportDim dim = this.viewportLayer.getDim(direction.getOrientation());
        if (direction.isBackward()) {
            dim.scrollBackwardByStep();
        } else {
            dim.scrollForwardByStep();
        }
        return true;
    }
}

