/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockNode;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockType;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ThematicBreakBlock
extends SourceBlockType<ThematicBreakNode> {
    private static final Pattern PATTERN = Pattern.compile("(?:\\*[ \t]*){3,}|(?:-[ \t]*){3,}|(?:_[ \t]*){3,}", 32);
    private final Matcher matcher = PATTERN.matcher("");

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockNode<?> currentNode) {
        return this.canStart(lineSequence.getCurrentLine());
    }

    public boolean canStart(@Nullable Line currentLine) {
        return currentLine != null && !currentLine.isBlank() && currentLine.getIndent() < 4 && currentLine.setupIndent(this.matcher).matches();
    }

    @Override
    public void createNodes(SourceBlocks.SourceBlockBuilder builder) {
        ThematicBreakNode node = new ThematicBreakNode(this, builder);
        builder.getLineSequence().advance();
    }

    @Override
    public void initializeContext(ProcessingContext context, ThematicBreakNode node) {
    }

    @Override
    public void emit(ProcessingContext context, ThematicBreakNode node, CommonmarkLocator locator, DocumentBuilder builder) {
        locator.setBlockBegin(node);
        builder.horizontalRule();
    }

    static final class ThematicBreakNode
    extends SourceBlockNode<ThematicBreakBlock> {
        private ThematicBreakNode(ThematicBreakBlock type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }
    }
}

