/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.style.IDisplayModeLookupStrategy;

public class DefaultDisplayModeOrdering
implements IDisplayModeLookupStrategy {
    private static final List<DisplayMode> NORMAL_ORDERING = Arrays.asList(DisplayMode.NORMAL);
    private static final List<DisplayMode> HOVER_ORDERING = Arrays.asList(DisplayMode.HOVER, DisplayMode.NORMAL);
    private static final List<DisplayMode> SELECT_ORDERING = Arrays.asList(DisplayMode.SELECT, DisplayMode.NORMAL);
    private static final List<DisplayMode> EDIT_ORDERING = Arrays.asList(DisplayMode.EDIT, DisplayMode.NORMAL);
    private static final List<DisplayMode> EMPTY_ORDERING = Collections.emptyList();

    @Override
    public List<DisplayMode> getDisplayModeOrdering(DisplayMode targetDisplayMode) {
        switch (targetDisplayMode) {
            case NORMAL: {
                return NORMAL_ORDERING;
            }
            case HOVER: {
                return HOVER_ORDERING;
            }
            case SELECT: {
                return SELECT_ORDERING;
            }
            case EDIT: {
                return EDIT_ORDERING;
            }
        }
        return EMPTY_ORDERING;
    }
}

