/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.sourceediting;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.ast.ControlNode;
import org.eclipse.statet.docmlet.tex.core.ast.Group;
import org.eclipse.statet.docmlet.tex.core.ast.Label;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAsts;
import org.eclipse.statet.docmlet.tex.core.ast.Text;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.source.LtxHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;

@NonNullByDefault
public class LtxAssistInvocationContext
extends AssistInvocationContext {
    private @Nullable LtxHeuristicTokenScanner scanner;
    private int invocationChecked;
    private @Nullable CommandCall invocationDirect;
    private @Nullable CommandCall invocationAny;

    public LtxAssistInvocationContext(ISourceEditor editor, int offset, String contentType, boolean isProposal, IProgressMonitor monitor) {
        super(editor, offset, contentType, isProposal ? 2 : 0, monitor);
    }

    public TexCoreAccess getTexCoreAccess() {
        SourceUnit sourceUnit = this.getSourceUnit();
        if (sourceUnit instanceof TexSourceUnit) {
            return ((TexSourceUnit)sourceUnit).getTexCoreAccess();
        }
        return TexCore.getWorkbenchAccess();
    }

    public final LtxHeuristicTokenScanner getLtxHeuristicTokenScanner() {
        LtxHeuristicTokenScanner scanner = this.scanner;
        if (scanner == null) {
            this.scanner = scanner = LtxHeuristicTokenScanner.create((DocContentSections)this.getEditor().getDocumentContentInfo());
        }
        return scanner;
    }

    protected String computeIdentifierPrefix(int offset) {
        IDocument document = this.getDocument();
        try {
            int start = offset;
            block6: while (offset > 0) {
                char c = document.getChar(offset - 1);
                switch (c) {
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        start = --offset;
                        break;
                    }
                    case '\\': {
                        start = offset;
                        do {
                            if (--offset > 0 && document.getChar(offset - 1) == '\\') continue;
                            --start;
                            break block6;
                        } while (--offset > 0 && document.getChar(offset - 1) == '\\');
                        break block6;
                    }
                    default: {
                        break block6;
                    }
                }
            }
            return document.get(start, this.getInvocationOffset() - start);
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    /*
     * Unable to fully structure code
     */
    private @Nullable CommandCall searchCommandCall(boolean direct) {
        block6: {
            block7: {
                if (!(this.getAstSelection().getCovering() instanceof TexAstNode)) break block6;
                texNode = (TexAstNode)this.getAstSelection().getCovering();
                if (!direct) ** GOTO lbl8
                if (!(texNode instanceof Label) && !(texNode instanceof Text)) break block7;
                texNode = texNode.getTexParent();
                break block7;
lbl-1000:
                // 1 sources

                {
                    texNode = texNode.getTexParent();
lbl8:
                    // 2 sources

                    ** while (texNode != null && !(texNode instanceof Group))
                }
            }
            if (texNode instanceof Group && texNode.getParent() instanceof ControlNode && (controlNode = (ControlNode)texNode.getParent()).getCommand() != null) {
                return new CommandCall(controlNode);
            }
            if (texNode instanceof ControlNode && (controlNode = (ControlNode)texNode).getCommand() != null && controlNode.getArgsStartOffset() <= this.getStartOffset() && controlNode.getEndOffset() >= this.getEndOffset()) {
                return new CommandCall(controlNode);
            }
        }
        return null;
    }

    public @Nullable CommandCall getCommandCall(boolean direct) {
        if (this.invocationChecked == 0) {
            this.invocationChecked = 1;
            this.invocationDirect = this.searchCommandCall(true);
        }
        if (direct) {
            return this.invocationDirect;
        }
        if (this.invocationChecked == 1) {
            this.invocationChecked = 2;
            this.invocationAny = this.invocationDirect != null ? this.invocationDirect : this.searchCommandCall(false);
        }
        return this.invocationAny;
    }

    public class CommandCall {
        private final ControlNode controlNode;
        private final @Nullable TexAstNode[] argNodes;
        private final int invocationArgIdx;

        private CommandCall(ControlNode controlNode) {
            ObjectUtils.nonNullAssert((Object)controlNode.getCommand());
            this.controlNode = controlNode;
            this.argNodes = TexAsts.resolveArguments((ControlNode)controlNode);
            this.invocationArgIdx = TexAsts.getIndexAt((TexAstNode[])this.argNodes, (int)LtxAssistInvocationContext.this.getInvocationOffset());
        }

        public final ControlNode getControlNode() {
            return this.controlNode;
        }

        public final TexCommand getCommand() {
            return this.controlNode.getCommand();
        }

        public final @Nullable TexAstNode getArgNode(int argIdx) {
            return this.argNodes[argIdx];
        }

        public final int getInvocationArgIdx() {
            return this.invocationArgIdx;
        }
    }
}

