/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.eclipse.statet.internal.rj.servi.Messages;
import org.eclipse.statet.internal.rj.servi.NodeFactory;
import org.eclipse.statet.internal.rj.servi.NodeHandler;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.Server;
import org.eclipse.statet.rj.server.ServerLogin;
import org.eclipse.statet.rj.server.util.LocalREnv;
import org.eclipse.statet.rj.server.util.RJContext;
import org.eclipse.statet.rj.server.util.ServerUtils;
import org.eclipse.statet.rj.servi.node.RServiNode;
import org.eclipse.statet.rj.servi.node.RServiNodeConfig;

@NonNullByDefault
public class LocalNodeFactory
implements NodeFactory {
    public static final ImList<BundleSpec> CODEBASE_LIB_SPECS = ServerUtils.MIN_RMI_CODEBASE_SPECS;
    private static final Set<String> EXCLUDE_ENV_VAR_NAMES = ImCollections.newSet((Object[])new String[]{"CLASSPATH", "R_HOME"});
    private final String poolId;
    private final String factoryId;
    private @Nullable RServiNodeConfig baseConfig;
    private final RJContext context;
    private final ImList<BundleSpec> libSpecs;
    private @Nullable ProcessConfig processConfig;
    private @Nullable String errorMessage = null;
    private @Nullable RMIRegistry nodeRegistry;
    private boolean verbose;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(30L);
    private final List<String> sslPropertyArgs;
    private int nodeCounter;

    private static void copySystemProperty(String key, List<String> command) {
        String property = System.getProperty(key);
        if (property != null) {
            command.add("-D" + key + "=" + property);
        }
    }

    private static void copySystemPropertyPath(String key, List<String> command) {
        String property = System.getProperty(key);
        if (property != null) {
            if (!new File(property).isAbsolute()) {
                property = new File(System.getProperty("user.dir"), property).getPath();
            }
            command.add("-D" + key + "=" + property);
        }
    }

    private static List<String> createSSLPropertyArgs() {
        ArrayList<String> args = new ArrayList<String>();
        LocalNodeFactory.copySystemPropertyPath("javax.net.ssl.keyStore", args);
        LocalNodeFactory.copySystemProperty("javax.net.ssl.keyStorePassword", args);
        LocalNodeFactory.copySystemPropertyPath("javax.net.ssl.trustStore", args);
        LocalNodeFactory.copySystemProperty("javax.net.ssl.trustStorePassword", args);
        return args;
    }

    public LocalNodeFactory(String poolId, RJContext context, List<BundleSpec> libSpecs) {
        if (poolId == null) {
            throw new NullPointerException("poolId");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.poolId = poolId;
        this.factoryId = String.format("%1$s-%2$08X", poolId, ThreadLocalRandom.current().nextInt());
        this.context = context;
        this.libSpecs = ImCollections.toList(libSpecs);
        this.sslPropertyArgs = LocalNodeFactory.createSSLPropertyArgs();
    }

    @Override
    public void setRegistry(@Nullable RMIRegistry registry) {
        this.nodeRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfig(RServiNodeConfig config) throws RjInvalidConfigurationException {
        String rArch;
        String hostname;
        ProcessConfig p = new ProcessConfig();
        StringBuilder sb = new StringBuilder();
        String value = config.getRHome();
        if (!(value != null && value.length() != 0 || (value = config.getEnvironmentVariables().get("R_HOME")) != null && value.length() != 0)) {
            this.errorMessage = "Missing value for R_HOME.";
            throw new RjInvalidConfigurationException(this.errorMessage);
        }
        String rHome = value;
        File rHomeFile = new File(rHome);
        if (!rHomeFile.exists() || !rHomeFile.isDirectory()) {
            this.errorMessage = "Invalid value for R_HOME (directory does not exists).";
            throw new RjInvalidConfigurationException(this.errorMessage);
        }
        p.addEnv.put("R_HOME", rHome);
        LocalREnv serverREnv = new LocalREnv(name -> {
            if (name.equals("R_HOME")) {
                return rHome;
            }
            return config.getEnvironmentVariables().get(name);
        });
        Path rjPkgPath = serverREnv.searchRPkg("rj");
        if (rjPkgPath == null) {
            this.errorMessage = "Can not find the R package 'rj' in the R library path:\n\t" + CollectionUtils.toString((List)serverREnv.getRLibPaths(), (String)"\n\t");
            throw new RjInvalidConfigurationException(this.errorMessage);
        }
        String javaHome = config.getJavaHome();
        if (javaHome == null || javaHome.length() == 0) {
            javaHome = (String)ObjectUtils.nonNullAssert((Object)System.getProperty("java.home"));
        }
        p.addEnv.put("JAVA_HOME", javaHome);
        p.command.add(String.valueOf(javaHome) + File.separatorChar + "bin" + File.separatorChar + "java");
        p.command.add("-classpath");
        String s = new BundleEntry.Jar("rj-boot", rjPkgPath.resolve(Paths.get("server/rj-boot.jar", new String[0]))).getJClassPathString();
        String env = config.getEnvironmentVariables().get("CLASSPATH");
        if (env != null) {
            s = String.valueOf(s) + File.pathSeparatorChar + env;
        }
        p.command.add(s);
        String javaArgs = config.getJavaArgs();
        if (javaArgs != null && (javaArgs = javaArgs.trim()).length() > 0) {
            p.command.addAll(Utils.parseArguments(javaArgs));
        } else {
            javaArgs = "";
        }
        if (javaArgs.indexOf("-Dorg.eclipse.statet.rj.server.ClassPath.urls=") < 0) {
            List bundles;
            try {
                bundles = this.context.resolveBundles(this.libSpecs);
            }
            catch (StatusException e) {
                this.errorMessage = "Can not resolve bundles for Java classpath of node - " + e.getMessage();
                throw new RjInvalidConfigurationException(this.errorMessage, (Throwable)e);
            }
            sb.setLength(0);
            sb.append("-Dorg.eclipse.statet.rj.server.ClassPath.urls=");
            sb.append(ServerUtils.concatRJClassPath((Collection)bundles));
            p.command.add(sb.toString());
        }
        if ((hostname = System.getProperty("java.rmi.server.hostname")) != null && hostname.length() > 0) {
            p.command.add("-Djava.rmi.server.hostname=" + hostname);
        }
        if (javaArgs.indexOf("-Djava.security.policy=") < 0) {
            sb.setLength(0);
            sb.append("-Djava.security.policy=");
            sb.append(this.context.getServerPolicyFilePath());
            p.command.add(sb.toString());
        }
        if (javaArgs.indexOf("-Djava.rmi.server.codebase=") < 0) {
            List bundles;
            try {
                bundles = this.context.resolveBundles(CODEBASE_LIB_SPECS);
            }
            catch (StatusException e) {
                this.errorMessage = "Can not resolve bundles for Java codebase of node - " + e.getMessage();
                throw new RjInvalidConfigurationException(this.errorMessage, (Throwable)e);
            }
            sb.setLength(0);
            sb.append("-Djava.rmi.server.codebase=");
            sb.append(ServerUtils.concatCodebase((Collection)bundles));
            p.command.add(sb.toString());
        }
        p.command.add("RJSrv");
        p.command.add("start");
        p.nameCommandIdx = p.command.size();
        p.command.add("");
        p.command.add("-server=org.eclipse.statet.internal.rj.servi.server.NodeServer");
        p.command.add("-log");
        String nodeArgs = config.getNodeArgs();
        if (nodeArgs != null && (nodeArgs = nodeArgs.trim()).length() > 0) {
            p.command.addAll(Utils.parseArguments(nodeArgs));
        }
        if ((rArch = config.getRArch()) != null && rArch.length() == 0) {
            rArch = null;
        }
        boolean rArchAuto = false;
        if (rArch == null && javaHome.equals(System.getProperty("java.home"))) {
            rArch = (String)ObjectUtils.nonNullAssert((Object)System.getProperty("os.arch"));
            if (rArch.equals("amd64")) {
                rArch = "x86_64";
            } else if (rArch.equals("x86")) {
                rArch = "i386";
            }
            rArchAuto = true;
        }
        if (rArch != null) {
            if (SystemUtils.getLocalOs() == 1) {
                if (rArch.equals("x86_64")) {
                    rArch = "x64";
                }
                if (!new File(new File(rHomeFile, "bin"), rArch).exists()) {
                    rArch = null;
                }
            } else {
                File execDir = new File(new File(rHomeFile, "bin"), "exec");
                if (!new File(execDir, rArch).exists()) {
                    rArch = execDir.exists() && (rArch.equals("i386") || rArch.equals("i586") || rArch.equals("i686")) ? (new File(execDir, "i686").exists() ? "i686" : (new File(execDir, "i586").exists() ? "i586" : (new File(execDir, "i386").exists() ? "i386" : null))) : null;
                }
            }
            if (rArch != null) {
                p.addEnv.put("R_ARCH", String.valueOf('/') + rArch);
            } else if (!rArchAuto) {
                Utils.logInfo("Failed to validate specified architecture, value is not used.");
            }
        }
        switch (SystemUtils.getLocalOs()) {
            case 1: {
                String rBinDir = rArch != null ? String.valueOf(rHome) + File.separatorChar + "bin" + File.separatorChar + rArch : String.valueOf(rHome) + File.separatorChar + "bin";
                String pathEnv = System.getenv("PATH");
                p.addEnv.put("PATH", pathEnv != null ? String.valueOf(rBinDir) + File.pathSeparatorChar + pathEnv : rBinDir);
                break;
            }
            case 2: {
                String rBinDir = String.valueOf(rHome) + File.separatorChar + "bin";
                String pathEnv = System.getenv("PATH");
                p.addEnv.put("PATH", pathEnv != null ? String.valueOf(rBinDir) + File.pathSeparatorChar + pathEnv : rBinDir);
                String rLibDir = String.valueOf(rHome) + File.separatorChar + "lib";
                String libPathEnv = System.getenv("DYLD_LIBRARY_PATH");
                p.addEnv.put("DYLD_LIBRARY_PATH", libPathEnv != null ? String.valueOf(rLibDir) + File.pathSeparatorChar + libPathEnv : rLibDir);
                break;
            }
            default: {
                String rBinDir = String.valueOf(rHome) + File.separatorChar + "bin";
                String pathEnv = System.getenv("PATH");
                p.addEnv.put("PATH", pathEnv != null ? String.valueOf(rBinDir) + File.pathSeparatorChar + pathEnv : rBinDir);
                String rLibDir = rArch != null ? String.valueOf(rHome) + File.separatorChar + "lib" + File.separatorChar + rArch : String.valueOf(rHome) + File.separatorChar + "lib";
                String libPathEnv = System.getenv("LD_LIBRARY_PATH");
                p.addEnv.put("LD_LIBRARY_PATH", libPathEnv != null ? String.valueOf(rLibDir) + File.pathSeparatorChar + libPathEnv : rLibDir);
            }
        }
        p.baseWd = config.getBaseWorkingDirectory();
        if (p.baseWd == null || p.baseWd.length() == 0) {
            p.baseWd = (String)ObjectUtils.nonNullAssert((Object)System.getProperty("java.io.tmpdir"));
        }
        if (!this.testBaseDir(p.baseWd)) {
            this.errorMessage = "Invalid working directory base path.";
            throw new RjInvalidConfigurationException(this.errorMessage);
        }
        for (Map.Entry<String, String> var : config.getEnvironmentVariables().entrySet()) {
            if (EXCLUDE_ENV_VAR_NAMES.contains(var.getKey())) continue;
            p.addEnv.put(var.getKey(), var.getValue());
        }
        p.authConfig = config.getEnableConsole() ? "none" : null;
        p.rStartupSnippet = config.getRStartupSnippet();
        long timeout = config.getStartStopTimeout();
        if (timeout > 0L) {
            timeout = TimeUnit.MILLISECONDS.toNanos(timeout);
        }
        LocalNodeFactory localNodeFactory = this;
        synchronized (localNodeFactory) {
            this.verbose = config.getEnableVerbose();
            this.baseConfig = config;
            this.processConfig = p;
            this.timeoutNanos = timeout;
        }
    }

    private boolean testBaseDir(String path) {
        File file = new File(String.valueOf(path) + File.separatorChar + this.poolId + "-test");
        if (file.isDirectory()) {
            return true;
        }
        if (file.mkdirs()) {
            file.delete();
            return true;
        }
        return false;
    }

    @Override
    public @Nullable RServiNodeConfig getConfig() {
        return this.baseConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNode(NodeHandler handler) throws RjException {
        block67: {
            StringBuilder sb;
            Exception e7;
            block68: {
                char[] buffer;
                block70: {
                    InputStreamReader reader;
                    ProcessBuilder pBuilder;
                    int counter;
                    long timeout;
                    RMIRegistry registry;
                    ProcessConfig p;
                    long t = System.nanoTime();
                    LocalNodeFactory localNodeFactory = this;
                    synchronized (localNodeFactory) {
                        p = this.processConfig;
                        if (p == null) {
                            String message = this.errorMessage;
                            throw new RjInvalidConfigurationException(message != null ? message : "Missing R node configuration.");
                        }
                        registry = this.nodeRegistry;
                        if (registry == null) {
                            throw new RjInvalidConfigurationException("Missing registry configuration.");
                        }
                        timeout = this.timeoutNanos;
                        counter = ++this.nodeCounter;
                    }
                    try {
                        this.prepareNode(handler, p.baseWd, counter, registry);
                    }
                    catch (RjException e2) {
                        try {
                            Thread.sleep(100L);
                            this.prepareNode(handler, p.baseWd, counter, registry);
                            Utils.logWarning("Preparing R node required a second attempt.", e2);
                        }
                        catch (InterruptedException | RjException e22) {
                            throw new RjException("Error preparing R node.", (Throwable)e2);
                        }
                    }
                    ArrayList<String> command = null;
                    try {
                        command = new ArrayList<String>(p.command.size() + 2);
                        command.addAll(p.command);
                        command.set(p.nameCommandIdx, handler.address.toString());
                        if (this.verbose) {
                            command.add("-verbose");
                        }
                        if (registry.getAddress().isSsl()) {
                            command.addAll(p.nameCommandIdx - 1, this.sslPropertyArgs);
                        }
                        pBuilder = new ProcessBuilder(command);
                        pBuilder.environment().remove("Path");
                        pBuilder.environment().putAll(p.addEnv);
                        pBuilder.directory(handler.dir);
                        pBuilder.redirectErrorStream(true);
                    }
                    catch (Exception e3) {
                        throw new RjException("Error preparing process for R node.", (Throwable)e3);
                    }
                    Process process = null;
                    try {
                        process = pBuilder.start();
                        int i = 1;
                        while (i < Integer.MAX_VALUE) {
                            try {
                                Server server = (Server)registry.getRegistry().lookup(handler.nodeId);
                                ServerLogin login = server.createLogin("rservi.nodecontrol");
                                RServiNode node = (RServiNode)server.execute("rservi.nodecontrol", null, login);
                                Utils.logInfo("New R node started (t=" + (System.nanoTime() - t) / 1000000L + "ms).");
                                String line = null;
                                try {
                                    if (p.rStartupSnippet != null && p.rStartupSnippet.length() > 0) {
                                        String[] lines = p.rStartupSnippet.split("\\p{Blank}*\\r[\\n]?|\\n\\p{Blank}*");
                                        int j = 0;
                                        while (j < lines.length) {
                                            line = lines[j];
                                            if (line.length() > 0) {
                                                node.runSnippet(line);
                                            }
                                            ++j;
                                        }
                                    }
                                }
                                catch (RjException e4) {
                                    try {
                                        node.shutdown();
                                    }
                                    catch (Exception j) {
                                        // empty catch block
                                    }
                                    throw new RjException("Running the R startup snippet failed in line '" + line + "'.", (Throwable)e4);
                                }
                                try {
                                    handler.isConsoleEnabled = node.setConsole(p.authConfig);
                                }
                                catch (RjException e5) {
                                    try {
                                        node.shutdown();
                                    }
                                    catch (Exception j) {
                                        // empty catch block
                                    }
                                    throw e5;
                                }
                                handler.init2(node, process);
                                return;
                            }
                            catch (NotBoundException e6) {
                                long diff = System.nanoTime() - t;
                                if (i >= 10 && timeout >= 0L && diff > timeout) {
                                    throw new RjException("Start of R node aborted because of timeout (t=" + diff / 1000000L + "ms).", (Throwable)e6);
                                }
                                try {
                                    int exitValue = process.exitValue();
                                    throw new RjException("R node process stopped (exit code= " + exitValue + ").");
                                }
                                catch (IllegalThreadStateException exitValue) {
                                    Thread.sleep(250L);
                                    ++i;
                                }
                            }
                        }
                        break block67;
                    }
                    catch (Exception e7) {
                        sb = new StringBuilder("Error starting R node:");
                        if (pBuilder != null) {
                            sb.append("\n<COMMAND>");
                            ServerUtils.prettyPrint(pBuilder.command(), (StringBuilder)sb);
                            sb.append("\n</COMMAND>");
                        }
                        if (process == null) break block68;
                        buffer = new char[4096];
                        InputStream stdout = process.getInputStream();
                        sb.append("\n<STDOUT>\n");
                        reader = new InputStreamReader(stdout);
                        try {
                            int n;
                            while (reader.ready() && (n = reader.read(buffer, 0, buffer.length)) >= 0) {
                                sb.append(buffer, 0, n);
                            }
                        }
                        catch (IOException n) {
                            // empty catch block
                        }
                    }
                    process.destroy();
                    try {
                        try {
                            int n;
                            while ((n = reader.read(buffer, 0, buffer.length)) >= 0) {
                                sb.append(buffer, 0, n);
                            }
                        }
                        catch (IOException n) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block70;
                        }
                    }
                    catch (Throwable j) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw j;
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                sb.append("</STDOUT>");
                File logfile = new File(handler.dir, "out.log");
                if (logfile.exists()) {
                    block72: {
                        sb.append("\n<LOG file=\"out.log\">\n");
                        FileReader reader = null;
                        try {
                            try {
                                int n;
                                reader = new FileReader(logfile);
                                while ((n = reader.read(buffer, 0, buffer.length)) >= 0) {
                                    sb.append(buffer, 0, n);
                                    if (sb.length() <= 100000) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (IOException iOException) {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                break block72;
                            }
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    sb.append("</LOG>");
                }
                sb.append("\n--------");
            }
            Thread.interrupted();
            if (handler.dir.exists() && handler.dir.isDirectory()) {
                ServerUtils.delDir((File)handler.dir);
            }
            throw new RjException(sb.toString(), (Throwable)e7);
        }
    }

    protected void prepareNode(NodeHandler handler, String baseWd, int counter, RMIRegistry registry) throws RjException {
        String id = String.format("%1$s-%2$016X-%3$08X", this.factoryId, System.nanoTime(), counter);
        Path path = Paths.get(baseWd, id);
        RMIAddress rmiAddress = new RMIAddress(registry.getAddress(), id);
        try {
            handler.init1(id, rmiAddress, Files.createDirectory(path, new FileAttribute[0]));
        }
        catch (IOException e) {
            throw new RjException(String.format("Failed to create working directory '%1$s'.", path), (Throwable)e);
        }
    }

    @Override
    public void stopNode(NodeHandler handler) {
        int i;
        long t = System.nanoTime();
        long timeout = this.timeoutNanos;
        try {
            handler.shutdown();
        }
        catch (Throwable e) {
            Utils.logWarning(Messages.ShutdownNode_error_message, e);
        }
        Process process = handler.process;
        handler.process = null;
        if (process != null) {
            i = 0;
            while (i < Integer.MAX_VALUE) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    process.exitValue();
                    break;
                }
                catch (IllegalThreadStateException e) {
                    long diff = System.nanoTime() - t;
                    if (i >= 10 && timeout >= 0L && diff > timeout) {
                        process.destroy();
                        Utils.logWarning(String.format("Killed RServi node '%1$s'.", handler.address != null ? handler.address.getName() : "<address not available>"));
                        break;
                    }
                    ++i;
                }
            }
        }
        if (!this.verbose && handler.dir != null && handler.dir.exists() && handler.dir.isDirectory()) {
            i = 0;
            while (i < 20) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!handler.dir.exists() || ServerUtils.delDir((File)handler.dir)) {
                    return;
                }
                ++i;
            }
            Utils.logWarning("Failed to delete the RServi node working directory '" + handler.dir.toString() + "'.");
        }
    }

    private static class ProcessConfig {
        final Map<String, String> addEnv = new HashMap<String, String>();
        final List<String> command = new ArrayList<String>();
        int nameCommandIdx = -1;
        String baseWd;
        String authConfig;
        String rStartupSnippet;

        private ProcessConfig() {
        }
    }
}

