/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.ltk.ui.sourceediting.FragmentDocumentProvider;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.r.core.source.RDocumentSetupParticipant;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class RFragmentDocumentProvider
extends FragmentDocumentProvider {
    private final Map<ToolProcess, ProcessListener> fProcesses = new HashMap<ToolProcess, ProcessListener>();

    public RFragmentDocumentProvider() {
        super("R", (PartitionerDocumentSetupParticipant)new RDocumentSetupParticipant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        ToolProcess process;
        AbstractDocumentProvider.ElementInfo info = super.createElementInfo(element);
        if (info != null && element instanceof IAdaptable && (process = (ToolProcess)((IAdaptable)element).getAdapter(ToolProcess.class)) != null) {
            Map<ToolProcess, ProcessListener> map = this.fProcesses;
            synchronized (map) {
                ProcessListener listener = this.fProcesses.get(process);
                if (listener == null) {
                    listener = new ProcessListener(process);
                }
                listener.add(element);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        ToolProcess process;
        super.disposeElementInfo(element, info);
        if (element instanceof IAdaptable && (process = (ToolProcess)((IAdaptable)element).getAdapter(ToolProcess.class)) != null) {
            Map<ToolProcess, ProcessListener> map = this.fProcesses;
            synchronized (map) {
                ProcessListener listener = this.fProcesses.get(process);
                if (listener != null) {
                    listener.remove(element);
                }
            }
        }
    }

    private class ProcessListener
    implements IDebugEventSetListener {
        private final ToolProcess fProcess;
        private final List<Object> fElements = new ArrayList<Object>(4);

        public ProcessListener(ToolProcess process) {
            this.fProcess = process;
            this.init();
        }

        private void init() {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            RFragmentDocumentProvider.this.fProcesses.put(this.fProcess, this);
        }

        private void dispose() {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
            RFragmentDocumentProvider.this.fProcesses.remove(this.fProcess);
        }

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                if (events[i].getSource() == this.fProcess && events[i].getKind() == 8) {
                    this.terminated();
                }
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void terminated() {
            Object[] elements;
            Map map = RFragmentDocumentProvider.this.fProcesses;
            synchronized (map) {
                this.dispose();
                elements = this.fElements.toArray();
                this.fElements.clear();
            }
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                RFragmentDocumentProvider.this.fireElementDeleted(element);
                ++n2;
            }
        }

        public void add(Object element) {
            this.fElements.add(element);
        }

        public void remove(Object element) {
            if (this.fElements.remove(element) && this.fElements.isEmpty()) {
                this.dispose();
            }
        }
    }
}

